/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.autoupdate.p2;

import fr.inra.adonis.autoupdate.AdonisAutoUpdate;
import fr.inra.adonis.core.util.HttpsServerConnectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.garbagecollector.GarbageCollector;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class P2Util {
    private final IMetadataRepositoryManager metadataManager;
    private final IArtifactRepositoryManager artifactManager;
    private final IProfile profile;
    private final URI repoLocation;
    private static final String AdonisFeatureId = "fr.inra.adonis.bureau.productFeature";

    public P2Util(String updateUri) throws Exception {
        HttpsServerConnectionUtils.changeDefaultSSLContext();
        this.repoLocation = new URI(updateUri);
        this.metadataManager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)AdonisAutoUpdate.bundleContext, (String)IMetadataRepositoryManager.class.getName());
        this.artifactManager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)AdonisAutoUpdate.bundleContext, (String)IArtifactRepositoryManager.class.getName());
        IProfileRegistry profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)AdonisAutoUpdate.bundleContext, (String)IProfileRegistry.class.getName());
        this.profile = profileRegistry != null ? profileRegistry.getProfile("_SELF_") : null;
    }

    public Version checkForUpdates() throws Exception {
        if (this.metadataManager == null || this.artifactManager == null || this.profile == null) {
            return null;
        }
        this.addUpdateSite();
        IPlanner planner = (IPlanner)ServiceHelper.getService((BundleContext)AdonisAutoUpdate.bundleContext, (String)IPlanner.class.getName());
        if (planner == null) {
            return null;
        }
        ArrayList<IInstallableUnit> iusWithUpdates = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> replacementIUs = new ArrayList<IInstallableUnit>();
        this.computeUpdateList(planner, null, iusWithUpdates, replacementIUs);
        if (replacementIUs.size() > 0) {
            for (IInstallableUnit iu : replacementIUs) {
                if (!AdonisFeatureId.equalsIgnoreCase(iu.getId())) continue;
                return org.eclipse.equinox.internal.provisional.p2.core.Version.toOSGiVersion((org.eclipse.equinox.internal.provisional.p2.core.Version)iu.getVersion());
            }
        }
        GarbageCollector gc = new GarbageCollector();
        gc.runGC(this.profile);
        return null;
    }

    public boolean checkAndPerformUpdates(Shell shell) throws ProvisionException {
        if (this.metadataManager == null || this.artifactManager == null || this.profile == null) {
            return false;
        }
        this.addUpdateSite();
        final IPlanner planner = (IPlanner)ServiceHelper.getService((BundleContext)AdonisAutoUpdate.bundleContext, (String)IPlanner.class.getName());
        if (planner == null) {
            MessageDialog.openError((Shell)shell, (String)"Info update", (String)"planner not found");
            return false;
        }
        final boolean[] didWeUpdate = new boolean[]{false};
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.setTaskName("Calcul des \u00e9l\u00e9ments \u00e0 mettre \u00e0 jour");
                System.out.println("Get update list: ");
                ArrayList iusWithUpdates = new ArrayList();
                ArrayList replacementIUs = new ArrayList();
                ProvisioningContext pc = P2Util.this.computeUpdateList(planner, monitor, iusWithUpdates, replacementIUs);
                didWeUpdate[0] = P2Util.this.buildAndPerformProvisiongPlan(planner, monitor, iusWithUpdates, replacementIUs, pc);
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)shell, (String)"Erreur update", (String)("Erreur lors de la mise \u00e0 jour:" + e.getMessage()));
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            MessageDialog.openInformation((Shell)shell, (String)"Info update", (String)("Mise \u00e0 jour annul\u00e9e" + e.getMessage()));
            return false;
        }
        return didWeUpdate[0];
    }

    private void addUpdateSite() throws ProvisionException {
        URI uri;
        URI[] repos;
        URI[] uRIArray = repos = this.metadataManager.getKnownRepositories(0);
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            uri = uRIArray[n2];
            if (!uri.equals(this.repoLocation)) {
                this.metadataManager.removeRepository(uri);
            }
            ++n2;
        }
        uRIArray = repos = this.artifactManager.getKnownRepositories(0);
        n = repos.length;
        n2 = 0;
        while (n2 < n) {
            uri = uRIArray[n2];
            if (!uri.equals(this.repoLocation)) {
                this.artifactManager.removeRepository(uri);
            }
            ++n2;
        }
        this.metadataManager.loadRepository(this.repoLocation, null);
        this.artifactManager.loadRepository(this.repoLocation, null);
    }

    private ProvisioningContext computeUpdateList(IPlanner planner, IProgressMonitor monitor, ArrayList<IInstallableUnit> iusWithUpdates, ArrayList<IInstallableUnit> replacementIUs) throws InterruptedException {
        URI[] reposToSearch = this.metadataManager.getKnownRepositories(0);
        System.out.println(" computeUpdateList: reposToSearch");
        if (reposToSearch.length == 0) {
            return null;
        }
        System.out.println(" computeUpdateList: query collector");
        Collector collector = this.profile.query((Query)InstallableUnitQuery.ANY, new Collector(), null);
        if (collector.isEmpty()) {
            return null;
        }
        System.out.println(" computeUpdateList: ProvisioningContext");
        ProvisioningContext pc = new ProvisioningContext(reposToSearch);
        Iterator iter = collector.iterator();
        HashSet<String> exsitingInstallableUnit = new HashSet<String>();
        while (iter.hasNext()) {
            if (monitor != null && monitor.isCanceled()) {
                throw new InterruptedException();
            }
            IInstallableUnit iu = (IInstallableUnit)iter.next();
            exsitingInstallableUnit.add(String.valueOf(iu.getId()) + iu.getVersion().toString());
            IInstallableUnit[] replacements = planner.updatesFor(iu, pc, null);
            if (replacements.length <= 0) continue;
            iusWithUpdates.add(iu);
            IInstallableUnit repl = replacements[0];
            int i = 1;
            while (i < replacements.length) {
                if (replacements[i].getVersion().compareTo((Object)repl.getVersion()) > 0) {
                    repl = replacements[i];
                }
                ++i;
            }
            replacementIUs.add(repl);
            System.out.println(String.valueOf(iu.getId()) + " version=" + iu.getVersion().toString() + " replaced by " + repl.getId() + " version:" + repl.getVersion().toString());
        }
        if (replacementIUs.size() > 0) {
            IInstallableUnit[] tmpReplacement = replacementIUs.toArray(new IInstallableUnit[replacementIUs.size()]);
            int index = tmpReplacement.length - 1;
            while (index >= 0) {
                if (exsitingInstallableUnit.contains(String.valueOf(tmpReplacement[index].getId()) + tmpReplacement[index].getVersion().toString())) {
                    replacementIUs.remove(index);
                    iusWithUpdates.remove(index);
                    System.out.println("Existe d\u00e9j\u00e0 REMOVE =" + tmpReplacement[index].getId() + " version:" + tmpReplacement[index].getVersion().toString());
                }
                --index;
            }
        }
        System.out.println(" computeUpdateList: Fin");
        return pc;
    }

    private boolean buildAndPerformProvisiongPlan(IPlanner planner, IProgressMonitor monitor, ArrayList<IInstallableUnit> iusWithUpdates, ArrayList<IInstallableUnit> replacementIUs, ProvisioningContext pc) throws InterruptedException {
        boolean updateDone = false;
        if (pc != null && iusWithUpdates.size() > 0) {
            IEngine engine;
            this.traceDebugIU(iusWithUpdates, replacementIUs);
            if (monitor != null && monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ProfileChangeRequest changeRequest = new ProfileChangeRequest(this.profile);
            changeRequest.removeInstallableUnits(iusWithUpdates.toArray(new IInstallableUnit[iusWithUpdates.size()]));
            changeRequest.addInstallableUnits(replacementIUs.toArray(new IInstallableUnit[replacementIUs.size()]));
            ProvisioningPlan plan = planner.getProvisioningPlan(changeRequest, pc, monitor);
            if (plan.getStatus().getSeverity() == 8) {
                throw new InterruptedException();
            }
            System.out.println("ProvisioningPlan Status =" + plan.getStatus());
            if (plan.getStatus().getSeverity() != 4 && (engine = (IEngine)ServiceHelper.getService((BundleContext)AdonisAutoUpdate.bundleContext, (String)IEngine.class.getName())) != null) {
                System.out.println("Perform the provisioning plan");
                monitor.subTask("Mise \u00e0 jour des plugins");
                pc.setArtifactRepositories(this.artifactManager.getKnownRepositories(0));
                IStatus status = engine.perform(this.profile, (PhaseSet)new DefaultPhaseSet(), plan.getOperands(), pc, monitor);
                if (status.getSeverity() == 8) {
                    throw new InterruptedException();
                }
                if (status.getSeverity() != 4) {
                    updateDone = true;
                }
                monitor.done();
                System.out.println("STATUS FINAL =" + status.toString());
            }
        }
        return updateDone;
    }

    private void traceDebugIU(ArrayList<IInstallableUnit> iusWithUpdates, ArrayList<IInstallableUnit> replacementIUs) {
        System.out.println(" Update trouv\u00e9e!!!!");
        String iuName = "";
        for (IInstallableUnit iu : iusWithUpdates) {
            iuName = String.valueOf(iuName) + "\n-" + iu.getId();
        }
        String iuReplacementName = "";
        for (IInstallableUnit iu : replacementIUs) {
            iuReplacementName = String.valueOf(iuReplacementName) + "\n-" + iu.getId();
        }
        System.out.println("update list: On a trouv\u00e9!!" + iuName + "\n remplacement par:" + iuReplacementName);
    }
}

