/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.aggregation.AggrDefnRoundManager;
import org.eclipse.birt.data.engine.executor.aggregation.AggregationHelper;
import org.eclipse.birt.data.engine.executor.dscache.DataSetToCache;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.executor.transform.IComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.pass.DataSetProcessUtil;
import org.eclipse.birt.data.engine.executor.transform.pass.PassStatusController;
import org.eclipse.birt.data.engine.executor.transform.pass.PassUtil;
import org.eclipse.birt.data.engine.executor.transform.pass.ResultSetProcessUtil;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.script.OnFetchScriptHelper;

public class PassManager {
    private ResultSetPopulator populator;
    private ComputedColumnHelper computedColumnHelper;
    private FilterByRow filterByRow;
    private DataEngineSession session;

    private PassManager(ResultSetPopulator populator, DataEngineSession session) {
        this.populator = populator;
        this.session = session;
    }

    public static void populateResultSet(ResultSetPopulator populator, OdiResultSetWrapper odaResultSet, DataEngineSession session) throws DataException {
        new PassManager(populator, session).pass(odaResultSet);
    }

    private void pass(OdiResultSetWrapper odaResultSet) throws DataException {
        this.prepareFetchEventList();
        PassStatusController psController = new PassStatusController(this.populator, this.filterByRow, this.computedColumnHelper);
        if (!psController.needMultipassProcessing()) {
            this.doSinglePass(odaResultSet);
        } else {
            this.doMultiPass(odaResultSet, psController);
        }
        this.calculateAggregationsInColumnBinding();
        ExpressionCompiler compiler = new ExpressionCompiler();
        compiler.setDataSetMode(false);
        Iterator it = this.populator.getEventHandler().getColumnBindings().values().iterator();
        while (it.hasNext()) {
            try {
                IBinding binding = (IBinding)it.next();
                compiler.compile(binding.getExpression(), this.populator.getSession().getEngineContext().getScriptContext());
            }
            catch (DataException dataException) {}
        }
        this.populateAggregationInBinding();
    }

    private void populateAggregationInBinding() throws DataException {
        this.populator.getExpressionProcessor().setResultIterator(this.populator.getResultIterator());
        this.populator.getResultIterator().clearAggrValueHolder();
        List aggrDefns = this.populator.getEventHandler().getAggrDefinitions();
        AggrDefnRoundManager factory = new AggrDefnRoundManager(aggrDefns);
        int i = 0;
        while (i < factory.getRound()) {
            AggregationHelper helper = new AggregationHelper(factory.getAggrDefnManager(i), this.populator);
            this.populator.getResultIterator().addAggrValueHolder(helper);
            ++i;
        }
    }

    private void prepareFetchEventList() {
        Object[] fetchEventsList = PassManager.getFetchEventListFromQuery(this.populator);
        int i = 0;
        while (i < fetchEventsList.length) {
            if (fetchEventsList[i] instanceof ComputedColumnHelper) {
                this.computedColumnHelper = (ComputedColumnHelper)fetchEventsList[i];
            } else if (fetchEventsList[i] instanceof FilterByRow) {
                this.filterByRow = (FilterByRow)fetchEventsList[i];
            }
            ++i;
        }
    }

    private void doSinglePass(OdiResultSetWrapper odaResultSet) throws DataException {
        if (this.computedColumnHelper != null) {
            this.computedColumnHelper.setModel(0);
        }
        PassUtil.pass(this.populator, odaResultSet, false);
        this.populator.getExpressionProcessor().setDataSetMode(false);
        this.removeOnFetchScriptHelper();
        this.handleEndOfDataSetProcess();
        this.saveDataSetResult(odaResultSet);
    }

    private void removeOnFetchScriptHelper() {
        if (this.populator.getQuery().getFetchEvents() == null) {
            return;
        }
        Iterator it = this.populator.getQuery().getFetchEvents().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof OnFetchScriptHelper)) continue;
            it.remove();
        }
    }

    private void doMultiPass(OdiResultSetWrapper odaResultSet, PassStatusController psController) throws DataException {
        ComputedColumnsState iccState = null;
        if (this.computedColumnHelper != null) {
            iccState = new ComputedColumnsState(this.computedColumnHelper);
        }
        this.doPopulation(odaResultSet, iccState, psController);
    }

    private void saveDataSetResult(OdiResultSetWrapper rsWrapper) throws DataException {
        Object resultSource = rsWrapper.getWrappedOdiResultSet();
        assert (resultSource != null);
        if (resultSource instanceof DataSetToCache) {
            DataSetToCache dstc = (DataSetToCache)resultSource;
            CachedResultSet itr = this.populator.getResultIterator();
            dstc.saveDataSetResult(itr);
        }
    }

    private static Object[] getFetchEventListFromQuery(ResultSetPopulator rsp) {
        Object[] fetchEventsList = null;
        fetchEventsList = rsp.getQuery().getFetchEvents() == null ? new Object[]{} : rsp.getQuery().getFetchEvents().toArray();
        return fetchEventsList;
    }

    private void doPopulation(OdiResultSetWrapper odaResultSet, ComputedColumnsState iccState, PassStatusController psController) throws DataException {
        List<Object> cachedSorting = Arrays.asList(this.populator.getQuery().getOrdering() == null ? new Object[]{} : this.populator.getQuery().getOrdering());
        this.populator.getQuery().setOrdering(new ArrayList());
        this.populator.getExpressionProcessor().setDataSetMode(true);
        this.populateResultSetCacheInResultSetPopulator(odaResultSet);
        DataSetProcessUtil.doPopulate(this.populator, iccState, this.computedColumnHelper, this.filterByRow, psController);
        this.handleEndOfDataSetProcess();
        this.saveDataSetResult(odaResultSet);
        this.populator.getExpressionProcessor().setDataSetMode(false);
        ResultSetProcessUtil.doPopulate(this.populator, iccState, this.computedColumnHelper, this.filterByRow, psController, cachedSorting);
    }

    private void populateResultSetCacheInResultSetPopulator(OdiResultSetWrapper odaResultSet) throws DataException {
        int max = 0;
        if (this.computedColumnHelper != null) {
            this.computedColumnHelper.setModel(5);
        }
        if (this.filterByRow != null) {
            this.filterByRow.setWorkingFilterSet(4);
        }
        max = this.populator.getQuery().getMaxRows();
        if (this.filterByRow != null) {
            this.populator.getQuery().setMaxRows(0);
        }
        PassUtil.pass(this.populator, odaResultSet, false);
        this.removeOnFetchScriptHelper();
        this.populator.getQuery().setMaxRows(max);
    }

    private void handleEndOfDataSetProcess() throws DataException {
        IEventHandler eventHandler = this.populator.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleEndOfDataSetProcess(this.populator.getResultIterator());
        }
    }

    private void calculateAggregationsInColumnBinding() throws DataException {
        IExpressionProcessor ep = this.populator.getExpressionProcessor();
        Map results = this.populator.getEventHandler().getColumnBindings();
        DummyICCState iccState = new DummyICCState(results);
        ep.setResultIterator(this.populator.getResultIterator());
        while (!iccState.isFinish()) {
            ep.evaluateMultiPassExprOnCmp(iccState, false);
        }
    }

    private class DummyICCState
    implements IComputedColumnsState {
        private Object[] exprs;
        private Object[] names;
        private boolean[] isValueAvailable;

        DummyICCState(Map columnMappings) throws DataException {
            this.exprs = columnMappings.values().toArray();
            this.names = columnMappings.keySet().toArray();
            this.isValueAvailable = new boolean[this.exprs.length];
        }

        public boolean isValueAvailable(int index) {
            return this.isValueAvailable[index];
        }

        public String getName(int index) {
            return this.names[index].toString();
        }

        public IBaseExpression getExpression(int index) throws DataException {
            return ((IBinding)this.exprs[index]).getExpression();
        }

        public void setValueAvailable(int index) {
            this.isValueAvailable[index] = true;
        }

        public int getCount() {
            return this.isValueAvailable.length;
        }

        public IComputedColumn getComputedColumn(int index) {
            return null;
        }

        public void setModel(int model) {
        }

        public boolean isFinish() {
            int i = 0;
            while (i < this.isValueAvailable.length) {
                if (!this.isValueAvailable[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

