/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.IServiceForResultSet;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.eclipse.birt.data.engine.impl.RowIDUtil;
import org.eclipse.birt.data.engine.impl.SummaryGroupLevelCalculator;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.mozilla.javascript.Scriptable;

class ResultIterator2
extends ResultIterator {
    private int lowestGroupLevel;
    private int currRowIndex;
    private int cachedRowId;
    private boolean isSummary;
    private SummaryGroupLevelCalculator groupLevelCalculator;
    private static Logger logger = Logger.getLogger(ResultIterator2.class.getName());

    ResultIterator2(IServiceForResultSet rService, IResultIterator odiResult, Scriptable scope, int rawIdStartingValue) throws DataException {
        super(rService, odiResult, scope, rawIdStartingValue);
        Object[] params = new Object[]{rService, odiResult, scope};
        logger.entering(ResultIterator2.class.getName(), "ResultIterator2", params);
        this.lowestGroupLevel = rService.getQueryDefn().getGroups().size();
        this.currRowIndex = -1;
        this.cachedRowId = 0;
        boolean bl = this.isSummary = rService.getQueryDefn() instanceof IQueryDefinition ? ((IQueryDefinition)rService.getQueryDefn()).isSummaryQuery() : false;
        if (this.isSummary) {
            if (this.lowestGroupLevel == 0) {
                this.groupLevelCalculator = new SummaryGroupLevelCalculator(null);
            } else {
                int[][] groupIndex = new int[this.lowestGroupLevel + 1][];
                int i = 0;
                while (i <= this.lowestGroupLevel) {
                    groupIndex[i] = this.odiResult.getGroupStartAndEndIndex(i);
                    ++i;
                }
                this.groupLevelCalculator = new SummaryGroupLevelCalculator(groupIndex);
            }
        }
        logger.exiting(ResultIterator2.class.getName(), "ResultIterator2");
    }

    public boolean next() throws BirtException {
        boolean hasNext = super.next();
        if (hasNext) {
            ++this.currRowIndex;
        } else if (this.currRowIndex == -1) {
            this.cachedRowId = -1;
        }
        return hasNext;
    }

    protected boolean hasNextRow() throws DataException {
        boolean result = false;
        int index = this.odiResult.getCurrentResultIndex();
        this.odiResult.last(this.lowestGroupLevel);
        if (this.isSummary) {
            result = this.odiResult.next();
        } else {
            boolean shouldMoveForward = false;
            if (index != this.odiResult.getCurrentResultIndex()) {
                result = this.odiResult.getCurrentResult() != null;
                shouldMoveForward = false;
            } else {
                shouldMoveForward = true;
            }
            if (shouldMoveForward) {
                result = this.odiResult.next();
            }
        }
        if (result) {
            IResultObject ob;
            if (this.rowIDUtil == null) {
                this.rowIDUtil = new RowIDUtil();
            }
            this.cachedRowId = this.rowIDUtil.getMode(this.odiResult) == 1 ? this.odiResult.getCurrentResultIndex() : ((ob = this.odiResult.getCurrentResult()) == null ? -1 : (Integer)ob.getFieldValue(this.rowIDUtil.getRowIdPos()));
        }
        return result;
    }

    public int getRowId() throws BirtException {
        return this.cachedRowId;
    }

    public int getEndingGroupLevel() throws DataException {
        if (this.isSummary) {
            return this.groupLevelCalculator.getEndingGroupLevel(this.odiResult.getCurrentResultIndex());
        }
        return super.getEndingGroupLevel();
    }

    public int getRowIndex() throws BirtException {
        return this.currRowIndex;
    }

    public void moveTo(int rowIndex) throws BirtException {
        if (rowIndex < 0 || rowIndex < this.currRowIndex) {
            throw new DataException("data.engine.invalidRowIndex", new Integer(rowIndex));
        }
        if (rowIndex == this.currRowIndex) {
            return;
        }
        int gapRows = rowIndex - this.currRowIndex;
        int i = 0;
        while (i < gapRows) {
            if (!this.next()) {
                throw new DataException("data.engine.invalidRowIndex", new Integer(rowIndex));
            }
            ++i;
        }
    }

    protected void goThroughGapRows(int groupLevel) throws DataException, BirtException {
        this.odiResult.last(groupLevel);
    }
}

