/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.FilterDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;

public class QueryResultIDManager {
    public static String getNextID(DataEngineSession session, String rootQueryResultID) throws DataException {
        StreamManager streamManager = new StreamManager(session.getEngineContext(), new QueryResultInfo(rootQueryResultID, null, -1));
        Set idSet = QueryResultIDManager.getIDMap(streamManager).keySet();
        String queryID = null;
        while (idSet.contains(queryID = session.getQueryResultIDUtil().nextID())) {
        }
        return queryID;
    }

    public static void appendChildToRoot(StreamManager streamManager, List filterList) throws DataException {
        Map idMap = QueryResultIDManager.getIDMap(streamManager);
        try {
            OutputStream os = streamManager.getOutStream(61, 0, 0);
            DataOutputStream dos = new DataOutputStream(os);
            int size = idMap.size();
            IOUtil.writeInt((OutputStream)dos, (int)(size + 1));
            if (size > 0) {
                Set entrySet = idMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    IOUtil.writeString((DataOutputStream)dos, (String)((String)entry.getKey()));
                    IOUtil.writeInt((OutputStream)dos, (int)((Integer)entry.getValue()));
                }
            }
            IOUtil.writeString((DataOutputStream)dos, (String)streamManager.getQueryResultUID());
            IOUtil.writeInt((OutputStream)dos, (int)FilterDefnUtil.hashCode(filterList));
            dos.close();
            os.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    public static void cleanChildOfRoot(StreamManager streamManager) throws DataException {
        if (!streamManager.hasInStream(61, 0, 0)) {
            return;
        }
        Map map = QueryResultIDManager.getIDMap(streamManager);
        for (Map.Entry entry : map.entrySet()) {
            String queryID = (String)entry.getKey();
            String _2partID = QueryResultIDUtil.get2PartID(queryID);
            streamManager.dropStream2(_2partID);
        }
    }

    private static Map getIDMap(StreamManager streamManager) throws DataException {
        LinkedHashMap<String, Integer> idMap = new LinkedHashMap<String, Integer>();
        if (streamManager.hasInStream(61, 0, 0)) {
            try {
                RAInputStream is = streamManager.getInStream(61, 0, 0);
                BufferedInputStream buffIs = new BufferedInputStream((InputStream)is);
                DataInputStream dis = new DataInputStream(buffIs);
                int existingNum = IOUtil.readInt((InputStream)buffIs);
                int i = 0;
                while (i < existingNum) {
                    idMap.put(IOUtil.readString((DataInputStream)dis), new Integer(IOUtil.readInt((InputStream)dis)));
                    ++i;
                }
                dis.close();
                buffIs.close();
                is.close();
            }
            catch (IOException e) {
                throw new DataException("data.engine.LoadReportDocumentError", e);
            }
        }
        return idMap;
    }
}

