/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.cursor.Accessor;
import org.eclipse.birt.data.engine.olap.cursor.ComparableObject;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.IEdgeAxis;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.Relationship;

public class AggregationAccessor
extends Accessor {
    private BirtCubeView view;
    private IResultSet resultSet;
    private Map relationMap;
    private int[] currentPosition;
    private boolean firstNextMeasure = true;
    private IAggregationResultSet maxAggregationResultSet = null;
    private EdgeCursor rowEdgeCursor = null;
    private EdgeCursor columnEdgeCursor = null;
    private EdgeCursor pageEdgeCursor = null;
    private Relationship maxRelationship = null;
    private int[] rowLevelIndexs;
    private int[] columnLevelIndexs;
    private int[] pageLevelIndexs;
    private ComparableObject[] rowCursorObjs;
    private ComparableObject[] columnCursorObjs;
    private ComparableObject[] pageCursorObjs;

    public AggregationAccessor(BirtCubeView view, IResultSet result, Map relationMap) {
        this.resultSet = result;
        this.view = view;
        this.relationMap = relationMap;
        if (result == null || result.getMeasureResult() == null) {
            return;
        }
        this.currentPosition = new int[this.resultSet.getMeasureResult().length];
        int i = 0;
        while (i < this.resultSet.getMeasureResult().length) {
            try {
                if (this.resultSet.getMeasureResult()[i].getQueryResultSet().length() > 0) {
                    this.resultSet.getMeasureResult()[i].getQueryResultSet().seek(0);
                    this.currentPosition[i] = 0;
                } else {
                    this.currentPosition[i] = -1;
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        this.initMeasureNavigator();
    }

    private void initMeasureNavigator() {
        int j;
        DimLevel level;
        IEdgeAxis[] edgeAxises = this.resultSet.getMeasureResult();
        int measureMaxSize = 0;
        int i = 0;
        while (i < edgeAxises.length) {
            if (edgeAxises[i].getQueryResultSet().getAllLevels() != null && edgeAxises[i].getQueryResultSet().getAllLevels().length > measureMaxSize) {
                this.maxAggregationResultSet = edgeAxises[i].getQueryResultSet();
                measureMaxSize = edgeAxises[i].getQueryResultSet().getAllLevels().length;
            }
            ++i;
        }
        Iterator iterator = this.relationMap.values().iterator();
        int relationMaxLevelSize = 0;
        while (iterator.hasNext()) {
            Relationship relation = (Relationship)iterator.next();
            int levelSize = relation.getLevelListOnColumn().size() + relation.getLevelListOnPage().size() + relation.getLevelListOnRow().size();
            if (levelSize <= relationMaxLevelSize) continue;
            relationMaxLevelSize = levelSize;
            this.maxRelationship = relation;
        }
        if (this.view.getRowEdgeView() != null) {
            this.rowEdgeCursor = this.view.getRowEdgeView().getEdgeCursor();
        }
        if (this.view.getColumnEdgeView() != null) {
            this.columnEdgeCursor = this.view.getColumnEdgeView().getEdgeCursor();
        }
        if (this.view.getPageEdgeView() != null) {
            this.pageEdgeCursor = this.view.getPageEdgeView().getEdgeCursor();
        }
        DimLevel[] measureLevels = this.maxAggregationResultSet.getAllLevels();
        this.rowLevelIndexs = new int[this.maxRelationship.getLevelListOnRow().size()];
        int i2 = 0;
        while (i2 < this.rowLevelIndexs.length) {
            level = (DimLevel)this.maxRelationship.getLevelListOnRow().get(i2);
            j = 0;
            while (j < measureLevels.length) {
                if (level.equals(measureLevels[j])) {
                    this.rowLevelIndexs[i2] = j;
                }
                ++j;
            }
            ++i2;
        }
        this.columnLevelIndexs = new int[this.maxRelationship.getLevelListOnColumn().size()];
        i2 = 0;
        while (i2 < this.columnLevelIndexs.length) {
            level = (DimLevel)this.maxRelationship.getLevelListOnColumn().get(i2);
            j = 0;
            while (j < measureLevels.length) {
                if (level.equals(measureLevels[j])) {
                    this.columnLevelIndexs[i2] = j;
                }
                ++j;
            }
            ++i2;
        }
        this.pageLevelIndexs = new int[this.maxRelationship.getLevelListOnPage().size()];
        i2 = 0;
        while (i2 < this.pageLevelIndexs.length) {
            level = (DimLevel)this.maxRelationship.getLevelListOnPage().get(i2);
            j = 0;
            while (j < measureLevels.length) {
                if (level.equals(measureLevels[j])) {
                    this.pageLevelIndexs[i2] = j;
                }
                ++j;
            }
            ++i2;
        }
    }

    public void close() throws OLAPException {
        if (this.resultSet == null || this.resultSet.getMeasureResult() == null) {
            return;
        }
        ArrayList<IOException> errorList = new ArrayList<IOException>();
        int i = 0;
        while (i < this.resultSet.getMeasureResult().length) {
            try {
                this.resultSet.getMeasureResult()[i].getQueryResultSet().close();
            }
            catch (IOException e) {
                errorList.add(e);
            }
            ++i;
        }
        if (!errorList.isEmpty()) {
            throw new OLAPException(((IOException)errorList.get(0)).getLocalizedMessage());
        }
    }

    public Object getObject(int arg0) throws OLAPException {
        if (this.resultSet == null || this.resultSet.getMeasureResult() == null) {
            return null;
        }
        try {
            String aggrName = this.view.getAggregationRegisterTable().getAggrName(arg0);
            int id = this.view.getAggregationRegisterTable().getAggregationResultID(aggrName);
            int index = this.view.getAggregationRegisterTable().getAggregationIndex(id, aggrName);
            if (this.synchronizedWithEdge(index, aggrName, this.getCurrentValueOnEdge(aggrName))) {
                return this.resultSet.getMeasureResult()[id].getQueryResultSet().getAggregationValue(index);
            }
            return null;
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
        catch (DataException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
    }

    public Object getObject(String arg0) throws OLAPException {
        if (this.resultSet == null || this.resultSet.getMeasureResult() == null) {
            return null;
        }
        try {
            int id = this.view.getAggregationRegisterTable().getAggregationResultID(arg0);
            int index = this.view.getAggregationRegisterTable().getAggregationIndex(id, arg0);
            if (this.synchronizedWithEdge(id, arg0, this.getCurrentValueOnEdge(arg0))) {
                return this.resultSet.getMeasureResult()[id].getQueryResultSet().getAggregationValue(index);
            }
            return null;
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
        catch (DataException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
    }

    public boolean synchronizedWithEdge(int aggrIndex, String aggrName, Map valueMap) throws OLAPException, IOException, DataException {
        IAggregationResultSet rs = this.resultSet.getMeasureResult()[aggrIndex].getQueryResultSet();
        if (rs == null || rs.length() <= 0) {
            return false;
        }
        if (valueMap == null) {
            return true;
        }
        CalculatedMember member = this.view.getAggregationRegisterTable().getCalculatedMember(aggrName);
        List memberList = member.getCubeAggrDefn().getAggrLevelsInAggregationResult();
        if (Arrays.deepEquals(rs.getAllLevels(), member.getCubeAggrDefn().getAggrLevelsInDefinition().toArray())) {
            return this.findValueMatcher(rs, memberList, valueMap, aggrIndex);
        }
        return this.findValueMatcherOneByOne(rs, memberList, valueMap, aggrIndex);
    }

    public boolean nextMeasure() throws IOException, OLAPException {
        int pos = this.maxAggregationResultSet.getPosition();
        if (this.firstNextMeasure) {
            if (pos >= this.maxAggregationResultSet.length()) {
                return false;
            }
            this.firstNextMeasure = false;
        } else {
            if (pos + 1 >= this.maxAggregationResultSet.length()) {
                return false;
            }
            this.maxAggregationResultSet.seek(pos + 1);
        }
        DimLevel[] levels = this.maxAggregationResultSet.getAllLevels();
        Object[] keyValues = new Object[levels.length];
        int i = 0;
        while (i < levels.length) {
            keyValues[i] = this.maxAggregationResultSet.getLevelKeyValue(i)[0];
            ++i;
        }
        if (this.view.getRowEdgeView() != null && this.rowEdgeCursor == null) {
            this.rowEdgeCursor = this.view.getRowEdgeView().getEdgeCursor();
            this.rowCursorObjs = this.fetcheObjects(this.rowEdgeCursor, this.maxRelationship.getLevelListOnRow());
        }
        if (this.view.getColumnEdgeView() != null && this.columnEdgeCursor == null) {
            this.columnEdgeCursor = this.view.getColumnEdgeView().getEdgeCursor();
            this.columnCursorObjs = this.fetcheObjects(this.columnEdgeCursor, this.maxRelationship.getLevelListOnColumn());
        }
        if (this.view.getPageEdgeView() != null && this.pageEdgeCursor == null) {
            this.pageEdgeCursor = this.view.getPageEdgeView().getEdgeCursor();
            this.pageCursorObjs = this.fetcheObjects(this.pageEdgeCursor, this.maxRelationship.getLevelListOnPage());
        }
        if (this.rowEdgeCursor != null) {
            this.moveEdgeCursor(this.rowEdgeCursor, this.rowLevelIndexs, this.rowCursorObjs, levels, keyValues);
        }
        if (this.columnEdgeCursor != null) {
            this.moveEdgeCursor(this.columnEdgeCursor, this.columnLevelIndexs, this.columnCursorObjs, levels, keyValues);
        }
        if (this.pageEdgeCursor != null) {
            this.moveEdgeCursor(this.pageEdgeCursor, this.pageLevelIndexs, this.pageCursorObjs, levels, keyValues);
        }
        return true;
    }

    private ComparableObject[] fetcheObjects(EdgeCursor edgeCursor, List edgeLevels) throws OLAPException {
        ArrayList<ComparableObject> objList = new ArrayList<ComparableObject>();
        if (!edgeCursor.first()) {
            return new ComparableObject[0];
        }
        Object[] cursorValues = this.getCursorValues(edgeCursor, edgeLevels);
        objList.add(new ComparableObject(cursorValues, edgeCursor.getPosition()));
        while (edgeCursor.next()) {
            cursorValues = this.getCursorValues(edgeCursor, edgeLevels);
            objList.add(new ComparableObject(cursorValues, edgeCursor.getPosition()));
        }
        Object[] objArray = objList.toArray(new ComparableObject[0]);
        Arrays.sort(objArray);
        return objArray;
    }

    private boolean moveEdgeCursor(EdgeCursor cursor, int[] levelIndexs, ComparableObject[] cursorObjs, DimLevel[] levels, Object[] keyValues) throws OLAPException {
        Object[] cursorkeyValues = new Object[levelIndexs.length];
        int i = 0;
        while (i < cursorkeyValues.length) {
            cursorkeyValues[i] = keyValues[levelIndexs[i]];
            ++i;
        }
        int index = Arrays.binarySearch(cursorObjs, new ComparableObject(cursorkeyValues, 0L));
        if (index < 0) {
            return false;
        }
        cursor.setPosition(cursorObjs[index].getIndex());
        return true;
    }

    private Object[] getCursorValues(EdgeCursor cursor, List edgeLevels) throws OLAPException {
        List dimCursors = cursor.getDimensionCursor();
        Object[] cursorValue = new Object[edgeLevels.size()];
        int i = 0;
        while (i < edgeLevels.size()) {
            DimensionCursor dimCursor = (DimensionCursor)dimCursors.get(i);
            DimLevel level = (DimLevel)edgeLevels.get(i);
            cursorValue[i] = dimCursor.getObject(level.getLevelName());
            ++i;
        }
        return cursorValue;
    }

    private Map getCurrentValueOnEdge(String aggrName) throws OLAPException {
        Object value;
        DimensionCursor cursor;
        DimLevel level;
        EdgeCursor rowEdgeCursor = null;
        EdgeCursor columnEdgeCursor = null;
        EdgeCursor pageEdgeCursor = null;
        List columnDimList = null;
        List rowDimList = null;
        List pageDimList = null;
        if (this.view.getRowEdgeView() != null && (rowEdgeCursor = this.view.getRowEdgeView().getEdgeCursor()) != null) {
            rowDimList = rowEdgeCursor.getDimensionCursor();
        }
        if (this.view.getColumnEdgeView() != null && (columnEdgeCursor = this.view.getColumnEdgeView().getEdgeCursor()) != null) {
            columnDimList = columnEdgeCursor.getDimensionCursor();
        }
        if (this.view.getPageEdgeView() != null && (pageEdgeCursor = this.view.getPageEdgeView().getEdgeCursor()) != null) {
            pageDimList = pageEdgeCursor.getDimensionCursor();
        }
        Relationship relation = (Relationship)this.relationMap.get(aggrName);
        List pageLevelList = relation.getLevelListOnPage();
        List columnLevelList = relation.getLevelListOnColumn();
        List rowLevelList = relation.getLevelListOnRow();
        HashMap<DimLevel, Object> valueMap = new HashMap<DimLevel, Object>();
        if (columnLevelList.isEmpty() && rowLevelList.isEmpty() && pageLevelList.isEmpty()) {
            return null;
        }
        int index = 0;
        while (index < pageLevelList.size()) {
            level = (DimLevel)pageLevelList.get(index);
            cursor = (DimensionCursor)pageDimList.get(index);
            value = cursor.getObject(level.getLevelName());
            valueMap.put(level, value);
            ++index;
        }
        int i = 0;
        while (i < columnLevelList.size()) {
            level = (DimLevel)columnLevelList.get(i);
            cursor = (DimensionCursor)columnDimList.get(i);
            value = cursor.getObject(level.getLevelName());
            valueMap.put(level, value);
            ++i;
        }
        i = 0;
        while (i < rowLevelList.size()) {
            level = (DimLevel)rowLevelList.get(i);
            cursor = (DimensionCursor)rowDimList.get(i);
            value = cursor.getObject(level.getLevelName());
            valueMap.put(level, value);
            ++i;
        }
        return valueMap;
    }

    /*
     * Unable to fully structure code
     */
    private boolean findValueMatcherOneByOne(IAggregationResultSet rs, List levelList, Map valueMap, int aggrIndex) throws IOException {
        position = 0;
        if (rs.length() > 0 && !levelList.isEmpty()) ** GOTO lbl18
        return true;
lbl-1000:
        // 1 sources

        {
            rs.seek(position);
            match = true;
            i = 0;
            while (i < levelList.size()) {
                level = (DimLevel)levelList.get(i);
                value1 = valueMap.get(level);
                if (!value1.equals(value2 = rs.getLevelKeyValue(rs.getLevelIndex(level))[rs.getLevelKeyColCount(rs.getLevelIndex(level)) - 1])) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (match) {
                return true;
            }
            ++position;
lbl18:
            // 2 sources

            ** while (position < rs.length())
        }
lbl19:
        // 1 sources

        return false;
    }

    private boolean findValueMatcher(IAggregationResultSet rs, List levelList, Map valueMap, int aggrIndex) {
        if (levelList.isEmpty()) {
            return true;
        }
        int start = 0;
        int state = 0;
        boolean find = false;
        this.currentPosition[aggrIndex] = rs.getPosition();
        while (start < levelList.size()) {
            int direction;
            int sortType;
            DimLevel level = (DimLevel)levelList.get(start);
            Object value1 = valueMap.get(level);
            Object value2 = rs.getLevelKeyValue(rs.getLevelIndex(level))[rs.getLevelKeyColCount(rs.getLevelIndex(level)) - 1];
            int n = sortType = rs.getSortType(rs.getLevelIndex(level)) == 1 ? -1 : 1;
            int n2 = sortType * AggregationAccessor.compare(value1, value2) < 0 ? -1 : (direction = AggregationAccessor.compare(value1, value2) == 0 ? 0 : 1);
            if (direction < 0 && this.currentPosition[aggrIndex] > 0 && (state == 0 || state == direction)) {
                state = direction;
                try {
                    int n3 = aggrIndex;
                    int n4 = this.currentPosition[n3] - 1;
                    this.currentPosition[n3] = n4;
                    rs.seek(n4);
                }
                catch (IOException iOException) {
                    find = false;
                }
                start = 0;
                continue;
            }
            if (direction > 0 && this.currentPosition[aggrIndex] < rs.length() - 1 && (state == 0 || state == direction)) {
                state = direction;
                try {
                    int n5 = aggrIndex;
                    int n6 = this.currentPosition[n5] + 1;
                    this.currentPosition[n5] = n6;
                    rs.seek(n6);
                }
                catch (IOException iOException) {
                    find = false;
                }
                start = 0;
                continue;
            }
            if (direction == 0) {
                if (start == levelList.size() - 1) {
                    find = true;
                    break;
                }
                ++start;
                continue;
            }
            if (this.currentPosition[aggrIndex] < 0 || this.currentPosition[aggrIndex] >= rs.length()) {
                return false;
            }
            return false;
        }
        return find;
    }

    static int compare(Object value1, Object value2) {
        if (value1 == value2) {
            return 0;
        }
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        if (value1 instanceof Comparable) {
            return ((Comparable)value1).compareTo(value2);
        }
        return value1.toString().compareTo(value2.toString());
    }
}

