/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort;

import java.io.IOException;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggregationSortHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.ITargetSort;

public class AggrSortHelper {
    public static void sort(List sorts, IAggregationResultSet[] resultSet) throws DataException {
        assert (sorts != null && sorts.size() > 1);
        try {
            ITargetSort[] targetSorts = new ITargetSort[sorts.size()];
            sorts.toArray(targetSorts);
            int baseIndex = AggrSortHelper.getBaseResultSetIndex(resultSet, targetSorts[0].getTargetLevel());
            IAggregationResultSet[] targetResultSet = new IAggregationResultSet[sorts.size()];
            int i = 0;
            while (i < targetSorts.length) {
                if (targetSorts[i] instanceof AggrSortDefinition) {
                    AggrSortDefinition sortDefn = (AggrSortDefinition)targetSorts[i];
                    DimLevel[] aggrLevels = sortDefn.getAggrLevels();
                    targetResultSet[i] = aggrLevels == null ? resultSet[baseIndex] : AggrSortHelper.getMatchedResultSet(resultSet, aggrLevels);
                }
                ++i;
            }
            IAggregationResultSet result = AggregationSortHelper.sort(resultSet[baseIndex], targetSorts, targetResultSet);
            resultSet[baseIndex].close();
            resultSet[baseIndex] = result;
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }

    private static int getBaseResultSetIndex(IAggregationResultSet[] resultSet, DimLevel level) throws DataException {
        int i = 0;
        while (i < resultSet.length) {
            if (AggrSortHelper.isEdgeResultSet(resultSet[i]) && resultSet[i].getLevelIndex(level) >= 0) {
                return i;
            }
            ++i;
        }
        throw new DataException("Can't find the base aggregation result set for the target level:", level);
    }

    private static boolean isEdgeResultSet(IAggregationResultSet resultSet) {
        return resultSet.getAggregationDefinition() == null || resultSet.getAggregationDefinition().getAggregationFunctions() == null;
    }

    private static IAggregationResultSet getMatchedResultSet(IAggregationResultSet[] resultSet, DimLevel[] levelNames) throws DataException {
        int i = 0;
        while (i < resultSet.length) {
            IAggregationResultSet rSet = resultSet[i];
            if (levelNames.length == rSet.getLevelCount()) {
                boolean match = true;
                int j = 0;
                while (j < rSet.getLevelCount()) {
                    if (!levelNames[j].equals(rSet.getLevel(j))) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match && !AggrSortHelper.isEdgeResultSet(rSet)) {
                    return rSet;
                }
            }
            ++i;
        }
        throw new DataException("data.olap.invalidSortDefinition");
    }
}

