/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.script;

import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.olap.script.OLAPExpressionHandler;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;

public class OLAPExpressionCompiler {
    public static void compile(Context cx, IBaseExpression expr) {
        if (expr instanceof IConditionalExpression) {
            OLAPExpressionCompiler.prepareScriptExpression(cx, ((IConditionalExpression)expr).getExpression());
            OLAPExpressionCompiler.prepareScriptExpression(cx, ((IConditionalExpression)expr).getOperand1());
            OLAPExpressionCompiler.prepareScriptExpression(cx, ((IConditionalExpression)expr).getOperand2());
        } else if (expr instanceof IScriptExpression) {
            OLAPExpressionCompiler.prepareScriptExpression(cx, (IScriptExpression)expr);
        }
    }

    private static void prepareScriptExpression(Context cx, IBaseExpression expr1) {
        if (expr1 == null) {
            return;
        }
        if (expr1 instanceof IScriptExpression) {
            String exprText = ((IScriptExpression)expr1).getText();
            CompilerEnvirons compilerEnv = new CompilerEnvirons();
            compilerEnv.initFromContext(cx);
            Parser p = new Parser(compilerEnv, cx.getErrorReporter());
            ScriptOrFnNode tree = p.parse(exprText, null, 0);
            Interpreter compiler = new Interpreter();
            Object compiledOb = compiler.compile(compilerEnv, tree, null, false);
            Script script = compiler.createScriptObject(compiledOb, null);
            expr1.setHandle(new OLAPExpressionHandler(script));
        } else if (expr1 instanceof IExpressionCollection) {
            Object[] exprs = ((IExpressionCollection)expr1).getExpressions().toArray();
            int i = 0;
            while (i < exprs.length) {
                OLAPExpressionCompiler.prepareScriptExpression(cx, (IBaseExpression)exprs[i]);
                ++i;
            }
        }
    }
}

