/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.data.api.cube.TimeDimensionUtil;
import org.eclipse.birt.data.engine.olap.script.JSCubeBindingObject;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.filter.IFacttableRow;
import org.eclipse.birt.data.engine.olap.util.filter.IResultRow;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public interface IJSObjectPopulator {
    public void doInit() throws DataException;

    public void setData(Object var1);

    public void cleanUp();

    public static class DummyJSAggregationAccessor
    extends ScriptableObject {
        private static final long serialVersionUID = -7910516821739958908L;
        private IResultRow resultRow;
        private Scriptable outResultsScriptable;

        public DummyJSAggregationAccessor(IBaseQueryResults outResults) throws DataException {
            this.outResultsScriptable = OlapExpressionUtil.createQueryResultsScriptable(outResults);
        }

        public Object get(String aggrName, Scriptable scope) {
            if (aggrName.equals("_outer")) {
                if (this.outResultsScriptable == null) {
                    throw Context.reportRuntimeError((String)DataResourceHandle.getInstance().getMessage("data.engine.NoOuterResultsExist"));
                }
                return this.outResultsScriptable;
            }
            if (this.resultRow != null) {
                try {
                    return this.resultRow.getAggrValue(aggrName);
                }
                catch (DataException e) {
                    return e;
                }
            }
            return null;
        }

        public void setResultRow(IResultRow row) {
            this.resultRow = row;
        }

        public String getClassName() {
            return "DummyJSAggregationAccessor";
        }
    }

    public static class DummyJSDataAccessor
    extends ScriptableObject {
        private static final long serialVersionUID = 1151785733090446202L;
        private Map bindingMap = new HashMap();
        private Scriptable scope;
        private Scriptable outResultsScriptable;
        private ScriptContext cx;

        public DummyJSDataAccessor(IBaseQueryResults outResults, List bindings, Scriptable scope, ScriptContext cx) throws DataException {
            this.cx = cx;
            int i = 0;
            while (i < bindings.size()) {
                this.bindingMap.put(((IBinding)bindings.get(i)).getBindingName(), bindings.get(i));
                ++i;
            }
            this.scope = scope;
            if (outResults != null) {
                if (outResults instanceof ICubeQueryResults) {
                    this.outResultsScriptable = new JSCubeBindingObject(((ICubeQueryResults)outResults).getCubeCursor());
                } else if (outResults instanceof IQueryResults) {
                    try {
                        this.outResultsScriptable = OlapExpressionUtil.createQueryResultsScriptable(outResults);
                    }
                    catch (BirtException e) {
                        throw DataException.wrap(e);
                    }
                }
            }
        }

        public Object get(String aggrName, Scriptable scope) {
            block5: {
                try {
                    if (this.bindingMap.containsKey(aggrName)) break block5;
                    if (aggrName.equals("_outer")) {
                        if (this.outResultsScriptable == null) {
                            throw Context.reportRuntimeError((String)DataResourceHandle.getInstance().getMessage("data.engine.NoOuterResultsExist"));
                        }
                        return this.outResultsScriptable;
                    }
                    return null;
                }
                catch (DataException dataException) {
                    return null;
                }
            }
            return ScriptEvalUtil.evalExpr(((IBinding)this.bindingMap.get(aggrName)).getExpression(), this.cx.newContext((Object)this.scope), ScriptExpression.defaultID, 0);
        }

        public String getClassName() {
            return null;
        }
    }

    public static class DummyJSDimensionAccessor
    extends ScriptableObject {
        private static final long serialVersionUID = 6340543910367862168L;
        private String dimensionName;
        private DummyJSDimensionObject dimObj;

        public DummyJSDimensionAccessor(String name, DummyJSDimensionObject dimObj) {
            assert (name != null);
            assert (dimObj != null);
            this.dimensionName = name;
            this.dimObj = dimObj;
        }

        public String getClassName() {
            return "DummyJSDimensionAccessor";
        }

        public Object get(String value, Scriptable scope) {
            if (!this.dimensionName.equals(value)) {
                throw new InMatchDimensionIndicator();
            }
            return this.dimObj;
        }
    }

    public static class DummyJSDimensionObject
    extends ScriptableObject {
        private static final long serialVersionUID = -5318363452556444748L;
        private DummyJSLevels levels;
        private List levelNames;

        public DummyJSDimensionObject(DummyJSLevels levels, List levelNames) {
            this.levels = levels;
            this.levelNames = levelNames;
        }

        public String getClassName() {
            return "DummyJSDimensionObject";
        }

        public Object get(String value, Scriptable scope) {
            if (this.levels.isTimeDimLevel() && TimeDimensionUtil.getFieldIndex(value) == -1) {
                throw new RuntimeException("Invalid level Name:" + value);
            }
            if (this.levelNames.contains(value)) {
                this.levels.setCurrentKey(value);
                return this.levels;
            }
            throw new RuntimeException("Invalid level Name:" + value);
        }
    }

    public static class DummyJSFacttableMeasureAccessor
    extends ScriptableObject {
        private static final long serialVersionUID = -7910516821739958908L;
        private IFacttableRow resultRow;
        private Map computedMeasures;
        private Scriptable scope;
        private ScriptContext cx;

        public DummyJSFacttableMeasureAccessor(Map computedMeasures, Scriptable scope, ScriptContext cx) {
            this.computedMeasures = computedMeasures;
            this.scope = scope;
            this.cx = cx;
        }

        public Object get(String aggrName, Scriptable scope) {
            if (this.resultRow != null) {
                block6: {
                    try {
                        if (!this.computedMeasures.containsKey(aggrName)) break block6;
                        try {
                            return ScriptEvalUtil.evalExpr((IBaseExpression)this.computedMeasures.get(aggrName), this.cx.newContext((Object)this.scope), ScriptExpression.defaultID, 0);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    catch (DataException dataException) {
                        return null;
                    }
                }
                return this.resultRow.getMeasureValue(aggrName);
            }
            return null;
        }

        public void setResultRow(IFacttableRow row) {
            this.resultRow = row;
        }

        public String getClassName() {
            return "DummyJSFacttableMeasureAccessor";
        }
    }

    public static class DummyJSLevels
    extends ScriptableObject {
        private static final long serialVersionUID = 2025085361323969740L;
        private IResultRow resultRow;
        private String key;
        private String dimName;

        public DummyJSLevels(String dimName) {
            this.dimName = dimName;
        }

        public String getClassName() {
            return "DummyJSLevels";
        }

        public Object getDefaultValue(Class hint) {
            try {
                if (this.resultRow.isTimeDimensionRow()) {
                    return this.resultRow.getFieldValue(this.key);
                }
                return this.resultRow.getFieldValue(OlapExpressionUtil.getAttrReference(this.dimName, this.key, this.key));
            }
            catch (DataException dataException) {
                return null;
            }
        }

        public Object get(String value, Scriptable scope) {
            try {
                return this.resultRow.getFieldValue(OlapExpressionUtil.getAttrReference(this.dimName, this.key, value));
            }
            catch (DataException dataException) {
                return null;
            }
        }

        public void setCurrentKey(String key) {
            this.key = key;
        }

        public void setResultRow(IResultRow result) {
            this.resultRow = result;
        }

        public boolean isTimeDimLevel() {
            return this.resultRow.isTimeDimensionRow();
        }
    }

    public static class InMatchDimensionIndicator
    extends RuntimeException {
        private static final long serialVersionUID = 1231475871896514362L;
    }
}

