/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.algorithmeplugin.bloccomplet;

import fr.inra.adonis.algorithmeplugin.bloccomplet.AlgorithmePlugin;
import fr.inra.adonis.modeleMetier.plateforme.TypeSpatialisation;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class AlgoDialog
extends TitleAreaDialog {
    private static final int DIALOG_MARGIN = 20;
    private AlgorithmePlugin plugin = null;
    private final boolean surfacique;
    private final int nbRepetition;
    private final int nbTraitement;
    private int nbBlocs = 1;
    protected int nbIndsParPu = 1;
    protected int nbIndsParLigne = 1;
    private Button okBtn = null;
    protected int nbBlocsParLigne = 1;
    protected int nbPusParLigne = 1;
    private final TypeSpatialisation spatialisation;

    protected AlgoDialog(Shell parentShell, AlgorithmePlugin algorithmePlugin, int nbRep, int nbTrait, boolean surf, TypeSpatialisation spatial) {
        super(parentShell);
        this.setShellStyle(65648);
        this.plugin = algorithmePlugin;
        this.nbRepetition = nbRep;
        this.nbTraitement = nbTrait;
        this.surfacique = surf;
        this.spatialisation = spatial;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Mofifier les parametres de l'algorithme");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Algorithme Bloc Complet");
        this.setMessage("Merci de preciser un nombre de blocs.", 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginTop = 20;
        gridLayout.marginBottom = 20;
        gridLayout.marginLeft = 20;
        gridLayout.marginRight = 20;
        container.setLayout((Layout)gridLayout);
        Group grpNbElements = new Group(container, 0);
        grpNbElements.setText("Nombre d'\u00e9l\u00e9ments");
        grpNbElements.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpNbElements.setLayout((Layout)new GridLayout(2, false));
        Label nbBlocLabel = new Label((Composite)grpNbElements, 0);
        nbBlocLabel.setText("Nombre de blocs : ");
        Text txtNbBlocs = new Text((Composite)grpNbElements, 2048);
        txtNbBlocs.setText(Integer.toString(this.nbRepetition));
        txtNbBlocs.setEnabled(false);
        Label nbPUTotal = new Label((Composite)grpNbElements, 0);
        nbPUTotal.setText("Nombre total de PU : ");
        Text txtNbPuTotal = new Text((Composite)grpNbElements, 2048);
        txtNbPuTotal.setText(Integer.toString(this.nbRepetition * this.nbTraitement));
        txtNbPuTotal.setEnabled(false);
        Group grpRepartition = new Group(container, 0);
        grpRepartition.setText("R\u00e9partition par ligne");
        grpRepartition.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpRepartition.setLayout((Layout)new GridLayout(2, false));
        Label lblNbBlocsParLigne = new Label((Composite)grpRepartition, 0);
        lblNbBlocsParLigne.setText("Nombre de blocs par ligne pour le dispositif: ");
        final Spinner spnNbBlocsParLigne = new Spinner((Composite)grpRepartition, 2048);
        Label lblNbParcellesParLigne = new Label((Composite)grpRepartition, 0);
        lblNbParcellesParLigne.setText("Nombre de PU par ligne pour un bloc: ");
        final Spinner spnNbPusParLigne = new Spinner((Composite)grpRepartition, 2048);
        grpRepartition.setVisible(this.spatialisation == TypeSpatialisation.BUREAU);
        Group grpForm = new Group(container, 0);
        grpForm.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        if (this.surfacique) {
            grpForm.setText("Facteur de forme");
        } else {
            grpForm.setText("Facteur de forme de la PU");
        }
        grpForm.setLayout((Layout)new GridLayout(2, false));
        Label lblNbInds = new Label((Composite)grpForm, 0);
        lblNbInds.setText("Nombre d'individus par parcelle : ");
        final Spinner spnNbIndsParPU = new Spinner((Composite)grpForm, 2048);
        spnNbIndsParPU.setMinimum(1);
        spnNbIndsParPU.setMaximum(30000);
        Label lblNbIndsParLigne = new Label((Composite)grpForm, 0);
        lblNbIndsParLigne.setText("Nombre d'individus par ligne : ");
        lblNbIndsParLigne.setVisible(this.spatialisation == TypeSpatialisation.BUREAU);
        final Spinner spnNbIndsParLigne = new Spinner((Composite)grpForm, 2048);
        spnNbIndsParLigne.setMinimum(1);
        spnNbIndsParLigne.setMaximum(30000);
        spnNbIndsParLigne.setVisible(this.spatialisation == TypeSpatialisation.BUREAU);
        spnNbIndsParPU.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog.this.nbIndsParPu = spnNbIndsParPU.getSelection();
                spnNbIndsParLigne.setMaximum(AlgoDialog.this.nbIndsParPu);
            }
        });
        spnNbIndsParLigne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog.this.nbIndsParLigne = spnNbIndsParLigne.getSelection();
            }
        });
        grpForm.setVisible(!this.surfacique);
        spnNbBlocsParLigne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog.this.nbBlocsParLigne = spnNbBlocsParLigne.getSelection();
                AlgoDialog.this.validate();
            }
        });
        spnNbBlocsParLigne.setMinimum(1);
        spnNbBlocsParLigne.setMaximum(30000);
        spnNbPusParLigne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog.this.nbPusParLigne = spnNbPusParLigne.getSelection();
                AlgoDialog.this.validate();
            }
        });
        spnNbPusParLigne.setMinimum(1);
        spnNbPusParLigne.setMaximum(30000);
        this.nbBlocs = this.nbRepetition;
        parent.pack();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okBtn = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, "Annuler", false);
        this.validate();
    }

    private void validate() {
        if (this.okBtn == null) {
            return;
        }
        if (this.nbRepetition == 0 && this.nbBlocs == 0 || this.nbRepetition != 0 && this.nbBlocs % this.nbRepetition == 0) {
            this.setErrorMessage(null);
            this.okBtn.setEnabled(true);
        } else {
            this.setErrorMessage("Le nombre de blocs doit etre un multiple de " + this.plugin.nbRepetition + ", le nombre de repetitions du traitement!");
            this.okBtn.setEnabled(false);
        }
    }

    public int getNbBlocs() {
        return this.nbBlocs;
    }

    public int getNbBlocsParLigne() {
        return this.nbBlocsParLigne;
    }

    public int getNbPusParLigne() {
        return this.nbPusParLigne;
    }

    public int getNbIndsParPu() {
        return this.nbIndsParPu;
    }

    public int getNbIndsParLigne() {
        return this.nbIndsParLigne;
    }
}

