/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetCursor;
import org.apache.derby.client.net.NetResultSet;
import org.apache.derby.client.net.NetSqlca;
import org.apache.derby.client.net.NetStatementReply;
import org.apache.derby.client.net.ResultSetReplyInterface;

public class NetResultSetReply
extends NetStatementReply
implements ResultSetReplyInterface {
    public NetResultSetReply(NetAgent netAgent, int bufferSize) {
        super(netAgent, bufferSize);
    }

    public void readFetch(ResultSetCallbackInterface resultSet) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseCNTQRYreply(resultSet, true);
        this.endOfSameIdChainData();
    }

    public void readPositioningFetch(ResultSetCallbackInterface resultSet) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseCNTQRYreply(resultSet, false);
        this.endOfSameIdChainData();
    }

    public void readScrollableFetch(ResultSetCallbackInterface resultSet) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseCNTQRYreply(resultSet, true);
        this.endOfSameIdChainData();
    }

    public void readCursorClose(ResultSetCallbackInterface resultSet) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseCLSQRYreply(resultSet);
        this.endOfSameIdChainData();
    }

    private void parseCLSQRYreply(ResultSetCallbackInterface resultSet) throws DisconnectException {
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            resultSet.completeSqlca(netSqlca);
        } else {
            this.parseCloseError(resultSet);
        }
    }

    private void parseCNTQRYreply(ResultSetCallbackInterface resultSetI, boolean doCopyQrydta) throws DisconnectException {
        boolean found = false;
        int peekCP = this.peekCodePoint();
        if (peekCP == 8728) {
            found = true;
            this.parseRDBUPDRM();
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 9243) {
            found = true;
            if (!doCopyQrydta) {
                this.parseLengthAndMatchCodePoint(9243);
                if (this.longValueForDecryption_ != null) {
                    this.longValueForDecryption_ = null;
                }
                if (this.longBufferForDecryption_ != null) {
                    this.longBufferForDecryption_ = null;
                }
                int ddmLength = this.getDdmLength();
                this.ensureBLayerDataInBuffer(ddmLength);
                ((ResultSet)resultSetI).expandRowsetSqlca();
                NetSqlca sqlca = this.parseSQLCARDrow(((ResultSet)resultSetI).rowsetSqlca_);
                byte daNullIndicator = this.readFastByte();
                this.adjustLengths(this.getDdmLength());
                if (sqlca != null && sqlca.containsSqlcax()) {
                    ((ResultSet)resultSetI).setRowCountEvent(sqlca.getRowCount(this.netAgent_.targetTypdef_));
                }
                if ((peekCP = this.peekCodePoint()) == 8728) {
                    this.parseRDBUPDRM();
                    peekCP = this.peekCodePoint();
                }
                if (peekCP == 49152) {
                    this.parsePBSD();
                }
                return;
            }
            do {
                this.parseQRYDTA((NetResultSet)resultSetI);
            } while ((peekCP = this.peekCodePoint()) == 9243);
        }
        if (peekCP == 5228) {
            found = true;
            do {
                this.copyEXTDTA((NetCursor)((ResultSet)resultSetI).cursor_);
                if (this.longBufferForDecryption_ == null) continue;
                this.buffer_ = this.longBufferForDecryption_;
                this.pos_ = this.longPosForDecryption_;
                if (this.longBufferForDecryption_ == null || this.count_ <= this.longBufferForDecryption_.length) continue;
                this.count_ = this.longBufferForDecryption_.length;
            } while ((peekCP = this.peekCodePoint()) == 5228);
        }
        if (peekCP == 9224) {
            found = true;
            ((ResultSet)resultSetI).expandRowsetSqlca();
            NetSqlca netSqlca = this.parseSQLCARD(((ResultSet)resultSetI).rowsetSqlca_);
            if (((ResultSet)resultSetI).sensitivity_ != 3 && netSqlca != null && netSqlca.containsSqlcax() && netSqlca.getRowsetRowCount() == 0L) {
                ((ResultSet)resultSetI).setRowCountEvent(netSqlca.getRowCount(this.netAgent_.targetTypdef_));
            }
            resultSetI.completeSqlca(netSqlca);
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8715) {
            found = true;
            this.parseEndQuery(resultSetI);
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8728) {
            found = true;
            this.parseRDBUPDRM();
            peekCP = this.peekCodePoint();
        }
        if (!found) {
            this.parseFetchError(resultSetI);
        }
        if (peekCP == 49152) {
            this.parsePBSD();
        }
        if (this.longBufferForDecryption_ != null) {
            this.buffer_ = new byte[Short.MAX_VALUE];
            this.longBufferForDecryption_ = null;
        }
    }

    void parseCloseError(ResultSetCallbackInterface resultSetI) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                NetSqlca sqlca = this.parseAbnormalEndUow(resultSetI);
                resultSetI.completeSqlca(sqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8706: {
                this.parseQRYNOPRM(resultSetI);
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void parseFetchError(ResultSetCallbackInterface resultSetI) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                NetSqlca sqlca = this.parseAbnormalEndUow(resultSetI);
                resultSetI.completeSqlca(sqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4688: {
                this.parseCMDNSPRM();
                break;
            }
            case 8706: {
                this.parseQRYNOPRM(resultSetI);
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    private void parseQRYNOPRM(ResultSetCallbackInterface resultSet) throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean pkgnamcsnReceived = false;
        Object pkgnamcsn = null;
        this.parseLengthAndMatchCodePoint(8706);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8467) {
                foundInPass = true;
                pkgnamcsnReceived = this.checkAndGetReceivedFlag(pkgnamcsnReceived);
                pkgnamcsn = this.parsePKGNAMCSN(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, rdbnamReceived, pkgnamcsnReceived);
        this.netAgent_.setSvrcod(svrcod);
        if (svrcod == CodePoint.SVRCOD_WARNING) {
            this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("24501.S")));
        } else {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)SqlException.getMessageUtil().getTextMessage("J128")));
        }
    }
}

