/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

class ImportFileInputStream
extends InputStream {
    private RandomAccessFile raf = null;
    private long currentPosition = 0L;
    private long fileLength = 0L;

    ImportFileInputStream(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        this.fileLength = raf.length();
    }

    void seek(long offset) throws IOException {
        this.raf.seek(offset);
        this.currentPosition = offset;
    }

    public int read() throws IOException {
        return this.raf.read();
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        return this.raf.read(buf, offset, length);
    }

    public int available() throws IOException {
        return (int)(this.fileLength - this.currentPosition);
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }
}

