/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.services.bytecode.BCMethodDescriptor;
import org.apache.derby.impl.services.bytecode.Type;

class VMTypeIdCacheable
implements Cacheable {
    private Object descriptor;
    private Object key;

    VMTypeIdCacheable() {
    }

    public void clearIdentity() {
    }

    public Object getIdentity() {
        return this.key;
    }

    public Cacheable createIdentity(Object key, Object createParameter) {
        SanityManager.THROWASSERT("VMTypeIdCacheable.create() called!");
        return this;
    }

    public Cacheable setIdentity(Object key) {
        this.key = key;
        if (key instanceof String) {
            String javaName = (String)key;
            String vmName = ClassHolder.convertToInternalDescriptor(javaName);
            this.descriptor = new Type(javaName, vmName);
        } else {
            this.descriptor = ((BCMethodDescriptor)key).buildMethodDescriptor();
        }
        return this;
    }

    public void clean(boolean remove) {
    }

    public boolean isDirty() {
        return false;
    }

    Object descriptor() {
        return this.descriptor;
    }
}

