/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.impl.services.cache.CacheEntry;
import org.apache.derby.impl.services.cache.ConcurrentCache;

final class BackgroundCleaner
implements Serviceable {
    private final DaemonService daemonService;
    private final int clientNumber;
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private final ArrayBlockingQueue<CacheEntry> queue;
    private volatile boolean shrink;
    private final ConcurrentCache cacheManager;

    BackgroundCleaner(ConcurrentCache cache, DaemonService daemon, int queueSize) {
        this.queue = new ArrayBlockingQueue(queueSize);
        this.daemonService = daemon;
        this.cacheManager = cache;
        this.clientNumber = daemon.subscribe(this, true);
    }

    boolean scheduleClean(CacheEntry entry) {
        boolean queued = this.queue.offer(entry);
        if (queued) {
            this.requestService();
        }
        return queued;
    }

    void scheduleShrink() {
        this.shrink = true;
        this.requestService();
    }

    private void requestService() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.daemonService.serviceNow(this.clientNumber);
        }
    }

    void unsubscribe() {
        this.daemonService.unsubscribe(this.clientNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int performWork(ContextManager context) throws StandardException {
        CacheEntry e;
        this.scheduled.set(false);
        if (this.shrink) {
            this.shrink = false;
            this.cacheManager.getReplacementPolicy().doShrink();
        }
        if ((e = this.queue.poll()) != null) {
            try {
                this.cacheManager.cleanEntry(e);
            }
            finally {
                if (!this.queue.isEmpty() || this.shrink) {
                    this.requestService();
                }
            }
        }
        return 1;
    }

    public boolean serviceASAP() {
        return true;
    }

    public boolean serviceImmediately() {
        return false;
    }
}

