/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.impl.sql.catalog.PermissionsCatalogRowFactory;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSROUTINEPERMSRowFactory
extends PermissionsCatalogRowFactory {
    static final String TABLENAME_STRING = "SYSROUTINEPERMS";
    private static final int ROUTINEPERMSID_COL_NUM = 1;
    private static final int GRANTEE_COL_NUM = 2;
    private static final int GRANTOR_COL_NUM = 3;
    private static final int ALIASID_COL_NUM = 4;
    private static final int GRANTOPTION_COL_NUM = 5;
    private static final int COLUMN_COUNT = 5;
    static final int GRANTEE_ALIAS_GRANTOR_INDEX_NUM = 0;
    public static final int ROUTINEPERMSID_INDEX_NUM = 1;
    public static final int ALIASID_INDEX_NUM = 2;
    private static final int[][] indexColumnPositions = new int[][]{{2, 4, 3}, {1}, {4}};
    public static final int GRANTEE_COL_NUM_IN_GRANTEE_ALIAS_GRANTOR_INDEX = 1;
    private static final boolean[] indexUniqueness = new boolean[]{true, true, false};
    private static final String[] uuids = new String[]{"2057c01b-0103-0e39-b8e7-00000010f010", "185e801c-0103-0e39-b8e7-00000010f010", "c065801d-0103-0e39-b8e7-00000010f010", "40f70088-010c-4c2f-c8de-0000000f43a0", "08264012-010c-bc85-060d-000000109ab8"};

    SYSROUTINEPERMSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(5, TABLENAME_STRING, indexColumnPositions, indexUniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String routinePermID = null;
        DataValueDescriptor grantee = null;
        DataValueDescriptor grantor = null;
        String routineID = null;
        if (td == null) {
            grantee = this.getNullAuthorizationID();
            grantor = this.getNullAuthorizationID();
        } else {
            RoutinePermsDescriptor rpd = (RoutinePermsDescriptor)td;
            UUID oid = rpd.getUUID();
            if (oid == null) {
                oid = this.getUUIDFactory().createUUID();
                rpd.setUUID(oid);
            }
            routinePermID = oid.toString();
            grantee = this.getAuthorizationID(rpd.getGrantee());
            grantor = this.getAuthorizationID(rpd.getGrantor());
            if (rpd.getRoutineUUID() != null) {
                routineID = rpd.getRoutineUUID().toString();
            }
        }
        ExecRow row = this.getExecutionFactory().getValueRow(5);
        row.setColumn(1, new SQLChar(routinePermID));
        row.setColumn(2, grantee);
        row.setColumn(3, grantor);
        row.setColumn(4, new SQLChar(routineID));
        row.setColumn(5, new SQLChar("N"));
        return row;
    }

    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTuple, DataDictionary dataDictionary) throws StandardException {
        SanityManager.ASSERT(row.nColumns() == 5, "Wrong size row passed to SYSROUTINEPERMSRowFactory.buildDescriptor");
        String routinePermsUUIDString = row.getColumn(1).getString();
        UUID routinePermsUUID = this.getUUIDFactory().recreateUUID(routinePermsUUIDString);
        String aliasUUIDString = row.getColumn(4).getString();
        UUID aliasUUID = this.getUUIDFactory().recreateUUID(aliasUUIDString);
        RoutinePermsDescriptor routinePermsDesc = new RoutinePermsDescriptor(dataDictionary, this.getAuthorizationID(row, 2), this.getAuthorizationID(row, 3), aliasUUID);
        routinePermsDesc.setUUID(routinePermsUUID);
        return routinePermsDesc;
    }

    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("ROUTINEPERMSID", false), SystemColumnImpl.getIdentifierColumn("GRANTEE", false), SystemColumnImpl.getIdentifierColumn("GRANTOR", false), SystemColumnImpl.getUUIDColumn("ALIASID", false), SystemColumnImpl.getIndicatorColumn("GRANTOPTION")};
    }

    public ExecIndexRow buildIndexKeyRow(int indexNumber, PermissionsDescriptor perm) throws StandardException {
        ExecIndexRow row = null;
        switch (indexNumber) {
            case 0: {
                row = this.getExecutionFactory().getIndexableRow(2);
                row.setColumn(1, this.getAuthorizationID(perm.getGrantee()));
                String routineUUIDStr = ((RoutinePermsDescriptor)perm).getRoutineUUID().toString();
                row.setColumn(2, new SQLChar(routineUUIDStr));
                break;
            }
            case 1: {
                row = this.getExecutionFactory().getIndexableRow(1);
                String routinePermsUUIDStr = perm.getObjectID().toString();
                row.setColumn(1, new SQLChar(routinePermsUUIDStr));
                break;
            }
            case 2: {
                row = this.getExecutionFactory().getIndexableRow(1);
                String routineUUIDStr = ((RoutinePermsDescriptor)perm).getRoutineUUID().toString();
                row.setColumn(1, new SQLChar(routineUUIDStr));
            }
        }
        return row;
    }

    public int getPrimaryKeyIndexNumber() {
        return 0;
    }

    public int orPermissions(ExecRow row, PermissionsDescriptor perm, boolean[] colsChanged) throws StandardException {
        return 0;
    }

    public int removePermissions(ExecRow row, PermissionsDescriptor perm, boolean[] colsChanged) throws StandardException {
        return -1;
    }

    public void setUUIDOfThePassedDescriptor(ExecRow row, PermissionsDescriptor perm) throws StandardException {
        DataValueDescriptor existingPermDVD = row.getColumn(1);
        perm.setUUID(this.getUUIDFactory().recreateUUID(existingPermDVD.getString()));
    }
}

