/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;

public class AlterTableNode
extends DDLStatementNode {
    public TableElementList tableElementList = null;
    public char lockGranularity;
    private boolean updateStatistics = false;
    private boolean updateStatisticsAll = false;
    private String indexNameForUpdateStatistics;
    public boolean compressTable = false;
    public boolean sequential = false;
    public boolean purge = false;
    public boolean defragment = false;
    public boolean truncateEndOfTable = false;
    public int behavior;
    public TableDescriptor baseTable;
    protected int numConstraints;
    private int changeType = 0;
    private boolean truncateTable = false;
    protected SchemaDescriptor schemaDescriptor = null;
    protected ColumnInfo[] colInfos = null;
    protected ConstraintConstantAction[] conActions = null;

    public void init(Object objectName) throws StandardException {
        this.initAndCheck(objectName);
        this.truncateTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    public void init(Object objectName, Object updateStatisticsAll, Object indexName) throws StandardException {
        this.initAndCheck(objectName);
        this.updateStatisticsAll = (Boolean)updateStatisticsAll;
        this.indexNameForUpdateStatistics = (String)indexName;
        this.schemaDescriptor = this.getSchemaDescriptor();
        this.updateStatistics = true;
    }

    public void init(Object objectName, Object sequential) throws StandardException {
        this.initAndCheck(objectName);
        this.sequential = (Boolean)sequential;
        this.compressTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    public void init(Object objectName, Object purge, Object defragment, Object truncateEndOfTable) throws StandardException {
        this.initAndCheck(objectName);
        this.purge = (Boolean)purge;
        this.defragment = (Boolean)defragment;
        this.truncateEndOfTable = (Boolean)truncateEndOfTable;
        this.compressTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor(true, false);
    }

    public void init(Object objectName, Object tableElementList, Object lockGranularity, Object changeType, Object behavior) throws StandardException {
        this.initAndCheck(objectName);
        this.tableElementList = (TableElementList)tableElementList;
        this.lockGranularity = ((Character)lockGranularity).charValue();
        int[] ct = (int[])changeType;
        int[] bh = (int[])behavior;
        this.changeType = ct[0];
        this.behavior = bh[0];
        switch (this.changeType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw StandardException.newException("0A000.S");
            }
        }
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    public String toString() {
        return super.toString() + "objectName: " + "\n" + this.getObjectName() + "\n" + "tableElementList: " + "\n" + this.tableElementList + "\n" + "lockGranularity: " + "\n" + this.lockGranularity + "\n" + "compressTable: " + "\n" + this.compressTable + "\n" + "sequential: " + "\n" + this.sequential + "\n" + "truncateTable: " + "\n" + this.truncateTable + "\n" + "purge: " + "\n" + this.purge + "\n" + "defragment: " + "\n" + this.defragment + "\n" + "truncateEndOfTable: " + "\n" + this.truncateEndOfTable + "\n" + "updateStatistics: " + "\n" + this.updateStatistics + "\n" + "updateStatisticsAll: " + "\n" + this.updateStatisticsAll + "\n" + "indexNameForUpdateStatistics: " + "\n" + this.indexNameForUpdateStatistics + "\n";
    }

    public String statementToString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE";
        }
        return "ALTER TABLE";
    }

    public int getChangeType() {
        return this.changeType;
    }

    public void bindStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        int numCheckConstraints = 0;
        int numReferenceConstraints = 0;
        int numGenerationClauses = 0;
        int numBackingIndexes = 0;
        this.baseTable = this.compressTable && (this.purge || this.defragment || this.truncateEndOfTable) ? this.getTableDescriptor(false) : this.getTableDescriptor();
        if (this.baseTable.getTableType() == 3) {
            throw StandardException.newException("42995");
        }
        this.getCompilerContext().createDependency(this.baseTable);
        if (this.changeType == 1 && this.tableElementList != null) {
            for (int i = 0; i < this.tableElementList.size(); ++i) {
                ColumnDefinitionNode cdn;
                if (!(this.tableElementList.elementAt(i) instanceof ColumnDefinitionNode) || (cdn = (ColumnDefinitionNode)this.tableElementList.elementAt(i)).hasGenerationClause() && cdn.getType() == null || !cdn.getType().getTypeId().isStringTypeId()) continue;
                cdn.setCollationType(this.schemaDescriptor.getCollationType());
            }
        }
        if (this.tableElementList != null) {
            this.tableElementList.validate(this, dd, this.baseTable);
            if (this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns() > 1012) {
                throw StandardException.newException("54011", (Object)String.valueOf(this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns()), (Object)this.getRelativeName(), (Object)String.valueOf(1012));
            }
            numBackingIndexes = this.tableElementList.countConstraints(2) + this.tableElementList.countConstraints(6) + this.tableElementList.countConstraints(3);
            numCheckConstraints = this.tableElementList.countConstraints(4);
            numReferenceConstraints = this.tableElementList.countConstraints(6);
            numGenerationClauses = this.tableElementList.countGenerationClauses();
        }
        if (numBackingIndexes + this.baseTable.getTotalNumberOfIndexes() > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", (Object)String.valueOf(numBackingIndexes + this.baseTable.getTotalNumberOfIndexes()), (Object)this.getRelativeName(), (Object)String.valueOf(Short.MAX_VALUE));
        }
        if (numCheckConstraints > 0 || numGenerationClauses > 0 || numReferenceConstraints > 0) {
            FromList fromList = this.makeFromList(dd, this.tableElementList, false);
            FormatableBitSet generatedColumns = this.baseTable.makeColumnMap(this.baseTable.getGeneratedColumns());
            if (numGenerationClauses > 0) {
                this.tableElementList.bindAndValidateGenerationClauses(this.schemaDescriptor, fromList, generatedColumns, this.baseTable);
            }
            if (numCheckConstraints > 0) {
                this.tableElementList.bindAndValidateCheckConstraints(fromList);
            }
            if (numReferenceConstraints > 0) {
                this.tableElementList.validateForeignKeysOnGenerationClauses(fromList, generatedColumns);
            }
        }
        if (this.tableElementList != null) {
            this.tableElementList.validatePrimaryKeyNullability();
        }
        if (this.updateStatistics && !this.updateStatisticsAll) {
            ConglomerateDescriptor cd = null;
            if (this.schemaDescriptor.getUUID() != null) {
                cd = dd.getConglomerateDescriptor(this.indexNameForUpdateStatistics, this.schemaDescriptor, false);
            }
            if (cd == null) {
                throw StandardException.newException("42X65", this.schemaDescriptor.getSchemaName() + "." + this.indexNameForUpdateStatistics);
            }
        }
        this.getCompilerContext().createDependency(this.baseTable);
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.baseTable.getSchemaName());
    }

    public ConstantAction makeConstantAction() throws StandardException {
        this.prepConstantAction();
        return this.getGenericConstantActionFactory().getAlterTableConstantAction(this.schemaDescriptor, this.getRelativeName(), this.baseTable.getUUID(), this.baseTable.getHeapConglomerateId(), 0, this.colInfos, this.conActions, this.lockGranularity, this.compressTable, this.behavior, this.sequential, this.truncateTable, this.purge, this.defragment, this.truncateEndOfTable, this.updateStatistics, this.updateStatisticsAll, this.indexNameForUpdateStatistics);
    }

    private void prepConstantAction() throws StandardException {
        if (this.tableElementList != null) {
            this.genColumnInfo();
        }
        if (this.numConstraints > 0) {
            this.conActions = new ConstraintConstantAction[this.numConstraints];
            this.tableElementList.genConstraintActions(false, this.conActions, this.getRelativeName(), this.schemaDescriptor, this.getDataDictionary());
        }
    }

    public void genColumnInfo() throws StandardException {
        this.colInfos = new ColumnInfo[this.tableElementList.countNumberOfColumns()];
        this.numConstraints = this.tableElementList.genColumnInfos(this.colInfos);
    }
}

