/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

abstract class JavaValueNode
extends QueryTreeNode {
    private boolean mustCastToPrimitive;
    protected boolean forCallStatement;
    private boolean valueReturnedToSQLDomain;
    private boolean returnValueDiscarded;
    protected JSQLType jsqlType;
    private LocalField receiverField;
    private int collationType;

    JavaValueNode() {
    }

    public boolean isPrimitiveType() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return false;
        }
        return myType.getCategory() == 2;
    }

    public String getJavaTypeName() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return "";
        }
        switch (myType.getCategory()) {
            case 1: {
                return myType.getJavaClassName();
            }
            case 2: {
                return JSQLType.primitiveNames[myType.getPrimitiveKind()];
            }
        }
        SanityManager.THROWASSERT("Inappropriate JSQLType: " + myType);
        return "";
    }

    public void setJavaTypeName(String javaTypeName) {
        this.jsqlType = new JSQLType(javaTypeName);
    }

    public String getPrimitiveTypeName() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return "";
        }
        switch (myType.getCategory()) {
            case 2: {
                return JSQLType.primitiveNames[myType.getPrimitiveKind()];
            }
        }
        SanityManager.THROWASSERT("Inappropriate JSQLType: " + myType);
        return "";
    }

    public void castToPrimitive(boolean booleanValue) {
        this.mustCastToPrimitive = booleanValue;
    }

    public boolean mustCastToPrimitive() {
        return this.mustCastToPrimitive;
    }

    public JSQLType getJSQLType() throws StandardException {
        return this.jsqlType;
    }

    public TypeId mapToTypeID(JSQLType jsqlType) {
        DataTypeDescriptor dts = jsqlType.getSQLType();
        if (dts == null) {
            return null;
        }
        return dts.getTypeId();
    }

    public void markForCallStatement() {
        this.forCallStatement = true;
    }

    public abstract JavaValueNode remapColumnReferencesToExpressions() throws StandardException;

    public abstract boolean categorize(JBitSet var1, boolean var2) throws StandardException;

    abstract JavaValueNode bindExpression(FromList var1, SubqueryList var2, Vector var3) throws StandardException;

    public abstract void preprocess(int var1, FromList var2, SubqueryList var3, PredicateList var4) throws StandardException;

    Object getConstantValueAsObject() throws StandardException {
        return null;
    }

    protected final void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateExpression(acb, mb);
    }

    protected boolean generateReceiver(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        return false;
    }

    protected int getOrderableVariantType() throws StandardException {
        return 0;
    }

    protected abstract void generateExpression(ExpressionClassBuilder var1, MethodBuilder var2) throws StandardException;

    protected final boolean generateReceiver(ExpressionClassBuilder acb, MethodBuilder mb, JavaValueNode receiver) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        if (!this.valueReturnedToSQLDomain()) {
            if (ClassInspector.primitiveType(this.getJavaTypeName())) {
                return false;
            }
        }
        String receiverClassName = receiver.getJavaTypeName();
        this.receiverField = acb.newFieldDeclaration(2, receiverClassName);
        receiver.generateExpression(acb, mb);
        mb.putField(this.receiverField);
        return true;
    }

    protected final void getReceiverExpression(ExpressionClassBuilder acb, MethodBuilder mb, JavaValueNode receiver) throws StandardException {
        if (this.receiverField != null) {
            mb.getField(this.receiverField);
        } else {
            receiver.generateExpression(acb, mb);
        }
    }

    protected void returnValueToSQLDomain() {
        this.valueReturnedToSQLDomain = true;
    }

    protected boolean valueReturnedToSQLDomain() {
        return this.valueReturnedToSQLDomain;
    }

    protected void markReturnValueDiscarded() {
        this.returnValueDiscarded = true;
    }

    protected boolean returnValueDiscarded() {
        return this.returnValueDiscarded;
    }

    public void checkReliability(ValueNode sqlNode) throws StandardException {
        sqlNode.checkReliability(4, "42Z00.U");
    }

    public int getCollationType() {
        return this.collationType;
    }

    public void setCollationType(int type) {
        this.collationType = type;
    }
}

