/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedByteCode;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.Row;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.SQLSessionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetFactory;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.execute.InsertResultSet;
import org.apache.derby.impl.sql.execute.RowResultSet;
import org.apache.derby.impl.sql.execute.UnionResultSet;

public abstract class BaseActivation
implements CursorActivation,
GeneratedByteCode {
    private LanguageConnectionContext lcc;
    protected ContextManager cm;
    protected ExecPreparedStatement preStmt;
    protected ResultSet resultSet;
    protected ResultDescription resultDescription;
    protected boolean closed;
    private String cursorName;
    protected int numSubqueries;
    private boolean singleExecution;
    private volatile boolean inUse;
    private java.sql.ResultSet targetVTI;
    private SQLWarning warnings;
    private GeneratedClass gc;
    private boolean checkRowCounts;
    private HashSet rowCountsCheckedThisExecution = new HashSet(4, 0.9f);
    private static final long MAX_SQRT = (long)Math.sqrt(9.223372036854776E18);
    private static final int TEN_PERCENT_THRESHOLD = 400;
    private ConglomerateController updateHeapCC;
    private ScanController indexSC;
    private long indexConglomerateNumber = -1L;
    private TableDescriptor ddlTableDescriptor;
    private int maxRows = -1;
    private boolean forCreateTable;
    private boolean scrollable;
    private boolean resultSetHoldability;
    private CursorResultSet forUpdateIndexScan;
    private boolean autoGeneratedKeysResultSetMode;
    private int[] autoGeneratedKeysColumnIndexes;
    private String[] autoGeneratedKeysColumnNames;
    private boolean isValid;
    protected String UUIDString;
    protected UUID UUIDValue;
    private Activation parentActivation;
    private SQLSessionContext sqlSessionContextForChildren;
    protected int indexOfSessionTableNamesInSavedObjects = -1;
    protected ExecRow[] row;
    protected ParameterValueSet pvs;
    protected CursorResultSet[] raParentResultSets;
    protected Hashtable parentResultSets;
    private Calendar cal;

    protected BaseActivation() {
    }

    public final void initFromContext(Context context) throws StandardException {
        SanityManager.ASSERT(context != null, "NULL context passed to BaseActivation.initFromContext");
        this.cm = context.getContextManager();
        this.lcc = (LanguageConnectionContext)this.cm.getContext("LanguageConnectionContext");
        if (this.lcc == null) {
            SanityManager.THROWASSERT("lcc is null in activation type " + this.getClass());
        }
        this.inUse = true;
        this.lcc.addActivation(this);
        this.isValid = true;
        UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.UUIDValue = uuidFactory.createUUID();
        this.UUIDString = this.UUIDValue.toString();
    }

    public final ExecPreparedStatement getPreparedStatement() {
        return this.preStmt;
    }

    public ConstantAction getConstantAction() {
        return this.preStmt.getConstantAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkStatementValidity() throws StandardException {
        if (this.preStmt == null) {
            return;
        }
        ExecPreparedStatement execPreparedStatement = this.preStmt;
        synchronized (execPreparedStatement) {
            if (this.gc == this.preStmt.getActivationClass() && this.preStmt.upToDate()) {
                return;
            }
        }
        StandardException se = StandardException.newException("XCL32.S");
        se.setReport(1);
        throw se;
    }

    public final void setupActivation(ExecPreparedStatement ps, boolean scrollable) throws StandardException {
        this.preStmt = ps;
        if (ps != null) {
            this.resultDescription = ps.getResultDescription();
            this.scrollable = scrollable;
            if (this.pvs != null && this.pvs.getParameterCount() != 0) {
                this.pvs.initialize(ps.getParameterTypes());
            }
        } else {
            this.resultDescription = null;
            this.scrollable = false;
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public RowLocation getRowLocationTemplate(int itemNumber) {
        RowLocation rl;
        SanityManager.ASSERT(itemNumber >= 0, "itemNumber expected to be >= 0");
        if (!(this.getPreparedStatement().getSavedObject(itemNumber) instanceof RowLocation)) {
            SanityManager.THROWASSERT("getPreparedStatement().getSavedObject(itemNumber) expected to be instance of RowLocation, not " + this.getPreparedStatement().getSavedObject(itemNumber).getClass().getName() + ", query is " + this.getPreparedStatement().getSource());
        }
        if (!((rl = (RowLocation)this.getPreparedStatement().getSavedObject(itemNumber)).cloneObject() instanceof RowLocation)) {
            SanityManager.THROWASSERT("rl.cloneObject() expected to be instance of RowLocation, not " + rl.getClass().getName() + ", query is " + this.getPreparedStatement().getSource());
        }
        return (RowLocation)((RowLocation)this.getPreparedStatement().getSavedObject(itemNumber)).cloneObject();
    }

    public ResultDescription getResultDescription() {
        SanityManager.ASSERT(this.resultDescription != null, "Must have a result description");
        return this.resultDescription;
    }

    public void reset() throws StandardException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.updateHeapCC = null;
        if (!this.isSingleExecution()) {
            this.clearWarnings();
        }
    }

    public final void close() throws StandardException {
        if (!this.closed) {
            this.reset();
            if (this.resultSet != null) {
                this.resultSet.finish();
                this.resultSet = null;
            }
            this.closed = true;
            LanguageConnectionContext lcc = this.getLanguageConnectionContext();
            lcc.removeActivation(this);
            if (this.preStmt != null) {
                this.preStmt.finish(lcc);
                this.preStmt = null;
            }
            try {
                this.closeActivationAction();
            }
            catch (Throwable e) {
                throw StandardException.plainWrapException(e);
            }
        }
    }

    protected void closeActivationAction() throws Exception {
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setSingleExecution() {
        this.singleExecution = true;
    }

    public boolean isSingleExecution() {
        return this.singleExecution;
    }

    public int getNumSubqueries() {
        return this.numSubqueries;
    }

    public boolean isCursorActivation() {
        return false;
    }

    public final void setGC(GeneratedClass gc) {
        this.gc = gc;
    }

    public final GeneratedClass getGC() {
        if (this.gc == null) {
            SanityManager.THROWASSERT("move code requiring GC to postConstructor() method!!");
        }
        return this.gc;
    }

    public final GeneratedMethod getMethod(String methodName) throws StandardException {
        return this.getGC().getMethod(methodName);
    }

    public Object e0() throws StandardException {
        return null;
    }

    public Object e1() throws StandardException {
        return null;
    }

    public Object e2() throws StandardException {
        return null;
    }

    public Object e3() throws StandardException {
        return null;
    }

    public Object e4() throws StandardException {
        return null;
    }

    public Object e5() throws StandardException {
        return null;
    }

    public Object e6() throws StandardException {
        return null;
    }

    public Object e7() throws StandardException {
        return null;
    }

    public Object e8() throws StandardException {
        return null;
    }

    public Object e9() throws StandardException {
        return null;
    }

    public boolean checkIfThisActivationHasHoldCursor(String tableName) {
        if (!this.inUse) {
            return false;
        }
        if (!this.resultSetHoldability) {
            return false;
        }
        if (this.indexOfSessionTableNamesInSavedObjects == -1) {
            return false;
        }
        if (this.resultSet != null && !this.resultSet.isClosed() && this.resultSet.returnsRows()) {
            return ((ArrayList)this.getPreparedStatement().getSavedObject(this.indexOfSessionTableNamesInSavedObjects)).contains(tableName);
        }
        return false;
    }

    public void setCursorName(String cursorName) {
        if (this.isCursorActivation()) {
            this.cursorName = cursorName;
        }
    }

    public String getCursorName() {
        return this.isCursorActivation() ? this.cursorName : null;
    }

    public void setResultSetHoldability(boolean resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    public boolean getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public void setAutoGeneratedKeysResultsetInfo(int[] columnIndexes, String[] columnNames) {
        this.autoGeneratedKeysResultSetMode = true;
        this.autoGeneratedKeysColumnIndexes = columnIndexes;
        this.autoGeneratedKeysColumnNames = columnNames;
    }

    public boolean getAutoGeneratedKeysResultsetMode() {
        return this.autoGeneratedKeysResultSetMode;
    }

    public int[] getAutoGeneratedKeysColumnIndexes() {
        return this.autoGeneratedKeysColumnIndexes;
    }

    public String[] getAutoGeneratedKeysColumnNames() {
        return this.autoGeneratedKeysColumnNames;
    }

    public final ResultSetFactory getResultSetFactory() {
        return this.getExecutionFactory().getResultSetFactory();
    }

    public final ExecutionFactory getExecutionFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
    }

    public CursorResultSet getTargetResultSet() {
        SanityManager.THROWASSERT("Must be overridden to be used.");
        return null;
    }

    protected DataValueDescriptor getSetAutoincrementValue(int columnPosition, long increment) throws StandardException {
        NumberDataValue l = ((InsertResultSet)this.resultSet).getSetAutoincrementValue(columnPosition, increment);
        return l;
    }

    public CursorResultSet getCursorResultSet() {
        SanityManager.THROWASSERT("Must be overridden to be used.");
        return null;
    }

    public void throwIfClosed(String op) throws StandardException {
        if (this.closed) {
            throw StandardException.newException("XCL05.S", op);
        }
    }

    public static void setColumnPosition(int[] columnPositions, int positionToSet, int column) {
        columnPositions[positionToSet] = column;
    }

    public static void allocateQualArray(Qualifier[][] qualifiers, int position, int length) {
        qualifiers[position] = new Qualifier[length];
    }

    public static void setQualifier(Qualifier[][] qualifiers, Qualifier qualifier, int position_1, int position_2) {
        qualifiers[position_1][position_2] = qualifier;
    }

    public static void reinitializeQualifiers(Qualifier[][] qualifiers) {
        if (qualifiers != null) {
            for (int term = 0; term < qualifiers.length; ++term) {
                for (int i = 0; i < qualifiers[term].length; ++i) {
                    qualifiers[term][i].reinitialize();
                }
            }
        }
    }

    public final void markUnused() {
        if (this.isInUse()) {
            this.inUse = false;
            this.lcc.notifyUnusedActivation();
        }
    }

    public final boolean isInUse() {
        return this.inUse;
    }

    public void addWarning(SQLWarning w) {
        if (this.warnings == null) {
            this.warnings = w;
        } else {
            this.warnings.setNextWarning(w);
        }
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public void clearWarnings() {
        this.warnings = null;
    }

    protected static void nullToPrimitiveTest(DataValueDescriptor dvd, String primitiveType) throws StandardException {
        if (dvd.isNull()) {
            throw StandardException.newException("39004", primitiveType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informOfRowCount(NoPutResultSet resultSet, long currentRowCount) throws StandardException {
        if (this.checkRowCounts) {
            boolean significantChange = false;
            int resultSetNumber = resultSet.resultSetNumber();
            Integer rsn = ReuseFactory.getInteger(resultSetNumber);
            if (this.rowCountsCheckedThisExecution.add(rsn)) {
                ExecPreparedStatement execPreparedStatement = this.getPreparedStatement();
                synchronized (execPreparedStatement) {
                    Vector<Long> rowCountCheckVector = this.getRowCountCheckVector();
                    if (rowCountCheckVector == null) {
                        rowCountCheckVector = new Vector<Long>();
                        this.setRowCountCheckVector(rowCountCheckVector);
                    }
                    Long firstRowCount = null;
                    if (resultSetNumber < rowCountCheckVector.size()) {
                        firstRowCount = (Long)rowCountCheckVector.elementAt(resultSetNumber);
                    } else {
                        rowCountCheckVector.setSize(resultSetNumber + 1);
                    }
                    if (firstRowCount != null) {
                        long n1 = firstRowCount;
                        if (currentRowCount != n1) {
                            if (n1 >= 400L) {
                                long changeFactor = n1 / (currentRowCount - n1);
                                if (Math.abs(changeFactor) <= 10L) {
                                    significantChange = true;
                                }
                            } else {
                                long changediff = currentRowCount - n1;
                                if (Math.abs(changediff) <= MAX_SQRT && changediff * changediff > Math.abs(4L * n1)) {
                                    significantChange = true;
                                }
                            }
                        }
                    } else {
                        firstRowCount = new Long(currentRowCount);
                        rowCountCheckVector.setElementAt(firstRowCount, resultSetNumber);
                    }
                }
            }
            if (significantChange) {
                this.preStmt.makeInvalid(23, this.lcc);
            }
        }
    }

    public void startExecution() throws StandardException {
        this.shouldWeCheckRowCounts();
        if (this.checkRowCounts) {
            this.rowCountsCheckedThisExecution.clear();
        }
    }

    public ConglomerateController getHeapConglomerateController() {
        return this.updateHeapCC;
    }

    public void setHeapConglomerateController(ConglomerateController updateHeapCC) {
        this.updateHeapCC = updateHeapCC;
    }

    public void clearHeapConglomerateController() {
        this.updateHeapCC = null;
    }

    public ScanController getIndexScanController() {
        return this.indexSC;
    }

    public void setIndexScanController(ScanController indexSC) {
        this.indexSC = indexSC;
    }

    public long getIndexConglomerateNumber() {
        return this.indexConglomerateNumber;
    }

    public void setIndexConglomerateNumber(long indexConglomerateNumber) {
        this.indexConglomerateNumber = indexConglomerateNumber;
    }

    public void clearIndexScanInfo() {
        this.indexSC = null;
        this.indexConglomerateNumber = -1L;
    }

    public void setForCreateTable() {
        this.forCreateTable = true;
    }

    public boolean getForCreateTable() {
        return this.forCreateTable;
    }

    public void setDDLTableDescriptor(TableDescriptor td) {
        this.ddlTableDescriptor = td;
    }

    public TableDescriptor getDDLTableDescriptor() {
        return this.ddlTableDescriptor;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setTargetVTI(java.sql.ResultSet targetVTI) {
        this.targetVTI = targetVTI;
    }

    public java.sql.ResultSet getTargetVTI() {
        return this.targetVTI;
    }

    private void shouldWeCheckRowCounts() throws StandardException {
        int executionCount = this.getExecutionCount() + 1;
        if (executionCount == 1) {
            this.checkRowCounts = true;
        } else if (executionCount < 5) {
            this.checkRowCounts = false;
        } else {
            int stalePlanCheckInterval = this.getStalePlanCheckInterval();
            if (stalePlanCheckInterval == 0) {
                TransactionController tc = this.getTransactionController();
                stalePlanCheckInterval = PropertyUtil.getServiceInt(tc, "derby.language.stalePlanCheckInterval", 5, Integer.MAX_VALUE, 100);
                this.setStalePlanCheckInterval(stalePlanCheckInterval);
            }
            this.checkRowCounts = executionCount % stalePlanCheckInterval == 1;
        }
        this.setExecutionCount(executionCount);
    }

    protected abstract int getExecutionCount();

    protected abstract void setExecutionCount(int var1);

    protected abstract Vector getRowCountCheckVector();

    protected abstract void setRowCountCheckVector(Vector var1);

    protected abstract int getStalePlanCheckInterval();

    protected abstract void setStalePlanCheckInterval(int var1);

    public final boolean getScrollable() {
        return this.scrollable;
    }

    protected final void setParameterValueSet(int paramCount, boolean hasReturnParam) {
        this.pvs = this.lcc.getLanguageFactory().newParameterValueSet(this.lcc.getLanguageConnectionFactory().getClassFactory().getClassInspector(), paramCount, hasReturnParam);
    }

    protected final DataValueDescriptor getParameter(int position) throws StandardException {
        return this.pvs.getParameter(position);
    }

    public ParameterValueSet getParameterValueSet() {
        if (this.pvs == null) {
            this.setParameterValueSet(0, false);
        }
        return this.pvs;
    }

    public void setParameters(ParameterValueSet parameterValues, DataTypeDescriptor[] parameterTypes) throws StandardException {
        if (!this.isClosed()) {
            if (this.pvs == null || parameterTypes == null) {
                this.pvs = parameterValues;
                return;
            }
            DataTypeDescriptor[] newParamTypes = this.preStmt.getParameterTypes();
            boolean match = false;
            if (newParamTypes != null && newParamTypes.length == parameterTypes.length) {
                match = true;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    DataTypeDescriptor oldType = parameterTypes[i];
                    DataTypeDescriptor newType = newParamTypes[i];
                    if (!oldType.isExactTypeAndLengthMatch(newType)) {
                        match = false;
                        break;
                    }
                    if (oldType.isNullable() == newType.isNullable()) continue;
                    match = false;
                    break;
                }
            }
            if (!match) {
                throw StandardException.newException("XCL10.S");
            }
            parameterValues.transferDataValues(this.pvs);
        } else {
            SanityManager.THROWASSERT("isClosed() is expected to return false");
        }
    }

    public void throwIfMissingParms() throws StandardException {
        if (this.pvs != null && !this.pvs.allAreSet()) {
            throw StandardException.newException("07000");
        }
    }

    public void setCurrentRow(ExecRow currentRow, int resultSetNumber) {
        SanityManager.ASSERT(!this.isClosed(), "closed");
        if (this.row != null && (resultSetNumber < 0 || resultSetNumber >= this.row.length)) {
            SanityManager.THROWASSERT("resultSetNumber = " + resultSetNumber + ", expected to be between 0 and " + this.row.length);
        }
        if (this.row != null) {
            this.row[resultSetNumber] = currentRow;
        }
    }

    public void clearCurrentRow(int resultSetNumber) {
        if (this.row != null && (resultSetNumber < 0 || resultSetNumber >= this.row.length)) {
            SanityManager.THROWASSERT("resultSetNumber = " + resultSetNumber + ", expected to be between 0 and " + this.row.length);
        }
        if (this.row != null) {
            this.row[resultSetNumber] = null;
        }
    }

    public Row getCurrentRow(int resultSetNumber) {
        return this.row[resultSetNumber];
    }

    public SQLSessionContext getSQLSessionContextForChildren() {
        SanityManager.ASSERT(this.sqlSessionContextForChildren != null, "Expected sqlSessionContextForChildren to be non-null");
        return this.sqlSessionContextForChildren;
    }

    public SQLSessionContext setupSQLSessionContextForChildren(boolean push) {
        this.sqlSessionContextForChildren = push ? this.lcc.createSQLSessionContext() : (this.parentActivation != null ? this.parentActivation.getSQLSessionContextForChildren() : this.lcc.getTopLevelSQLSessionContext());
        return this.sqlSessionContextForChildren;
    }

    public void setParentActivation(Activation a) {
        this.parentActivation = a;
    }

    public Activation getParentActivation() {
        return this.parentActivation;
    }

    protected final DataValueDescriptor getColumnFromRow(int rsNumber, int colId) throws StandardException {
        return this.row[rsNumber].getColumn(colId);
    }

    protected void checkPositionedStatement(String cursorName, String psName) throws StandardException {
        ExecPreparedStatement ps = this.getPreparedStatement();
        if (ps == null) {
            return;
        }
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        CursorActivation cursorActivation = lcc.lookupCursorActivation(cursorName);
        if (cursorActivation != null && !psName.equals(cursorActivation.getPreparedStatement().getObjectName())) {
            ps.makeInvalid(5, lcc);
        }
    }

    public NoPutResultSet materializeResultSetIfPossible(NoPutResultSet rs) throws StandardException {
        rs.openCore();
        Vector<ExecRow> rowCache = new Vector<ExecRow>();
        int cacheSize = 0;
        FormatableBitSet toClone = null;
        int maxMemoryPerTable = this.getLanguageConnectionContext().getOptimizerFactory().getMaxMemoryPerTable();
        ExecRow aRow = rs.getNextRowCore();
        if (aRow != null) {
            toClone = new FormatableBitSet(aRow.nColumns() + 1);
            toClone.set(1);
        }
        while (aRow != null && (cacheSize += aRow.getColumn(1).getLength()) <= maxMemoryPerTable && rowCache.size() <= 512) {
            rowCache.addElement(aRow.getClone(toClone));
            aRow = rs.getNextRowCore();
        }
        rs.close();
        if (aRow == null) {
            int rsNum = rs.resultSetNumber();
            int numRows = rowCache.size();
            if (numRows == 0) {
                return new RowResultSet((Activation)this, (ExecRow)null, true, rsNum, 0.0, 0.0);
            }
            RowResultSet[] rrs = new RowResultSet[numRows];
            UnionResultSet[] urs = new UnionResultSet[numRows - 1];
            for (int i = 0; i < numRows; ++i) {
                rrs[i] = new RowResultSet((Activation)this, (ExecRow)rowCache.elementAt(i), true, rsNum, 1.0, 0.0);
                if (i <= 0) continue;
                urs[i - 1] = new UnionResultSet(i > 1 ? urs[i - 2] : rrs[0], rrs[i], this, rsNum, i + 1, 0.0);
            }
            rs.finish();
            if (numRows == 1) {
                return rrs[0];
            }
            return urs[urs.length - 1];
        }
        return rs;
    }

    public void setParentResultSet(TemporaryRowHolder rs, String resultSetId) {
        Vector<TemporaryRowHolder> rsVector;
        if (this.parentResultSets == null) {
            this.parentResultSets = new Hashtable();
        }
        if ((rsVector = (Vector<TemporaryRowHolder>)this.parentResultSets.get(resultSetId)) == null) {
            rsVector = new Vector<TemporaryRowHolder>();
            rsVector.addElement(rs);
        } else {
            rsVector.addElement(rs);
        }
        this.parentResultSets.put(resultSetId, rsVector);
    }

    public Vector getParentResultSet(String resultSetId) {
        return (Vector)this.parentResultSets.get(resultSetId);
    }

    public Hashtable getParentResultSets() {
        return this.parentResultSets;
    }

    public void clearParentResultSets() {
        if (this.parentResultSets != null) {
            this.parentResultSets.clear();
        }
    }

    public void setForUpdateIndexScan(CursorResultSet forUpdateIndexScan) {
        this.forUpdateIndexScan = forUpdateIndexScan;
    }

    public CursorResultSet getForUpdateIndexScan() {
        return this.forUpdateIndexScan;
    }

    protected Calendar getCalendar() {
        if (this.cal == null) {
            this.cal = new GregorianCalendar();
        }
        return this.cal;
    }

    public final LanguageConnectionContext getLanguageConnectionContext() {
        return this.lcc;
    }

    public final TransactionController getTransactionController() {
        return this.lcc.getTransactionExecute();
    }

    public ContextManager getContextManager() {
        return this.cm;
    }

    public DataValueFactory getDataValueFactory() {
        return this.getLanguageConnectionContext().getDataValueFactory();
    }

    public Connection getCurrentConnection() throws SQLException {
        ConnectionContext cc = (ConnectionContext)((Object)this.getContextManager().getContext("JDBC_ConnectionContext"));
        return cc.getNestedConnection(true);
    }

    public java.sql.ResultSet[][] getDynamicResults() {
        return null;
    }

    public int getMaxDynamicResults() {
        return 0;
    }

    public NumberDataValue getDB2Length(DataValueDescriptor value, int constantLength, NumberDataValue reUse) throws StandardException {
        if (reUse == null) {
            reUse = this.getDataValueFactory().getNullInteger(null);
        }
        if (value.isNull()) {
            reUse.setToNull();
        } else if (constantLength >= 0) {
            reUse.setValue(constantLength);
        } else {
            reUse.setValue(value.getLength());
        }
        return reUse;
    }

    public DependableFinder getDependableFinder() {
        return null;
    }

    public String getObjectName() {
        return this.UUIDString;
    }

    public UUID getObjectID() {
        return this.UUIDValue;
    }

    public String getClassType() {
        return "Activation";
    }

    public boolean isPersistent() {
        return false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 48: {
                this.isValid = false;
                DependencyManager dm = lcc.getDataDictionary().getDependencyManager();
                dm.clearDependencies(lcc, this);
                break;
            }
            case 47: {
                break;
            }
            case 23: {
                break;
            }
            default: {
                SanityManager.DEBUG_PRINT("BaseActivation", "action=" + action);
                SanityManager.NOTREACHED();
            }
        }
    }

    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
    }
}

