/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropRoleConstantAction
extends DDLConstantAction {
    private final String roleName;

    DropRoleConstantAction(String roleName) {
        this.roleName = roleName;
    }

    public String toString() {
        return "DROP ROLE " + this.roleName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        String role;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        RoleGrantDescriptor rdDef = dd.getRoleDefinitionDescriptor(this.roleName);
        if (rdDef == null) {
            throw StandardException.newException("0P000", this.roleName);
        }
        RoleClosureIterator rci = dd.createRoleClosureIterator(activation.getTransactionController(), this.roleName, false);
        while ((role = rci.next()) != null) {
            RoleGrantDescriptor r = dd.getRoleDefinitionDescriptor(role);
            dd.getDependencyManager().invalidateFor(r, 47, lcc);
        }
        rdDef.drop(lcc);
        dd.dropRoleGrantsByGrantee(this.roleName, tc);
        dd.dropRoleGrantsByName(this.roleName, tc);
        dd.dropAllPermsByGrantee(this.roleName, tc);
    }
}

