/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ScanResultSet;

class LastIndexKeyResultSet
extends ScanResultSet {
    protected long conglomId;
    protected GeneratedMethod resultRowAllocator;
    protected GeneratedMethod startKeyGetter;
    protected int startSearchOperator;
    protected GeneratedMethod stopKeyGetter;
    protected int stopSearchOperator;
    protected Qualifier[][] qualifiers;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    protected boolean runTimeStatisticsOn;
    public String stopPositionString;
    public boolean coarserLock;
    public boolean returnedRow;

    public LastIndexKeyResultSet(Activation activation, int resultSetNumber, GeneratedMethod resultRowAllocator, long conglomId, String tableName, String userSuppliedOptimizerOverrides, String indexName, int colRefItem, int lockMode, boolean tableLocked, int isolationLevel, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, resultRowAllocator, lockMode, tableLocked, isolationLevel, colRefItem, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.conglomId = conglomId;
        SanityManager.ASSERT(activation != null, "this scan must get activation context");
        SanityManager.ASSERT(resultRowAllocator != null, "this scan must get row allocator");
        this.resultRowAllocator = resultRowAllocator;
        this.tableName = tableName;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.indexName = indexName;
        this.runTimeStatisticsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        if (SanityManager.DEBUG_ON("ScanTrace")) {
            // empty if block
        }
        activation.informOfRowCount(this, 1L);
        this.recordConstructorTime();
    }

    boolean canGetInstantaneousLocks() {
        return true;
    }

    public void openCore() throws StandardException {
        ExecRow candidateCopy = this.candidate.getClone();
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(!this.isOpen, "LastIndexKeyResultSet already open");
        this.isOpen = true;
        TransactionController tc = this.activation.getTransactionController();
        this.initIsolationLevel();
        if (tc.fetchMaxOnBtree(this.conglomId, 0, this.lockMode, this.isolationLevel, this.accessedCols, candidateCopy.getRowArray())) {
            this.setCurrentRow(this.getCompactRow(candidateCopy, this.accessedCols, true));
        } else {
            this.clearCurrentRow();
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        if (this.returnedRow || !this.isOpen) {
            this.clearCurrentRow();
        } else {
            this.returnedRow = true;
        }
        return this.currentRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.isOpen = false;
            this.returnedRow = false;
            this.clearCurrentRow();
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of LastIndexKeyResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime;
        }
        return totTime;
    }

    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }
}

