/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ConglomerateFactory;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.index.B2I;
import org.apache.derby.impl.store.access.btree.index.B2I_10_3;
import org.apache.derby.impl.store.access.btree.index.B2I_v10_2;

public class B2IFactory
implements ConglomerateFactory,
ModuleControl {
    private static final String IMPLEMENTATIONID = "BTREE";
    private static final String FORMATUUIDSTRING = "C6CEEEF0-DAD3-11d0-BB01-0060973F0942";
    private UUID formatUUID;

    public Properties defaultProperties() {
        return new Properties();
    }

    public boolean supportsImplementation(String implementationId) {
        return implementationId.equals(IMPLEMENTATIONID);
    }

    public String primaryImplementationType() {
        return IMPLEMENTATIONID;
    }

    public boolean supportsFormat(UUID formatid) {
        return formatid.equals(this.formatUUID);
    }

    public UUID primaryFormat() {
        return this.formatUUID;
    }

    public int getConglomerateFactoryId() {
        return 1;
    }

    public Conglomerate createConglomerate(TransactionManager xact_mgr, int segment, long input_containerid, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int temporaryFlag) throws StandardException {
        B2I btree = null;
        btree = xact_mgr.checkVersion(10, 4, null) ? new B2I() : (xact_mgr.checkVersion(10, 3, null) ? new B2I_10_3() : new B2I_v10_2());
        btree.create(xact_mgr, segment, input_containerid, template, columnOrder, collationIds, properties, temporaryFlag);
        return btree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conglomerate readConglomerate(TransactionManager xact_manager, ContainerKey container_key) throws StandardException {
        B2I btree = null;
        ContainerHandle container = null;
        ControlRow root = null;
        try {
            container = xact_manager.getRawStoreXact().openContainer(container_key, null, 8);
            if (container == null) {
                throw StandardException.newException("XSAI2.S", new Long(container_key.getContainerId()));
            }
            root = ControlRow.get(container, 1L);
            SanityManager.ASSERT(root.getPage().isLatched());
            btree = (B2I)root.getConglom(470);
            SanityManager.ASSERT(btree instanceof B2I);
        }
        finally {
            if (root != null) {
                root.release();
            }
            if (container != null) {
                container.close();
            }
        }
        return btree;
    }

    public boolean canSupport(Properties startParams) {
        String impl = startParams.getProperty("derby.access.Conglomerate.type");
        if (impl == null) {
            return false;
        }
        return this.supportsImplementation(impl);
    }

    public void boot(boolean create, Properties startParams) throws StandardException {
        UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.formatUUID = uuidFactory.recreateUUID(FORMATUUIDSTRING);
    }

    public void stop() {
    }
}

