/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.util.ByteArray;

public class ChecksumOperation
implements Loggable {
    private byte checksumAlgo;
    private long checksumValue;
    private int dataLength;
    private Checksum checksum;
    public static final byte CRC32_ALGORITHM = 1;
    private static final int formatLength = FormatIdUtil.getFormatIdByteLength(453);

    public void init() {
        this.checksumAlgo = 1;
        this.initializeChecksumAlgo();
        this.dataLength = 0;
    }

    protected void update(byte[] buf, int off, int len) {
        this.checksum.update(buf, off, len);
        this.dataLength += len;
    }

    protected void reset() {
        this.checksum.reset();
        this.dataLength = 0;
    }

    private void initializeChecksumAlgo() {
        if (this.checksumAlgo == 1) {
            this.checksum = new CRC32();
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.checksumValue = this.checksum.getValue();
        out.writeByte(this.checksumAlgo);
        out.writeInt(this.dataLength);
        out.writeLong(this.checksumValue);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.checksumAlgo = (byte)in.readUnsignedByte();
        this.dataLength = in.readInt();
        this.checksumValue = in.readLong();
        this.initializeChecksumAlgo();
    }

    public int getStoredSize() {
        return formatLength + 1 + 4 + 8;
    }

    public int getTypeFormatId() {
        return 453;
    }

    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException {
    }

    public ByteArray getPreparedLog() {
        return null;
    }

    public boolean needsRedo(Transaction xact) {
        return false;
    }

    public void releaseResource(Transaction xact) {
    }

    public int group() {
        return 2304;
    }

    protected int getDataLength() {
        return this.dataLength;
    }

    protected boolean isChecksumValid(byte[] data, int off, int length) {
        this.checksum.reset();
        this.checksum.update(data, off, length);
        return this.checksum.getValue() == this.checksumValue;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(200).append("Checksum Operation ").append(" algorithm = ").append(this.checksumAlgo).append(" value = ").append(this.checksumValue).append(" data length= ").append(this.dataLength);
        return str.toString();
    }
}

