/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.actions;

import fr.inra.adonis.editeurgraphique.AdonisGraphicalEditor;
import fr.inra.adonis.editeurgraphique.commands.CopyCommand;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.part.ZoneDeTextePart;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.persistance.AbstractDAOFactory;
import fr.inra.adonis.persistance.SiteDAO;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CopyAction
extends SelectionAction {
    private final AdonisGraphicalEditor adonisGraphicalEditor;
    private final SiteDAO siteDao;
    private final ObjetMetier rootObjectMetier;

    public CopyAction(AdonisGraphicalEditor adonisGraphicalEditor) {
        super((IWorkbenchPart)adonisGraphicalEditor);
        this.adonisGraphicalEditor = adonisGraphicalEditor;
        this.rootObjectMetier = adonisGraphicalEditor.getRootObjetMetier();
        this.siteDao = AbstractDAOFactory.getInstance().getSiteDAO();
    }

    protected void init() {
        super.init();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setText("Copier");
        this.setId(ActionFactory.COPY.getId());
        this.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setEnabled(false);
    }

    private Command createCopyCommand(List<Object> selectedObjects) {
        if (selectedObjects == null || selectedObjects.isEmpty()) {
            return null;
        }
        Shell shell = this.adonisGraphicalEditor.getGraphicalViewer().getControl().getShell();
        if (!this.siteDao.getVerrouManager().verrouilleRessourceAssociee(shell, (EObject)this.rootObjectMetier, false)) {
            return null;
        }
        CopyCommand cmd = new CopyCommand(this.adonisGraphicalEditor.getRootObjetMetier(), shell);
        for (Object obj : selectedObjects) {
            if (obj instanceof ObjetMetierPart) {
                ObjetMetierPart ep = (ObjetMetierPart)((Object)obj);
                if (!cmd.isCopyableNode(ep)) {
                    return null;
                }
                cmd.addElement(ep);
                continue;
            }
            if (!(obj instanceof ZoneDeTextePart)) continue;
            cmd.addElement((ZoneDeTextePart)((Object)obj));
        }
        return cmd;
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createCopyCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void run() {
        Command cmd = this.createCopyCommand(this.getSelectedObjects());
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
        }
    }
}

