/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.actions;

import fr.inra.adonis.core.rcp.AdonisPropertySheetPage;
import fr.inra.adonis.core.util.EditorUtils;
import fr.inra.adonis.editeurgraphique.AdonisGraphicalEditor;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.icons.IconsRegistry;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.persistance.AbstractDAOFactory;
import fr.inra.adonis.persistance.SiteDAO;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class CouleurAction
extends DirectEditAction {
    public static final String ID = "fr.inra.adonis.editeurgraphique.actions.CouleurAction";
    private final SiteDAO siteDao;
    private final ObjetMetier rootObjectMetier;
    private final List<ObjetMetier> selection = new ArrayList<ObjetMetier>();

    public CouleurAction(IWorkbenchPart part, ObjetMetier rootObjectMetier) {
        super(part);
        this.rootObjectMetier = rootObjectMetier;
        this.siteDao = AbstractDAOFactory.getInstance().getSiteDAO();
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)IconsRegistry.IMG_GRAPHIC));
        this.setText("Changer la couleur");
    }

    protected boolean calculateEnabled() {
        this.selection.clear();
        AdonisGraphicalEditor editor = (AdonisGraphicalEditor)this.getWorkbenchPart();
        List list = editor.getGraphicalViewer().getSelectedEditParts();
        if (list == null) {
            return false;
        }
        for (Object o : list) {
            if (!(o instanceof ObjetMetierPart)) continue;
            ObjetMetier model = (ObjetMetier)((ObjetMetierPart)((Object)o)).getModel();
            this.selection.add(model);
        }
        if (this.selection.isEmpty()) {
            return false;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        return this.siteDao.getVerrouManager().verrouilleRessourceAssociee(shell, (EObject)this.rootObjectMetier, false);
    }

    public void run() {
        Shell shell = Display.getCurrent().getActiveShell();
        ColorDialog dialog = new ColorDialog(shell, 0);
        dialog.setText("Choix d'une couleur");
        RGB rgb = dialog.open();
        if (rgb != null) {
            final Color color = new Color((Device)Display.getCurrent(), rgb);
            TransactionalEditingDomain editDomain = EditorUtils.getTransactionalEditingDomain();
            EditorUtils.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(editDomain){

                protected void doExecute() {
                    for (ObjetMetier select : CouleurAction.this.selection) {
                        select.setCouleur(color.toString());
                    }
                }
            });
            AdonisGraphicalEditor editor = (AdonisGraphicalEditor)this.getWorkbenchPart();
            ((AdonisPropertySheetPage)editor.getPropertySheetPage()).refresh();
            List list = editor.getGraphicalViewer().getSelectedEditParts();
            if (list != null) {
                for (Object o : list) {
                    ((EditPart)o).refresh();
                }
            }
        }
    }

    public String getId() {
        return ID;
    }
}

