/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.actions;

import fr.inra.adonis.core.rcp.AdonisLabelProvider;
import fr.inra.adonis.editeurgraphique.EditeurGraphiqueActivator;
import fr.inra.adonis.editeurgraphique.part.AdonisRootEditPart;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.rulers.custom.AdonisRulerComposite;
import fr.inra.adonis.editeurgraphique.tools.ExportImageUtil;
import fr.inra.adonis.editeurgraphique.tools.SVGImageExporter;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportImageAction
extends Action {
    public static final String ID = "fr.inra.adonis.editeurgraphique.actions.ExportImageAction";
    private final GraphicalViewer viewer;
    private final AdonisRulerComposite rulerComposite;

    public ExportImageAction(GraphicalViewer viewer, AdonisRulerComposite rulerComposite) {
        this.viewer = viewer;
        this.rulerComposite = rulerComposite;
        this.setText("Export Png");
        this.setId(ID);
    }

    public void run() {
        AdonisRootEditPart diagramRootPart = (AdonisRootEditPart)this.rulerComposite.getDiagramViewer().getContents().getRoot();
        ObjetMetierPart diagramPart = (ObjetMetierPart)diagramRootPart.getContents();
        String filename = String.valueOf(diagramPart.getModel().getClass().getSimpleName()) + " " + AdonisLabelProvider.getInstance().getText(diagramPart.getModel());
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        dialog.setFileName(filename);
        dialog.setFilterNames(new String[]{"Bitmap (*.png)", "Vectoriel (*.svg)"});
        dialog.setFilterExtensions(new String[]{"*.png", "*.svg"});
        dialog.setText("Emplacement du fichier \u00e0 exporter (Editeur graphique actif)");
        String path = dialog.open();
        if (path != null) {
            Display device = this.viewer.getControl().getDisplay();
            ArrayList<IFigure> figures = new ArrayList<IFigure>();
            LayeredPane layer = diagramRootPart.getPrintableLayers();
            for (Object fig : layer.getChildren()) {
                figures.add((IFigure)fig);
            }
            GridLayer grid = diagramRootPart.getGridLayer();
            if (grid != null) {
                figures.add((IFigure)grid);
            }
            try {
                File file = new File(path);
                String fullFilename = file.getAbsolutePath();
                String extension = ".png";
                if (dialog.getFilterIndex() == 1) {
                    extension = ".svg";
                }
                if (!fullFilename.endsWith(extension)) {
                    fullFilename = String.valueOf(fullFilename) + extension;
                }
                FileOutputStream fos = new FileOutputStream(fullFilename);
                try {
                    double zoom = 1.0;
                    if (diagramRootPart.getZoomManager() != null) {
                        zoom = diagramRootPart.getZoomManager().getZoom();
                        diagramRootPart.getZoomManager().setZoom(1.0);
                        diagramRootPart.refresh();
                    }
                    if (dialog.getFilterIndex() == 1) {
                        SVGImageExporter.export(diagramRootPart, this.rulerComposite, figures, fos);
                    } else {
                        byte[] bytes = ExportImageUtil.createImageWithRuler(diagramRootPart, this.rulerComposite, 5, (Device)device, figures, 4000, 4000);
                        fos.write(bytes);
                    }
                    if (diagramRootPart.getZoomManager() != null) {
                        diagramRootPart.getZoomManager().setZoom(zoom);
                        diagramRootPart.refresh();
                    }
                }
                finally {
                    fos.close();
                }
            }
            catch (Throwable e) {
                MessageDialog.openError((Shell)this.rulerComposite.getShell(), (String)"Erreur lors de la g\u00e9n\u00e9ration de l'image", (String)("Impossible de cr\u00e9er l'image l'erreur suivante a \u00e9t\u00e9 g\u00e9n\u00e9r\u00e9e:\n" + e.getClass().getName() + ":    " + e.getLocalizedMessage()));
                EditeurGraphiqueActivator.getLogger().logError(e);
            }
        }
    }
}

