/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.cheminement;

import fr.inra.adonis.editeurgraphique.OutlinePage;
import fr.inra.adonis.editeurgraphique.part.AdonisRootEditPart;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.rulers.custom.AdonisRulerComposite;
import fr.inra.adonis.editeurgraphique.tools.ConnectionsUtil;
import fr.inra.adonis.editeurgraphique.tools.ViewUtil;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.projetDeSaisie.ProjetDeSaisie;
import fr.inra.adonis.modeleMetier.projetDeSaisie.cheminement.CheminementCalcule;
import fr.inra.adonis.modeleMetier.projetDeSaisie.cheminement.SectionCheminement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractCheminementEditor
extends GraphicalEditorWithPalette {
    protected ObjetMetier rootObjetMetier;
    private CheminementCalcule cheminement;
    private AdonisRulerComposite rulerComp;
    protected CheminementEditorAdapter adapter = new CheminementEditorAdapter();

    public AbstractCheminementEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public AdonisRulerComposite getRulerComp() {
        return this.rulerComp;
    }

    protected void cheminementChanged(Notification notification) {
        if (this.cheminement == null) {
            return;
        }
        GraphicalViewer viewer = this.getGraphicalViewer();
        this.cheminement = (CheminementCalcule)this.getEditorInput().getAdapter(CheminementCalcule.class);
        if (this.cheminement != null) {
            ConnectionsUtil.createConnectionsGraphique((ObjetMetierPart)viewer.getContents(), this.cheminement);
            viewer.getContents().refresh();
        }
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        this.rootObjetMetier = (ObjetMetier)this.getEditorInput().getAdapter(ObjetMetier.class);
        if (this.rootObjetMetier != null) {
            viewer.setContents((Object)this.rootObjetMetier);
        }
        this.cheminement = (CheminementCalcule)this.getEditorInput().getAdapter(CheminementCalcule.class);
        if (this.cheminement != null) {
            SectionCheminement sectChem = (SectionCheminement)this.cheminement.eContainer();
            ProjetDeSaisie pds = (ProjetDeSaisie)sectChem.eContainer();
            String nomProjetSaisie = pds.getNom();
            String nomPlateforme = pds.getPlateforme().getNom();
            String nomSectionCheminement = sectChem.getName();
            this.setContentDescription("Projet " + nomProjetSaisie + " / PF " + nomPlateforme + " / Chem. " + nomSectionCheminement);
            this.adapter.stopNotification = false;
            ConnectionsUtil.createConnectionsGraphique((ObjetMetierPart)viewer.getContents(), this.cheminement);
            this.cheminement.eAdapters().add((Object)this.adapter);
        }
    }

    protected void createGraphicalViewer(Composite parent) {
        this.rulerComp = new AdonisRulerComposite(parent, 0);
        super.createGraphicalViewer((Composite)this.rulerComp);
        this.rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    public void dispose() {
        if (this.adapter != null) {
            this.adapter.stopNotification = true;
            if (this.cheminement != null) {
                this.cheminement.eAdapters().remove((Object)this.adapter);
            }
        }
        super.dispose();
        ViewUtil.closeView("org.eclipse.ui.views.ContentOutline");
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return ((AdonisRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (type == IContentOutlinePage.class) {
            return new OutlinePage(this.getGraphicalViewer());
        }
        return super.getAdapter(type);
    }

    protected void configureKeyHandler() {
        this.getGraphicalViewer().setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(this.getGraphicalViewer()));
    }

    private final class CheminementEditorAdapter
    extends EContentAdapter {
        private boolean stopNotification;

        private CheminementEditorAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (!this.stopNotification) {
                AbstractCheminementEditor.this.cheminementChanged(notification);
            }
        }
    }
}

