/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.cheminement;

import fr.inra.adonis.editeurgraphique.EditorModeEnum;
import fr.inra.adonis.editeurgraphique.GraphicalConfigurator;
import fr.inra.adonis.editeurgraphique.actions.ExportImageAction;
import fr.inra.adonis.editeurgraphique.actions.ZoomInFontAction;
import fr.inra.adonis.editeurgraphique.actions.ZoomOutFontAction;
import fr.inra.adonis.editeurgraphique.cheminement.AbstractCheminementEditor;
import fr.inra.adonis.editeurgraphique.tools.ZoomUtil;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.projetDeSaisie.ProjetDeSaisie;
import fr.inra.adonis.modeleMetier.projetDeSaisie.cheminement.CheminementCalcule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.jface.action.IAction;

public class DisplayCheminementEditor
extends AbstractCheminementEditor {
    public static final String ID = "fr.inra.adonis.editeurgraphique.cheminement.DisplayCheminementEditor";

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.rootObjetMetier = (ObjetMetier)this.getEditorInput().getAdapter(ObjetMetier.class);
        CheminementCalcule chem = (CheminementCalcule)this.getEditorInput().getAdapter(CheminementCalcule.class);
        if (chem != null) {
            String title = "";
            EObject parent = chem.eContainer();
            while (parent != null) {
                if (parent instanceof ProjetDeSaisie) {
                    title = "Proj: " + ((ProjetDeSaisie)parent).getNom() + "/";
                    break;
                }
                parent = parent.eContainer();
            }
            if (this.rootObjetMetier instanceof Plateforme) {
                title = String.valueOf(title) + "PF: " + ((Plateforme)this.rootObjetMetier).getNom() + "/";
            }
            title = String.valueOf(title) + "Chem. " + chem.getNom() + "/" + chem.getUtilisateur().getPrenom() + " " + chem.getUtilisateur().getNom();
            this.setPartName(title);
        }
        GraphicalViewer viewer = this.getGraphicalViewer();
        GraphicalConfigurator.configureGraphicalViewer(viewer, EditorModeEnum.VISUALISATION, this.rootObjetMetier);
        this.getActionRegistry().registerAction((IAction)new ToggleGridAction(viewer));
        this.getActionRegistry().registerAction((IAction)new ZoomOutFontAction(viewer, this.getRulerComp()));
        this.getActionRegistry().registerAction((IAction)new ZoomInFontAction(viewer, this.getRulerComp()));
        this.getActionRegistry().registerAction((IAction)new ExportImageAction(viewer, this.getRulerComp()));
        ZoomUtil.configureZoom(this.getActionRegistry(), this.getGraphicalViewer());
        this.configureKeyHandler();
    }

    protected PaletteRoot getPaletteRoot() {
        return null;
    }
}

