/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.commands;

import fr.inra.adonis.core.controle.Coordonnees;
import fr.inra.adonis.core.parcours.Parcours;
import fr.inra.adonis.editeurgraphique.commands.AbstractCreateCommand;
import fr.inra.adonis.editeurgraphique.tools.ObjectSelectionUtil;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.NatureZhe;
import fr.inra.adonis.modeleMetier.plateforme.PuSurfacique;
import fr.inra.adonis.modeleMetier.plateforme.UniteDeParcours;
import fr.inra.adonis.modeleMetier.plateforme.ZheAvecEpaisseur;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;

public class ZHECreateCommand
extends AbstractCreateCommand {
    public ZHECreateCommand(GraphicalViewer gv, List<Point> pointsToAdd, EditPart part) {
        super(gv, pointsToAdd, part);
        this.setParent(ObjectSelectionUtil.selectParent(gv, ZheAvecEpaisseur.class));
    }

    @Override
    public boolean canExecute() {
        if (!super.canExecute()) {
            return false;
        }
        if (!(this.getParent() instanceof UniteDeParcours) || this.getParent() instanceof PuSurfacique) {
            return false;
        }
        UniteDeParcours metier = (UniteDeParcours)this.getParent();
        Set<Coordonnees> coords = ZHECreateCommand.getListCoordVoisins((ObjetMetier)metier);
        for (Coordonnees coord : coords) {
            for (Point p : this.getListPointToAdd()) {
                if (coord.getX() != p.x || coord.getY() != p.y) continue;
                return true;
            }
        }
        final ArrayList contenu = new ArrayList();
        Parcours parcours = new Parcours(){

            public void parcoursIndividu(Individu ind) {
                contenu.add(ind);
            }

            public void parcoursPuSurfacique(PuSurfacique pu) {
                contenu.add(pu);
            }

            public void parcoursZhe(ZheAvecEpaisseur zhe) {
                contenu.add(zhe);
            }
        };
        parcours.setAscendant(false);
        parcours.parcours(this.getParent());
        return contenu.isEmpty();
    }

    @Override
    public void executeCommand() {
        NatureZhe nature = (NatureZhe)this.getGraphicalViewer().getProperty("natureZhe");
        if (nature != null) {
            UniteDeParcours uniteParcours = (UniteDeParcours)this.getParent();
            ZHECreateCommand.createZhe(this.getListPointToAdd(), uniteParcours, nature);
            this.refreshPropertyTester();
        }
    }
}

