/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.editpolicies;

import fr.inra.adonis.core.controle.Deplacement;
import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.core.util.UtilisateurCourant;
import fr.inra.adonis.droitsacces.util.DroitsAccesUtil;
import fr.inra.adonis.editeurgraphique.EditorModeEnum;
import fr.inra.adonis.editeurgraphique.commands.AbstractCommand;
import fr.inra.adonis.editeurgraphique.commands.BlocCreateCommand;
import fr.inra.adonis.editeurgraphique.commands.IndividuCreateCommand;
import fr.inra.adonis.editeurgraphique.commands.PUCreateCommand;
import fr.inra.adonis.editeurgraphique.commands.SousBlocCreateCommand;
import fr.inra.adonis.editeurgraphique.commands.ZHECreateCommand;
import fr.inra.adonis.editeurgraphique.commands.ZoneDeTexteCreateCommand;
import fr.inra.adonis.editeurgraphique.editpolicies.AdonisResizeablePolicy;
import fr.inra.adonis.editeurgraphique.editpolicies.TranslateCommand;
import fr.inra.adonis.editeurgraphique.part.AdonisRootEditPart;
import fr.inra.adonis.editeurgraphique.part.FlecheNordPart;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.part.ZoneDeTextePart;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.graphique.FlecheNord;
import fr.inra.adonis.modeleMetier.graphique.ZoneDeTexte;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.EtatDispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.ZheAvecEpaisseur;
import fr.inra.adonis.modeleMetier.utilisateur.TypeAction;
import fr.inra.adonis.modeleMetier.utilisateur.Utilisateur;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class ObjEditLayoutPolicy
extends XYLayoutEditPolicy
implements TranslateCommand.ITranslationDoneListener {
    private static TranslateCommand deplacement;
    private GraphicalViewer graphicalViewer;

    public void setHost(EditPart host) {
        super.setHost(host);
        this.graphicalViewer = (GraphicalViewer)this.getHost().getViewer();
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (this.graphicalViewer.getProperty("editorMode") == EditorModeEnum.EDITION_PLATEFORME) {
            double zoom = ((AdonisRootEditPart)this.graphicalViewer.getRootEditPart()).getZoomManager().getZoom();
            ChangeBoundsRequest changeBoundRequest = request;
            Point pmove = changeBoundRequest.getMoveDelta().scale(1.0 / zoom);
            Point newpoint1 = new Point();
            GraphicalProperties properties = (GraphicalProperties)this.graphicalViewer.getProperty("graphicalProperties");
            newpoint1.x = (int)Math.round((double)properties.getCoeffX() * ((double)pmove.x / (double)properties.getLargeurMaille()));
            newpoint1.y = (int)Math.round((double)properties.getCoeffY() * ((double)pmove.y / (double)properties.getHauteurMaille()));
            final Point newpoint = newpoint1;
            if (child instanceof ObjetMetierPart) {
                ObjetMetier metier = (ObjetMetier)((ObjetMetierPart)child).getModel();
                Dispositif disp = DispositifUtil.getDispositifFrom((EObject)metier);
                if (disp.getEtat() != EtatDispositif.CREE || !DroitsAccesUtil.isDroitsAccesDispositif((Utilisateur)UtilisateurCourant.getInstance(), (Dispositif)disp, (TypeAction)TypeAction.EDITER)) {
                    return null;
                }
                Deplacement.SensDeplacement sens = Deplacement.SensDeplacement.Horizontal;
                if (((Boolean)this.getHost().getViewer().getProperty("shiftPressed")).booleanValue()) {
                    sens = Deplacement.SensDeplacement.Vertical;
                }
                if (deplacement == null) {
                    deplacement = new TranslateCommand(newpoint.x, newpoint.y, sens, this.graphicalViewer, metier);
                    deplacement.addTranslationDoneListener(this);
                } else if (deplacement.getX() != newpoint.x || deplacement.getY() != newpoint.y || deplacement.getSens() != sens) {
                    deplacement.changeProperties(newpoint.x, newpoint.y, sens, metier);
                }
                deplacement.addObj(metier);
                return deplacement;
            }
            if (child instanceof ZoneDeTextePart) {
                final ZoneDeTexte model = (ZoneDeTexte)child.getModel();
                final Rectangle rect = (Rectangle)constraint;
                AbstractCommand cmd = new AbstractCommand(this.getHost().getModel(), this.graphicalViewer.getControl().getShell()){

                    @Override
                    public void executeCommand() {
                        int x = newpoint.x + model.getX();
                        int y = newpoint.y + model.getY();
                        model.setX(x > 0 ? x : 1);
                        model.setY(y > 0 ? y : 1);
                        model.setLongueur(rect.width);
                        model.setHauteur(rect.height);
                    }
                };
                return cmd;
            }
            if (child instanceof FlecheNordPart) {
                final FlecheNord model = (FlecheNord)child.getModel();
                AbstractCommand cmd = new AbstractCommand(this.getHost().getModel(), this.graphicalViewer.getControl().getShell()){

                    @Override
                    public void executeCommand() {
                        int x = newpoint.x + model.getX();
                        int y = newpoint.y + model.getY();
                        model.setX(x > 0 ? x : 1);
                        model.setY(y > 0 ? y : 1);
                    }
                };
                return cmd;
            }
        }
        return null;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        GraphicalViewer gv = (GraphicalViewer)this.getHost().getViewer();
        if (gv.getProperty("editorMode") == EditorModeEnum.EDITION_PLATEFORME) {
            Class classObjectToCreate = (Class)gv.getProperty("typeObjetToCreate");
            Rectangle req = (Rectangle)this.getConstraintFor(request);
            Rectangle constraint = new Rectangle(req);
            constraint.x = this.getLayoutOrigin().x + req.x;
            constraint.y = this.getLayoutOrigin().y + req.y;
            if (classObjectToCreate == ZoneDeTexte.class) {
                return new ZoneDeTexteCreateCommand(gv, constraint, this.getHost());
            }
            if (classObjectToCreate == Individu.class) {
                List<Point> pointsToAdd = this.getListPointIndividus(constraint);
                return new IndividuCreateCommand(gv, pointsToAdd, this.getHost());
            }
            if (classObjectToCreate == ParcelleUnitaire.class) {
                List<Point> pointsToAdd = this.getListPointIndividus(constraint);
                return new PUCreateCommand(gv, pointsToAdd, this.getHost());
            }
            if (classObjectToCreate == SousBloc.class) {
                List<Point> pointsToAdd = this.getListPointIndividus(constraint);
                return new SousBlocCreateCommand(gv, pointsToAdd, this.getHost());
            }
            if (classObjectToCreate == Bloc.class) {
                List<Point> pointsToAdd = this.getListPointIndividus(constraint);
                return new BlocCreateCommand(gv, pointsToAdd, this.getHost());
            }
            if (classObjectToCreate == ZheAvecEpaisseur.class) {
                List<Point> pointsToAdd = this.getListPointIndividus(constraint);
                return new ZHECreateCommand(gv, pointsToAdd, this.getHost());
            }
        }
        return null;
    }

    private List<Point> getListPointIndividus(Rectangle constraint) {
        ArrayList<Point> pointsToAdd = new ArrayList<Point>();
        GraphicalProperties properties = (GraphicalProperties)this.graphicalViewer.getProperty("graphicalProperties");
        int x = properties.getCoeffX() * constraint.x / properties.getLargeurMaille();
        int y = properties.getCoeffY() * constraint.y / properties.getHauteurMaille();
        if (properties.getCoeffX() > 0) {
            ++x;
        }
        if (properties.getCoeffY() > 0) {
            ++y;
        }
        int nbLigne = constraint.width / properties.getLargeurMaille() + 1;
        int nbCol = constraint.height / properties.getHauteurMaille() + 1;
        int i = 0;
        while (i < nbLigne) {
            int j = 0;
            while (j < nbCol) {
                Point p = new Point(x + properties.getCoeffX() * i, y + properties.getCoeffY() * j);
                if (p.x > 0 && p.y > 0) {
                    pointsToAdd.add(p);
                }
                ++j;
            }
            ++i;
        }
        return pointsToAdd;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof ObjetMetierPart) {
            return new AdonisResizeablePolicy();
        }
        return super.createChildEditPolicy(child);
    }

    @Override
    public void translationDone() {
        deplacement = null;
    }
}

