/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.editpolicies;

import fr.inra.adonis.core.util.EditorUtils;
import fr.inra.adonis.editeurgraphique.figure.ZoneDeTexteFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public class ZdtDirectEditManager
extends DirectEditManager {
    protected VerifyListener verifyListener;
    protected ZoneDeTexteFigure label;
    protected Font figureFont;
    private boolean committing = false;

    public ZdtDirectEditManager(GraphicalEditPart source, Class<?> editorType, CellEditorLocator locator, ZoneDeTexteFigure lbl) {
        super(source, editorType, locator);
        this.label = lbl;
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                Text text = (Text)ZdtDirectEditManager.this.getCellEditor().getControl();
                String oldText = text.getText();
                String leftText = oldText.substring(0, event.start);
                String rightText = oldText.substring(event.end, oldText.length());
                GC gc = new GC((Drawable)text);
                if (leftText == null) {
                    leftText = "";
                }
                if (rightText == null) {
                    rightText = "";
                }
                Point size = gc.textExtent(String.valueOf(leftText) + event.text + rightText);
                gc.dispose();
                if (size.x != 0) {
                    size = text.computeSize(size.x, -1);
                } else {
                    size.x = size.y;
                }
                ZdtDirectEditManager.this.getCellEditor().getControl().setSize(size.x, size.y);
            }
        };
        text.addVerifyListener(this.verifyListener);
        this.getCellEditor().setValue((Object)this.label.getText());
        this.figureFont = this.label.getFont();
        FontData data = this.figureFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        this.label.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        this.figureFont = new Font(null, data);
        text.setFont(this.figureFont);
        text.selectAll();
    }

    protected void commit() {
        if (this.committing) {
            return;
        }
        this.committing = true;
        try {
            org.eclipse.gef.commands.Command command;
            this.getCellEditor().getControl().setVisible(false);
            if (this.isDirty() && (command = this.getEditPart().getCommand((Request)this.getDirectEditRequest())) != null && command.canExecute()) {
                final CommandStack stack = this.getEditPart().getViewer().getEditDomain().getCommandStack();
                TransactionalEditingDomain editDomain = EditorUtils.getTransactionalEditingDomain();
                EditorUtils.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(editDomain){

                    protected void doExecute() {
                        stack.execute(command);
                    }
                });
            }
        }
        finally {
            this.bringDown();
            this.committing = false;
        }
    }

    protected void bringDown() {
        Font disposeFont = this.figureFont;
        this.figureFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
    }
}

