/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.figure;

import com.swtdesigner.SWTResourceManager;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class FeuilleFigure
extends RectangleFigure {
    private final Label txtLabel;
    private final Label imgLabel;
    private int facteurFont = 0;

    public FeuilleFigure(Color bg) {
        XYLayout layout = new XYLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.setOpaque(true);
        this.setFill(true);
        this.setForegroundColor(ColorConstants.black);
        this.setBackgroundColor(bg);
        this.txtLabel = new Label("*");
        this.imgLabel = new Label();
    }

    public void setPoints(Rectangle rect, int shrinkValue) {
        if (rect != null) {
            Rectangle constraint = new Rectangle();
            constraint.x = rect.x + shrinkValue;
            constraint.y = rect.y + shrinkValue;
            constraint.height = rect.height - shrinkValue * 2 + 1;
            constraint.width = rect.width - shrinkValue * 2 + 1;
            this.setBounds(constraint);
            this.txtLabel.setBounds(constraint);
            this.imgLabel.setBounds(constraint);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.pushState();
        this.imgLabel.setFont(graphics.getFont());
        this.imgLabel.paint(graphics);
        graphics.restoreState();
        Font nouvelleFont = null;
        try {
            if (this.facteurFont != 0) {
                FontData[] fds;
                FontData[] fontDataArray = fds = graphics.getFont().getFontData();
                if (fds.length != 0) {
                    FontData fd = fontDataArray[0];
                    int h = Math.max(2, fd.getHeight() + this.facteurFont);
                    h = Math.min(50, h);
                    nouvelleFont = SWTResourceManager.getFont((String)fd.getName(), (int)h, (int)fd.getStyle());
                }
                this.txtLabel.setFont(nouvelleFont);
            } else {
                this.txtLabel.setFont(graphics.getFont());
            }
            this.txtLabel.paint(graphics);
        }
        finally {
            graphics.restoreState();
            graphics.popState();
            this.txtLabel.setFont(null);
        }
    }

    public void setLabel(String s) {
        this.txtLabel.setText(s);
    }

    public void setImage(Image img) {
        this.imgLabel.setIcon(img);
    }

    public void setFacteurFont(int facteurFont) {
        this.facteurFont = facteurFont;
    }
}

