/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.figure;

import fr.inra.adonis.icons.IconsRegistry;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class FlecheNordFigure
extends Label {
    private int degrees;
    private Image imgDrawing;

    public FlecheNordFigure() {
        this.setIconAlignment(2);
        this.setBorder(null);
        this.setOpaque(true);
        this.setIcon(IconsRegistry.IMG_FLECHE_NORD);
    }

    public void setRotationDegrees(int deg) {
        if (this.degrees != deg || this.imgDrawing == null) {
            this.degrees = deg;
            if (this.imgDrawing != null) {
                this.imgDrawing.dispose();
            }
            Rectangle bbox = this.getIcon().getBounds();
            this.imgDrawing = new Image((Device)Display.getCurrent(), bbox);
            GC gc = null;
            SWTGraphics swtG = null;
            try {
                gc = new GC((Drawable)this.imgDrawing);
                swtG = new SWTGraphics(gc);
                swtG.translate(bbox.width / 2, bbox.height / 2);
                swtG.rotate((float)this.degrees);
                swtG.translate(-bbox.width / 2, -bbox.height / 2);
                swtG.drawImage(this.getIcon(), 0, 0);
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                }
                if (swtG != null) {
                    swtG.dispose();
                }
            }
        }
    }

    protected void paintFigure(Graphics graphics) {
        org.eclipse.draw2d.geometry.Rectangle b = this.getBounds();
        if (this.isOpaque()) {
            graphics.fillRectangle(b);
        }
        graphics.translate(b.x, b.y);
        graphics.drawImage(this.imgDrawing, this.getIconLocation());
        if (!this.isEnabled()) {
            graphics.translate(1, 1);
            graphics.setForegroundColor(ColorConstants.buttonLightest);
            graphics.drawText(this.getSubStringText(), this.getTextLocation());
            graphics.translate(-1, -1);
            graphics.setForegroundColor(ColorConstants.buttonDarker);
        }
        graphics.drawText(this.getSubStringText(), this.getTextLocation());
        graphics.translate(-b.x, -b.y);
    }
}

