/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.figure;

import com.swtdesigner.SWTResourceManager;
import fr.inra.adonis.editeurgraphique.tools.ShrinkPolygon;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class NodeFigure
extends Figure {
    private final Label txtLabel;
    private final List<Polygon> polygons;
    private final List<Figure> textures;
    private int facteurFont = 0;

    public NodeFigure() {
        XYLayout layout = new XYLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.setOpaque(false);
        this.polygons = new ArrayList<Polygon>();
        this.textures = new ArrayList<Figure>();
        this.txtLabel = new Label();
    }

    public void setPolygons(List<Polygon> pols, int shrinkValue, Color bg) {
        this.polygons.clear();
        for (Polygon polygon : pols) {
            ShrinkPolygon shrinkPolygone = new ShrinkPolygon(polygon.getPoints());
            List<Point> listPointPolygone = shrinkPolygone.getShrinkedPolygon(shrinkValue);
            PointList pl = new PointList();
            for (Point p : listPointPolygone) {
                pl.addPoint(p.x, p.y);
            }
            Polygon shrinkedPolygon = new Polygon();
            shrinkedPolygon.setPoints(pl);
            shrinkedPolygon.setOpaque(true);
            shrinkedPolygon.setFill(true);
            shrinkedPolygon.setForegroundColor(ColorConstants.black);
            shrinkedPolygon.setBackgroundColor(bg);
            this.polygons.add(shrinkedPolygon);
        }
        this.refresh();
    }

    public void setLabel(String s) {
        this.txtLabel.setText(s);
    }

    public void setFacteurFont(int facteurFont) {
        this.facteurFont = facteurFont;
    }

    public void resetImages() {
        this.textures.clear();
    }

    public void addImage(Image texture, Rectangle constraint, final Rectangle bounds) {
        Figure fig = new Figure();
        fig.setClippingStrategy(new IClippingStrategy(){

            public Rectangle[] getClip(IFigure childFigure) {
                return new Rectangle[]{bounds};
            }
        });
        fig.setBounds(constraint);
        ImageFigure img = new ImageFigure(texture);
        fig.add((IFigure)img);
        fig.setLayoutManager((LayoutManager)new XYLayout());
        img.setBounds(constraint);
        this.textures.add(fig);
    }

    public void refresh() {
        Rectangle rect = null;
        for (Polygon p : this.polygons) {
            if (rect == null) {
                rect = p.getBounds();
                continue;
            }
            rect.union(p.getBounds());
        }
        if (rect != null) {
            this.setBounds(rect);
            this.txtLabel.setBounds(rect);
        }
    }

    protected void paintChildren(Graphics graphics) {
        graphics.pushState();
        for (Polygon pol : this.polygons) {
            pol.paint(graphics);
            graphics.restoreState();
        }
        for (Figure texture : this.textures) {
            texture.paint(graphics);
            graphics.restoreState();
        }
        Font nouvelleFont = null;
        if (this.facteurFont != 0) {
            FontData[] fds;
            FontData[] fontDataArray = fds = graphics.getFont().getFontData();
            if (fds.length != 0) {
                FontData fd = fontDataArray[0];
                int h = Math.max(2, fd.getHeight() + this.facteurFont);
                h = Math.min(50, h);
                nouvelleFont = SWTResourceManager.getFont((String)fd.getName(), (int)h, (int)fd.getStyle());
            }
            this.txtLabel.setFont(nouvelleFont);
        } else {
            this.txtLabel.setFont(graphics.getFont());
        }
        this.txtLabel.paint(graphics);
        graphics.restoreState();
        graphics.popState();
        super.paintChildren(graphics);
    }

    public boolean containsPoint(int x, int y) {
        for (Polygon p : this.polygons) {
            if (!p.containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }
}

