/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.part;

import fr.inra.adonis.editeurgraphique.figure.FeuilleFigure;
import fr.inra.adonis.editeurgraphique.part.NodePart;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.PuSurfacique;
import fr.inra.adonis.modeleMetier.plateforme.ZheAvecEpaisseur;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class FeuillePart
extends ObjetMetierPart {
    private final Rectangle constraint = new Rectangle();

    protected IFigure createFigure() {
        FeuilleFigure figure = new FeuilleFigure(this.getColor());
        this.refreshFigure();
        return figure;
    }

    @Override
    public void propertyChanged(Notification notification) {
        if (notification.getEventType() == 1 && notification.getOldValue() == notification.getNewValue()) {
            return;
        }
        if (notification.getEventType() == 8) {
            return;
        }
        if (notification.getEventType() == 1 && notification.getOldValue() == this.getParent().getModel() && notification.getNewValue() == null) {
            return;
        }
        if (notification.getEventType() == 1 && notification.getOldValue() == this.getParent() && notification.getNewValue() == null) {
            return;
        }
        if ((notification.getNotifier() instanceof Individu || notification.getNotifier() instanceof ZheAvecEpaisseur || notification.getNotifier() instanceof PuSurfacique) && notification.getEventType() == 1) {
            int featureID = notification.getFeatureID(ObjetMetier.class);
            if (featureID == 3 || featureID == 4 || featureID == 14) {
                this.refreshFigure();
                EditPart parent = this.getParent();
                while (parent != null) {
                    if (parent instanceof NodePart) {
                        ((NodePart)parent).setHasToRefresh(true);
                    }
                    parent = parent.getParent();
                }
                if (!ObjetMetierPart.waitForRefresh()) {
                    this.getRoot().getContents().refresh();
                }
            } else if (featureID == 22 || featureID == 30) {
                this.refreshFigure();
                this.refreshVisuals();
            }
        } else {
            this.refreshVisuals();
        }
    }

    private void refreshFigure() {
        ObjetMetier objetMetier = (ObjetMetier)this.getModel();
        if (objetMetier.getX() == 0 && objetMetier.getY() == 0) {
            this.constraint.x = 0;
            this.constraint.y = 0;
            this.constraint.height = 0;
            this.constraint.width = 0;
        } else {
            GraphicalProperties properties = (GraphicalProperties)this.getViewer().getProperty("graphicalProperties");
            this.constraint.x = properties.getCoeffX() * (properties.getLargeurMaille() * (objetMetier.getX() - properties.getCoeffX()));
            this.constraint.y = properties.getCoeffY() * (properties.getHauteurMaille() * (objetMetier.getY() - properties.getCoeffY()));
            this.constraint.width = properties.getLargeurMaille();
            this.constraint.height = properties.getHauteurMaille();
        }
    }

    @Override
    public void refreshVisuals() {
        ObjetMetier objetMetier = (ObjetMetier)this.getModel();
        FeuilleFigure figure = (FeuilleFigure)this.getFigure();
        figure.setPoints(this.getConstraint(), FeuillePart.getShrinkValue(objetMetier));
        figure.setBackgroundColor(this.getColor());
        figure.setLabel(this.getLabel());
        figure.setFacteurFont(this.getFacteurFont());
        Image texture = null;
        if (this.getTexture() != null) {
            texture = new Image((Device)Display.getCurrent(), this.getTexture().getImageData());
        }
        figure.setImage(texture);
        this.setVisibility((Figure)figure);
        figure.repaint();
    }

    public Rectangle getConstraint() {
        return this.constraint;
    }
}

