/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.part;

import fr.inra.adonis.editeurgraphique.figure.NodeFigure;
import fr.inra.adonis.editeurgraphique.part.FeuillePart;
import fr.inra.adonis.editeurgraphique.part.FlecheNordPart;
import fr.inra.adonis.editeurgraphique.part.NodeAnchor;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.part.ZoneDeTextePart;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.graphique.FlecheNord;
import fr.inra.adonis.modeleMetier.graphique.ZoneDeTexte;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class NodePart
extends ObjetMetierPart {
    private final List<Polygon> polygons = new ArrayList<Polygon>();
    private boolean hasToRefresh = false;

    protected IFigure createFigure() {
        NodeFigure figure = new NodeFigure();
        return figure;
    }

    @Override
    public void propertyChanged(Notification notification) {
        if (notification.getEventType() == 1 && notification.getOldValue() == notification.getNewValue()) {
            return;
        }
        if ((notification.getNotifier() instanceof ObjetMetier || notification.getNotifier() instanceof ZoneDeTexte) && (notification.getEventType() == 3 || notification.getEventType() == 5 || notification.getEventType() == 4 || notification.getEventType() == 6 || notification.getEventType() == 7)) {
            this.refreshChildren();
            this.refreshPolygons();
            EditPart parent = this.getParent();
            while (parent != null) {
                if (parent instanceof NodePart) {
                    ((NodePart)parent).setHasToRefresh(true);
                }
                parent = parent.getParent();
            }
            if (!ObjetMetierPart.waitForRefresh()) {
                this.getRoot().getContents().refresh();
            }
        } else {
            this.refreshVisuals();
        }
    }

    public List<Polygon> getPolygons() {
        if (this.polygons.isEmpty() || this.hasToRefresh) {
            this.refreshPolygons();
        }
        return this.polygons;
    }

    public void refreshPolygons() {
        this.polygons.clear();
        Area area = new Area();
        for (Object ochild : this.getChildren()) {
            if (ochild instanceof NodePart) {
                NodePart child = (NodePart)((Object)ochild);
                List<Polygon> list = child.getPolygons();
                for (Polygon pol : list) {
                    java.awt.Polygon awtpol = new java.awt.Polygon();
                    int i = 0;
                    while (i < pol.getPoints().size()) {
                        int x = pol.getPoints().getPoint((int)i).x;
                        int y = pol.getPoints().getPoint((int)i).y;
                        awtpol.addPoint(x, y);
                        ++i;
                    }
                    area.add(new Area(awtpol));
                    awtpol = null;
                }
                continue;
            }
            Rectangle constraint = null;
            if (ochild instanceof FeuillePart) {
                constraint = ((FeuillePart)((Object)ochild)).getConstraint();
            } else if (ochild instanceof ZoneDeTextePart) {
                constraint = ((ZoneDeTextePart)((Object)ochild)).getConstraint();
            } else if (ochild instanceof FlecheNordPart && ((FlecheNord)((FlecheNordPart)((Object)ochild)).getModel()).isAfficher()) {
                constraint = ((FlecheNordPart)((Object)ochild)).getConstraint();
            }
            if (constraint == null) continue;
            java.awt.Rectangle rectangle = new java.awt.Rectangle(constraint.x, constraint.y, constraint.width, constraint.height);
            area.add(new Area(rectangle));
        }
        PathIterator pathit = area.getPathIterator(null);
        ArrayList segments = new ArrayList();
        ArrayList<Point> current = new ArrayList<Point>();
        while (!pathit.isDone()) {
            double[] dArray = new double[6];
            int val = pathit.currentSegment(dArray);
            if (val != 4) {
                int x = (int)dArray[0];
                int y = (int)dArray[1];
                Point p = new Point(x, y);
                if (val == 0) {
                    current = new ArrayList();
                    segments.add(current);
                }
                current.add(p);
            }
            pathit.next();
        }
        area.reset();
        area = null;
        for (List list : segments) {
            PointList pl = new PointList();
            for (Point p : list) {
                pl.addPoint(p.x, p.y);
            }
            Polygon pol = new Polygon();
            pol.setPoints(pl);
            this.polygons.add(pol);
        }
    }

    public void refresh() {
        this.refreshChildren();
        this.refreshVisuals();
        this.refreshSourceConnections();
        this.refreshTargetConnections();
    }

    public void refreshChildren() {
        super.refreshChildren();
    }

    @Override
    public void refreshVisuals() {
        NodeFigure figure = (NodeFigure)this.getFigure();
        figure.setPolygons(this.getPolygons(), NodePart.getShrinkValue((ObjetMetier)this.getModel()), this.getColor());
        figure.setLabel(this.getLabel());
        figure.setFacteurFont(this.getFacteurFont());
        figure.resetImages();
        if (this.getTexture() != null) {
            GraphicalProperties properties = (GraphicalProperties)this.getViewer().getProperty("graphicalProperties");
            Image texture = new Image((Device)Display.getCurrent(), this.getTexture().getImageData().scaledTo(properties.getLargeurMaille(), properties.getHauteurMaille()));
            for (FeuillePart child : this.getChildrenRec()) {
                Rectangle bounds = new Rectangle(child.getConstraint());
                int top = 0;
                if (!figure.containsPoint(bounds.x + bounds.width / 2, bounds.y)) {
                    top = NodePart.getShrinkValue((ObjetMetier)this.getModel());
                }
                int left = 0;
                if (!figure.containsPoint(bounds.x, bounds.y + bounds.height / 2)) {
                    left = NodePart.getShrinkValue((ObjetMetier)this.getModel());
                }
                int bottom = 0;
                if (!figure.containsPoint(bounds.x + bounds.width / 2, bounds.y + bounds.height)) {
                    bottom = NodePart.getShrinkValue((ObjetMetier)this.getModel());
                }
                int right = 0;
                if (!figure.containsPoint(bounds.x + bounds.width, bounds.y + bounds.height / 2)) {
                    right = NodePart.getShrinkValue((ObjetMetier)this.getModel());
                }
                bounds.crop(new Insets(top, left, bottom, right));
                figure.addImage(texture, child.getConstraint(), bounds);
            }
        }
        this.setVisibility(figure);
        figure.repaint();
        for (Object child : this.getChildren()) {
            if (child instanceof ObjetMetierPart) {
                ((ObjetMetierPart)((Object)child)).refreshVisuals();
                continue;
            }
            if (child instanceof ZoneDeTextePart) {
                ((ZoneDeTextePart)((Object)child)).refreshVisuals();
                continue;
            }
            if (!(child instanceof FlecheNordPart)) continue;
            ((FlecheNordPart)((Object)child)).refreshVisuals();
        }
    }

    public boolean isHasToRefresh() {
        return this.hasToRefresh;
    }

    public void setHasToRefresh(boolean hasToRefresh) {
        this.hasToRefresh = hasToRefresh;
    }

    @Override
    protected ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            this.anchor = new NodeAnchor(this.getFigure());
        }
        return this.anchor;
    }
}

