/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.tools;

import fr.inra.adonis.editeurgraphique.part.AdonisRootEditPart;
import fr.inra.adonis.editeurgraphique.part.NodePart;
import fr.inra.adonis.editeurgraphique.rulers.custom.AdonisRulerComposite;
import fr.inra.adonis.editeurgraphique.rulers.custom.AdonisRulerEditPart;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public final class ExportImageUtil {
    public static byte[] createImageWithRuler(AdonisRootEditPart rootEditPart, AdonisRulerComposite rulerComposite, int format, Device device, List<IFigure> figures, int widthMax, int heightMax) {
        IFigure graphAdonis = figures.get(0);
        if (rootEditPart.getContents() instanceof NodePart) {
            graphAdonis = ((NodePart)rootEditPart.getContents()).getFigure();
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        RootEditPart leftRuleRootPart = rulerComposite.getLeft().getContents().getRoot();
        RootEditPart topRuleRootPart = rulerComposite.getTop().getContents().getRoot();
        AdonisRulerEditPart leftRulePart = (AdonisRulerEditPart)leftRuleRootPart.getContents();
        AdonisRulerEditPart topRulePart = (AdonisRulerEditPart)topRuleRootPart.getContents();
        Dimension ruleLeftDimension = leftRulePart.getFigure().getPreferredSize();
        Dimension ruleTopDimension = topRulePart.getFigure().getPreferredSize();
        Dimension diagramDimension = graphAdonis.getSize();
        Dimension globalDimension = new Dimension(diagramDimension);
        globalDimension = globalDimension.expand(ruleLeftDimension.width * 2, ruleTopDimension.height * 2);
        figures.get(0).getParent().setSize(diagramDimension);
        figures.get(0).getParent().repaint();
        Image image = null;
        GC gc = null;
        SWTGraphics g = null;
        try {
            int width = globalDimension.width;
            int height = globalDimension.height;
            double scale = 1.0;
            if (widthMax > 0 && width > widthMax) {
                scale = (float)widthMax / (float)width;
                width = widthMax;
            }
            if (heightMax > 0 && height > heightMax) {
                double vScale = (float)heightMax / (float)height;
                if (vScale < scale) {
                    scale = vScale;
                }
                height = heightMax;
            }
            image = new Image(device, width, height);
            gc = new GC((Drawable)image);
            g = new SWTGraphics(gc);
            gc.setAntialias(1);
            if (scale < 1.0) {
                g.scale(scale);
            }
            ExportImageUtil.drawToImageWithRuler(rootEditPart, rulerComposite, figures, (Graphics)g);
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{image.getImageData()};
            imageLoader.save((OutputStream)result, format);
            rootEditPart.refresh();
        }
        finally {
            if (g != null) {
                g.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
        return result.toByteArray();
    }

    public static void drawToImageWithRuler(AdonisRootEditPart rootEditPart, AdonisRulerComposite rulerComposite, List<IFigure> figures, Graphics swtGraphics) {
        IFigure graphAdonis = figures.get(0);
        if (rootEditPart.getContents() instanceof NodePart) {
            graphAdonis = ((NodePart)rootEditPart.getContents()).getFigure();
        }
        RootEditPart leftRuleRootPart = rulerComposite.getLeft().getContents().getRoot();
        RootEditPart topRuleRootPart = rulerComposite.getTop().getContents().getRoot();
        AdonisRulerEditPart leftRulePart = (AdonisRulerEditPart)leftRuleRootPart.getContents();
        AdonisRulerEditPart topRulePart = (AdonisRulerEditPart)topRuleRootPart.getContents();
        Dimension ruleLeftDimension = leftRulePart.getFigure().getPreferredSize();
        Dimension ruleTopDimension = topRulePart.getFigure().getPreferredSize();
        Dimension diagramDimension = graphAdonis.getSize();
        figures.get(0).getParent().setSize(diagramDimension);
        figures.get(0).getParent().repaint();
        int dx = -graphAdonis.getBounds().x;
        int dy = -graphAdonis.getBounds().y;
        swtGraphics.translate(dx + ruleLeftDimension.width, dy + ruleTopDimension.height);
        swtGraphics.pushState();
        for (IFigure fig : figures) {
            fig.validate();
            fig.paint(swtGraphics);
            swtGraphics.restoreState();
        }
        swtGraphics.restoreState();
        swtGraphics.translate(0, -dy - ruleTopDimension.height);
        topRulePart.getFigure().paint(swtGraphics);
        swtGraphics.translate(0, graphAdonis.getBounds().height + ruleTopDimension.height);
        topRulePart.getFigure().paint(swtGraphics);
        swtGraphics.restoreState();
        swtGraphics.translate(ruleLeftDimension.width + 2, 0);
        leftRulePart.getFigure().paint(swtGraphics);
        swtGraphics.restoreState();
        swtGraphics.translate(graphAdonis.getBounds().width + 2, 0);
        leftRulePart.getFigure().paint(swtGraphics);
        swtGraphics.popState();
        rootEditPart.refresh();
    }

    private ExportImageUtil() {
    }
}

