/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.tools;

import fr.inra.adonis.core.parcours.ParcoursUtil;
import fr.inra.adonis.core.util.ColorUtil;
import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.core.util.FormatUtil;
import fr.inra.adonis.core.util.MesureUtil;
import fr.inra.adonis.editeurgraphique.EditorModeEnum;
import fr.inra.adonis.editeurgraphique.VisualisationGraphiqueVariable;
import fr.inra.adonis.editeurgraphique.rulers.AdonisRuler;
import fr.inra.adonis.editeurgraphique.rulers.AdonisRulerProvider;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.graphique.ConfigurationGraphique;
import fr.inra.adonis.modeleMetier.graphique.Labels;
import fr.inra.adonis.modeleMetier.graphique.Origine;
import fr.inra.adonis.modeleMetier.graphique.StructureGraphique;
import fr.inra.adonis.modeleMetier.plateforme.Anomalie;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.plateforme.PuIndividuel;
import fr.inra.adonis.modeleMetier.plateforme.PuSurfacique;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.TypeAnomalie;
import fr.inra.adonis.modeleMetier.plateforme.ZheAvecEpaisseur;
import fr.inra.adonis.modeleMetier.protocole.Modalite;
import fr.inra.adonis.modeleMetier.protocole.Traitement;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariable;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariableAlphanumerique;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariableBooleen;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariableDate;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariableEntiere;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariableHeure;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariableReel;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class GraphicalProperties {
    public static final int DELTA_IND = 12;
    public static final int DELTA_PU = 10;
    public static final int DELTA_SOUS_BLOC = 8;
    public static final int DELTA_BLOC = 6;
    public static final int DELTA_DISP = 2;
    private final StructureGraphique structure;
    private final ConfigurationGraphique configuration;
    private final AdonisRulerProvider horizontalRulerProvider;
    private final AdonisRulerProvider verticalRulerProvider;
    private final EditorModeEnum editorMode;
    private int facteurFont = 0;

    public GraphicalProperties(EditorModeEnum mode, StructureGraphique sg, ConfigurationGraphique cg) {
        this.structure = sg;
        this.configuration = cg;
        this.horizontalRulerProvider = new AdonisRulerProvider(new AdonisRuler(true), this.getLargeurMaille());
        this.verticalRulerProvider = new AdonisRulerProvider(new AdonisRuler(false), this.getHauteurMaille());
        this.editorMode = mode;
    }

    public AdonisRulerProvider getHorizontalRulerProvider() {
        return this.horizontalRulerProvider;
    }

    public AdonisRulerProvider getVerticalRulerProvider() {
        return this.verticalRulerProvider;
    }

    public Anomalie getAnomalie(ObjetMetier obj) {
        Dispositif disp = (Dispositif)DispositifUtil.getParent((ObjetMetier)obj, Dispositif.class);
        if (disp != null) {
            for (Anomalie ano : disp.getAnomalies()) {
                if (ano.getObjetMetier() != obj) continue;
                return ano;
            }
        }
        return null;
    }

    public Origine getOrigine() {
        return this.structure.getOrigine();
    }

    public int getCoeffX() {
        int coeffX = 1;
        switch (this.getOrigine()) {
            case HAUT_DROITE: {
                coeffX = -1;
                break;
            }
            case BAS_DROITE: {
                coeffX = -1;
                break;
            }
        }
        return coeffX;
    }

    public int getCoeffY() {
        int coeffY = 1;
        switch (this.getOrigine()) {
            case BAS_GAUCHE: {
                coeffY = -1;
                break;
            }
            case BAS_DROITE: {
                coeffY = -1;
                break;
            }
        }
        return coeffY;
    }

    public int getHauteurMaille() {
        return this.structure.getHauteurMaille();
    }

    public int getLargeurMaille() {
        return this.structure.getLargeurMaille();
    }

    public boolean isTooltipsActive() {
        return this.configuration.isTooltipActive();
    }

    public String getPlateformeLabel(Plateforme pf) {
        return pf.getNom();
    }

    public String getDispositifLabel(Dispositif d) {
        String result = "";
        if (this.editorMode == EditorModeEnum.VISUALISATION_VARIABLE) {
            List<MesureVariable> mesures = VisualisationGraphiqueVariable.getMesuresForObject((ObjetMetier)d);
            return this.getMesuresLabel(mesures);
        }
        for (Labels l : this.configuration.getLabelsDispo()) {
            if (!result.isEmpty()) {
                result = String.valueOf(result) + " ; ";
            }
            switch (l) {
                case DISPO_NOM: {
                    result = String.valueOf(result) + d.getNom();
                    break;
                }
                case DISPO_ETAT: {
                    result = String.valueOf(result) + d.getEtat();
                    break;
                }
                case DISPO_NB_BLOCS: {
                    result = String.valueOf(result) + d.getBlocs().size() + " bloc(s)";
                    break;
                }
            }
        }
        return result;
    }

    public String getDispositifTooltip(Dispositif d) {
        if (this.editorMode == EditorModeEnum.VISUALISATION_VARIABLE) {
            StringBuffer sb = new StringBuffer();
            sb.append(d.getNom());
            return sb.toString();
        }
        return this.getDispositifLabel(d);
    }

    public String getBlocLabel(Bloc b) {
        String result = "";
        if (this.editorMode == EditorModeEnum.VISUALISATION_VARIABLE) {
            List<MesureVariable> mesures = VisualisationGraphiqueVariable.getMesuresForObject((ObjetMetier)b);
            return this.getMesuresLabel(mesures);
        }
        for (Labels l : this.configuration.getLabelsBloc()) {
            if (!result.isEmpty()) {
                result = String.valueOf(result) + " ; ";
            }
            switch (l) {
                case DISPO_NOM: {
                    result = String.valueOf(result) + b.getDispositif().getNom();
                    break;
                }
                case BLOC_NUM: {
                    result = String.valueOf(result) + b.getNumero();
                    break;
                }
                case BLOC_NB_PU: {
                    result = String.valueOf(result) + this.getNbPU(b) + " PU";
                    break;
                }
            }
        }
        return result;
    }

    private int getNbPU(Bloc b) {
        int nb = 0;
        nb = b.getParcellesUnitaire().size();
        for (SousBloc sb : b.getSousBlocs()) {
            nb += sb.getParcellesUnitaire().size();
        }
        return nb;
    }

    public String getBlocTooltip(Bloc b) {
        if (this.editorMode == EditorModeEnum.VISUALISATION_VARIABLE) {
            StringBuffer sb = new StringBuffer();
            sb.append(b.getNumero());
            return sb.toString();
        }
        return this.getBlocLabel(b);
    }

    public String getSousBlocLabel(SousBloc sb) {
        String result = "";
        if (this.editorMode == EditorModeEnum.VISUALISATION_VARIABLE) {
            List<MesureVariable> mesures = VisualisationGraphiqueVariable.getMesuresForObject((ObjetMetier)sb);
            return this.getMesuresLabel(mesures);
        }
        for (Labels l : this.configuration.getLabelsSousBloc()) {
            if (!result.isEmpty()) {
                result = String.valueOf(result) + " ; ";
            }
            switch (l) {
                case BLOC_NUM: {
                    result = String.valueOf(result) + sb.getBloc().getNumero();
                    break;
                }
                case SOUSBLOC_NUM: {
                    result = String.valueOf(result) + sb.getNumero();
                    break;
                }
                case BLOC_NB_PU: {
                    result = String.valueOf(result) + sb.getParcellesUnitaire().size() + " PU";
                    break;
                }
            }
        }
        return result;
    }

    public String getSousBlocTooltip(SousBloc sb) {
        if (this.editorMode == EditorModeEnum.VISUALISATION_VARIABLE) {
            StringBuffer strb = new StringBuffer();
            strb.append(sb.getNumero());
            return strb.toString();
        }
        return this.getSousBlocLabel(sb);
    }

    private String getModaliteLabel(Traitement t, int i) {
        if (t != null && t.getCombinaisons().size() > i) {
            return ((Modalite)t.getCombinaisons().get(i)).getValeur();
        }
        return "";
    }

    public String getParcelleLabel(ParcelleUnitaire p) {
        String result = "";
        if (this.editorMode == EditorModeEnum.VISUALISATION_VARIABLE) {
            List<MesureVariable> mesures = VisualisationGraphiqueVariable.getMesuresForObject((ObjetMetier)p);
            return this.getMesuresLabel(mesures);
        }
        result = this.getAnomalieLabel((ObjetMetier)p);
        if (!result.isEmpty()) {
            return result;
        }
        if (result.length() == 0 && DispositifUtil.estMort((ObjetMetier)p)) {
            result = "M";
        }
        if (result.length() == 0) {
            EList labelsList = null;
            labelsList = p instanceof PuIndividuel ? this.configuration.getLabelsPuIndividuel() : this.configuration.getLabelsPuSurfacique();
            Bloc b = (Bloc)DispositifUtil.getParent((ObjetMetier)p, Bloc.class);
            SousBloc sb = (SousBloc)DispositifUtil.getParent((ObjetMetier)p, SousBloc.class);
            block14: for (Labels l : labelsList) {
                if (!result.isEmpty()) {
                    result = String.valueOf(result) + " ; ";
                }
                switch (l) {
                    case BLOC_NUM: {
                        result = String.valueOf(result) + b.getNumero();
                        break;
                    }
                    case SOUSBLOC_NUM: {
                        if (sb == null) break;
                        result = String.valueOf(result) + sb.getNumero();
                        break;
                    }
                    case PU_NUM: {
                        result = String.valueOf(result) + p.getNumero();
                        break;
                    }
                    case PU_TRAITEMENT: {
                        if (p.getTraitement() == null) break;
                        result = String.valueOf(result) + p.getTraitement().getNom();
                        break;
                    }
                    case PU_TRAIT_COURT: {
                        if (p.getTraitement() == null) break;
                        result = String.valueOf(result) + p.getTraitement().getNomCourt();
                        break;
                    }
                    case PU_FACT1: {
                        result = String.valueOf(result) + this.getModaliteLabel(p.getTraitement(), 0);
                        break;
                    }
                    case PU_FACT2: {
                        result = String.valueOf(result) + this.getModaliteLabel(p.getTraitement(), 1);
                        break;
                    }
                    case PU_FACT3: {
                        result = String.valueOf(result) + this.getModaliteLabel(p.getTraitement(), 2);
                        break;
                    }
                    case PU_NB_IND: {
                        result = String.valueOf(result) + ((PuIndividuel)p).getIndividus().size() + " individus";
                        break;
                    }
                    case IND_X: {
                        result = String.valueOf(result) + p.getX();
                        break;
                    }
                    case IND_Y: {
                        result = String.valueOf(result) + p.getY();
                        break;
                    }
                    case PU_CODE_ID: {
                        PuSurfacique puSurf;
                        if (!(p instanceof PuSurfacique) || (puSurf = (PuSurfacique)p).getIdRfidCodeBarre() == null || puSurf.getIdRfidCodeBarre().isEmpty()) continue block14;
                        result = String.valueOf(result) + puSurf.getIdRfidCodeBarre();
                        break;
                    }
                }
            }
        }
        return result;
    }

    public String getParcelleTooltip(ParcelleUnitaire p) {
        if (this.editorMode == EditorModeEnum.VISUALISATION_VARIABLE) {
            StringBuffer sb = new StringBuffer();
            sb.append(p.getNumero());
            sb.append(p.getNumero());
            sb.append("-");
            if (p.getTraitement() != null) {
                sb.append(p.getTraitement().getNom());
            }
            sb.append("-");
            ObjetMetier blocParent = ParcoursUtil.getParent((ObjetMetier)p);
            if (blocParent instanceof SousBloc) {
                sb.append("Bloc " + ((SousBloc)blocParent).getBloc().getNumero());
            } else if (blocParent instanceof Bloc) {
                sb.append("Bloc " + blocParent.getNumero());
            }
            return sb.toString();
        }
        return this.getParcelleLabel(p);
    }

    public String getIndividuLabel(Individu ind) {
        String result = "";
        if (this.editorMode == EditorModeEnum.VISUALISATION_VARIABLE) {
            List<MesureVariable> mesures = VisualisationGraphiqueVariable.getMesuresForObject((ObjetMetier)ind);
            return this.getMesuresLabel(mesures);
        }
        result = this.getAnomalieLabel((ObjetMetier)ind);
        if (result.length() == 0 && DispositifUtil.estMort((ObjetMetier)ind)) {
            result = "M";
        }
        if (result.length() == 0) {
            Bloc b = (Bloc)DispositifUtil.getParent((ObjetMetier)ind, Bloc.class);
            SousBloc sb = (SousBloc)DispositifUtil.getParent((ObjetMetier)ind, SousBloc.class);
            block11: for (Labels l : this.configuration.getLabelsIndividu()) {
                if (!result.isEmpty()) {
                    result = String.valueOf(result) + " ; ";
                }
                switch (l) {
                    case IND_NUM: {
                        result = String.valueOf(result) + ind.getNumero();
                        break;
                    }
                    case IND_X: {
                        result = String.valueOf(result) + ind.getX();
                        break;
                    }
                    case IND_Y: {
                        result = String.valueOf(result) + ind.getY();
                        break;
                    }
                    case PU_NUM: {
                        result = String.valueOf(result) + ind.getParcelleUnitaire().getNumero();
                        break;
                    }
                    case PU_TRAITEMENT: {
                        if (ind.getParcelleUnitaire().getTraitement() == null) break;
                        result = String.valueOf(result) + ind.getParcelleUnitaire().getTraitement().getNom();
                        break;
                    }
                    case PU_TRAIT_COURT: {
                        if (ind.getParcelleUnitaire().getTraitement() == null) break;
                        result = String.valueOf(result) + ind.getParcelleUnitaire().getTraitement().getNomCourt();
                        break;
                    }
                    case IND_BLOC: {
                        result = String.valueOf(result) + b.getNumero();
                        break;
                    }
                    case IND_SOUS_BLOC: {
                        if (sb == null) break;
                        result = String.valueOf(result) + sb.getNumero();
                        break;
                    }
                    case IND_CODE_ID: {
                        if (ind.getIdRfidCodeBarre() == null || ind.getIdRfidCodeBarre().isEmpty()) continue block11;
                        result = String.valueOf(result) + ind.getIdRfidCodeBarre();
                        break;
                    }
                }
            }
        }
        return result;
    }

    private String getAnomalieLabel(ObjetMetier objetMetier) {
        Dispositif disp = DispositifUtil.getDispositifFrom((EObject)objetMetier);
        if (disp != null) {
            for (Anomalie ano : disp.getAnomalies()) {
                if (ano.getObjetMetier() == objetMetier && ano.getTypeAnomalie() == TypeAnomalie.INDIVIDU_MANQUANT) {
                    return "M";
                }
                if (ano.getObjetMetier() != objetMetier || ano.getTypeAnomalie() != TypeAnomalie.INDIVIDU_MAUVAIS_TRAITEMENT) continue;
                return "T";
            }
        }
        return "";
    }

    public String getIndividuTooltip(Individu ind) {
        if (this.editorMode == EditorModeEnum.VISUALISATION_VARIABLE) {
            ObjetMetier blocParent;
            StringBuffer sb = new StringBuffer();
            sb.append(ind.getNumero());
            sb.append("-");
            if (ind.getParcelleUnitaire().getTraitement() != null) {
                sb.append(ind.getParcelleUnitaire().getTraitement().getNom());
                sb.append("-");
            }
            if ((blocParent = ParcoursUtil.getParent((ObjetMetier)ParcoursUtil.getParent((ObjetMetier)ind))) instanceof SousBloc) {
                sb.append("Bloc " + ((SousBloc)blocParent).getBloc().getNumero());
            } else if (blocParent instanceof Bloc) {
                sb.append("Bloc " + blocParent.getNumero());
            }
            return sb.toString();
        }
        return this.getIndividuLabel(ind);
    }

    public String getZheLabel(ZheAvecEpaisseur zhe) {
        return "";
    }

    private String getMesuresLabel(List<MesureVariable> mesures) {
        if (mesures == null) {
            return "";
        }
        if (mesures.size() == 0) {
            return "";
        }
        StringBuffer labelIndividu = new StringBuffer();
        for (MesureVariable mesure : mesures) {
            if (labelIndividu.length() > 0) {
                labelIndividu.append(";");
            }
            if (mesure.getCodeEtat() != null) {
                labelIndividu.append(mesure.getCodeEtat().getCode());
                continue;
            }
            if (mesure instanceof MesureVariableEntiere) {
                labelIndividu.append(Integer.toString(((MesureVariableEntiere)mesure).getValeur()));
                continue;
            }
            if (mesure instanceof MesureVariableAlphanumerique) {
                labelIndividu.append(((MesureVariableAlphanumerique)mesure).getValeur());
                continue;
            }
            if (mesure instanceof MesureVariableBooleen) {
                if (((MesureVariableBooleen)mesure).isValeur()) {
                    labelIndividu.append("1");
                    continue;
                }
                labelIndividu.append("0");
                continue;
            }
            if (mesure instanceof MesureVariableDate) {
                labelIndividu.append(MesureUtil.getValeurMesureStr((MesureVariable)mesure));
                continue;
            }
            if (mesure instanceof MesureVariableHeure) {
                labelIndividu.append(FormatUtil.getSimpleHeureFormat().format(((MesureVariableDate)mesure).getValeur()));
                continue;
            }
            if (mesure instanceof MesureVariableReel) {
                labelIndividu.append(Double.toString(((MesureVariableReel)mesure).getValeur()));
                continue;
            }
            return "";
        }
        return labelIndividu.toString();
    }

    public Color getObjetMetierBackgroundColor(ObjetMetier objet) {
        Anomalie ano;
        List<MesureVariable> mesures;
        if (this.editorMode == EditorModeEnum.VISUALISATION_VARIABLE && (mesures = VisualisationGraphiqueVariable.getMesuresForObject(objet)) != null) {
            for (MesureVariable mesure : mesures) {
                if (mesure.getCodeEtat() == null) continue;
                return ColorUtil.getColor((String)mesure.getCodeEtat().getCouleur());
            }
        }
        Color c = null;
        if (objet.getCodeEtat() != null && this.editorMode != EditorModeEnum.VISUALISATION_VARIABLE) {
            c = ColorUtil.getColor((String)objet.getCodeEtat().getCouleur());
        }
        if (c == null && (ano = this.getAnomalie(objet)) != null) {
            ParcelleUnitaire pu;
            c = objet instanceof ParcelleUnitaire ? ((pu = (ParcelleUnitaire)objet).getTraitement() != null && pu.getTraitement().getNom().equalsIgnoreCase("Traitement Inconnu") ? ColorUtil.getColor((String)"RGB {255, 255, 255}") : ColorUtil.getColor((String)this.configuration.getCouleurPuAnomalie())) : ColorUtil.getColor((String)this.configuration.getCouleurIndAnomalie());
        }
        if (c == null && objet.getCouleur() != null) {
            c = ColorUtil.getColor((String)objet.getCouleur());
        }
        if (c == null) {
            c = this.getDefaultBackgroundColor(objet);
        }
        return c;
    }

    private Color getDefaultBackgroundColor(ObjetMetier objet) {
        Object c = ColorConstants.orange;
        if (objet instanceof ZheAvecEpaisseur) {
            ZheAvecEpaisseur zhe = (ZheAvecEpaisseur)objet;
            c = zhe.getNatureZhe() != null ? ColorUtil.getColor((String)zhe.getNatureZhe().getCouleur()) : ColorConstants.red;
        } else if (objet instanceof Individu) {
            c = ((Individu)objet).isMailleVide() ? ColorUtil.getColor((String)this.configuration.getCouleurMailleVide()) : null;
            if (c == null) {
                c = ColorUtil.getColor((String)this.configuration.getCouleurIndividu());
            }
        } else if (objet instanceof PuIndividuel) {
            c = ColorUtil.getColor((String)this.configuration.getCouleurPuIndividuel());
            if (c == null) {
                c = ColorConstants.darkGreen;
            }
        } else if (objet instanceof Plateforme) {
            c = ColorUtil.getColor((String)this.configuration.getCouleurPlateforme());
            if (c == null) {
                c = ColorConstants.white;
            }
        } else if (objet instanceof Dispositif) {
            c = ColorUtil.getColor((String)this.configuration.getCouleurDispositif());
            if (c == null) {
                c = ColorConstants.green;
            }
        } else if (objet instanceof Bloc) {
            c = ColorUtil.getColor((String)this.configuration.getCouleurBloc());
            if (c == null) {
                c = ColorConstants.blue;
            }
        } else if (objet instanceof SousBloc) {
            c = ColorUtil.getColor((String)this.configuration.getCouleurSousBloc());
            if (c == null) {
                c = ColorConstants.cyan;
            }
        } else if (objet instanceof PuSurfacique && (c = ColorUtil.getColor((String)this.configuration.getCouleurPuSurfacique())) == null) {
            c = ColorConstants.darkGreen;
        }
        return c;
    }

    public Image getPlateformeTexture(Plateforme pf) {
        if (pf.getTexture() != null) {
            return ColorUtil.getTexture((String)pf.getTexture());
        }
        return ColorUtil.getTexture((String)this.configuration.getTexturePlateforme());
    }

    public Image getDispositifTexture(Dispositif d) {
        if (d.getTexture() != null) {
            return ColorUtil.getTexture((String)d.getTexture());
        }
        return ColorUtil.getTexture((String)this.configuration.getTextureDispositif());
    }

    public Image getBlocTexture(Bloc b) {
        if (b.getTexture() != null) {
            return ColorUtil.getTexture((String)b.getTexture());
        }
        return ColorUtil.getTexture((String)this.configuration.getTextureBloc());
    }

    public Image getSousBlocTexture(SousBloc sb) {
        if (sb.getTexture() != null) {
            return ColorUtil.getTexture((String)sb.getTexture());
        }
        return ColorUtil.getTexture((String)this.configuration.getTextureSousBloc());
    }

    public Image getParcelleTexture(ParcelleUnitaire p) {
        Anomalie ano = this.getAnomalie((ObjetMetier)p);
        if (ano != null) {
            Image img = ColorUtil.getTexture((String)this.configuration.getTexturePuAnomalie());
            if (img == null && ano.getTypeAnomalie() == TypeAnomalie.INDIVIDU_NON_CONTROLE) {
                return ColorUtil.getTexture((String)"texture3");
            }
            return img;
        }
        if (p.getTexture() != null) {
            return ColorUtil.getTexture((String)p.getTexture());
        }
        if (p instanceof PuSurfacique) {
            return ColorUtil.getTexture((String)this.configuration.getTexturePuSurfacique());
        }
        if (p instanceof PuIndividuel) {
            return ColorUtil.getTexture((String)this.configuration.getTexturePuIndividuel());
        }
        return null;
    }

    public Image getIndividuTexture(Individu ind) {
        Anomalie ano = this.getAnomalie((ObjetMetier)ind);
        if (ind.isMailleVide()) {
            return ColorUtil.getTexture((String)this.configuration.getTextureMailleVide());
        }
        if (ano != null) {
            Image img = ColorUtil.getTexture((String)this.configuration.getTextureIndAnomalie());
            if (img == null && ano.getTypeAnomalie() == TypeAnomalie.INDIVIDU_NON_CONTROLE) {
                return ColorUtil.getTexture((String)"texture3");
            }
            return img;
        }
        if (ind.getTexture() != null) {
            return ColorUtil.getTexture((String)ind.getTexture());
        }
        return ColorUtil.getTexture((String)this.configuration.getTextureIndividu());
    }

    public int getFacteurFont() {
        return this.facteurFont;
    }

    public void setFacteurFont(int facteurFont) {
        this.facteurFont = facteurFont;
    }

    public StructureGraphique getStructureGraphique() {
        return this.structure;
    }

    public ConfigurationGraphique getConfigurationGraphique() {
        return this.configuration;
    }
}

