/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.wizard;

import fr.inra.adonis.core.rcp.AdonisLabelProvider;
import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.graphique.GraphiqueFactory;
import fr.inra.adonis.modeleMetier.graphique.Origine;
import fr.inra.adonis.modeleMetier.graphique.StructureGraphique;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.plateforme.UniteDeParcours;
import fr.inra.adonis.persistance.AbstractDAOFactory;
import fr.inra.adonis.persistance.SiteDAO;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class PlateformeStructureGraphiqueDialog
extends TitleAreaDialog {
    private final SiteDAO site = AbstractDAOFactory.getInstance().getSiteDAO();
    private ComboViewer pfDispoComboViewer;
    private ComboViewer origineComboViewer;
    private Spinner hauteurMailleSpn;
    private Spinner largeurMailleSpn;
    private boolean modelChanged;
    private final UniteDeParcours plateformeOuDispoSelection;

    public PlateformeStructureGraphiqueDialog(Shell parentShell, UniteDeParcours plateformeOuDispo) {
        super(parentShell);
        this.plateformeOuDispoSelection = plateformeOuDispo;
        this.setShellStyle(2160);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Positionnement origine");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Positionnement origine ");
        this.setMessage("Choisissez le positionnement de l'origine et la taille de la maille...", 1);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(600, 600);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite repereComposite = new Composite(composite, 0);
        GridData gd_repereComposite = new GridData(4, 4, false, false, 1, 1);
        gd_repereComposite.heightHint = 254;
        repereComposite.setLayoutData((Object)gd_repereComposite);
        GridLayout gl_repereComposite = new GridLayout(4, false);
        gl_repereComposite.marginBottom = 10;
        gl_repereComposite.marginRight = 10;
        gl_repereComposite.marginLeft = 10;
        gl_repereComposite.marginTop = 10;
        gl_repereComposite.verticalSpacing = 10;
        repereComposite.setLayout((Layout)gl_repereComposite);
        Label lblPlateformeOuDispositif = new Label(repereComposite, 0);
        lblPlateformeOuDispositif.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPlateformeOuDispositif.setText("Plateforme ou dispositif : ");
        this.pfDispoComboViewer = new ComboViewer(repereComposite, 0);
        this.pfDispoComboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.pfDispoComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.pfDispoComboViewer.setLabelProvider((IBaseLabelProvider)AdonisLabelProvider.getInstance());
        Label origineLbl = new Label(repereComposite, 0);
        origineLbl.setText("Position de l'origine : ");
        this.origineComboViewer = new ComboViewer(repereComposite, 0);
        Combo combo = this.origineComboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.origineComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.origineComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Origine) {
                    switch ((Origine)element) {
                        case BAS_DROITE: {
                            return "Bas Droite";
                        }
                        case BAS_GAUCHE: {
                            return "Bas Gauche";
                        }
                        case HAUT_DROITE: {
                            return "Haut Droite";
                        }
                        case HAUT_GAUCHE: {
                            return "Haut Gauche";
                        }
                    }
                }
                return super.getText(element);
            }
        });
        Label hauteurMailleLbl = new Label(repereComposite, 0);
        hauteurMailleLbl.setText("Hauteur de maille : ");
        this.hauteurMailleSpn = new Spinner(repereComposite, 2048);
        this.hauteurMailleSpn.setMinimum(30);
        Label largeurMailleLbl = new Label(repereComposite, 0);
        GridData gd_largeurMailleLbl = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_largeurMailleLbl.horizontalIndent = 50;
        largeurMailleLbl.setLayoutData((Object)gd_largeurMailleLbl);
        largeurMailleLbl.setText("Largeur de maille : ");
        this.largeurMailleSpn = new Spinner(repereComposite, 2048);
        this.hauteurMailleSpn.setMinimum(30);
        this.addListeners();
        this.initialize();
        return composite;
    }

    private void addListeners() {
        this.pfDispoComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)PlateformeStructureGraphiqueDialog.this.pfDispoComboViewer.getSelection();
                if (selection.getFirstElement() instanceof ObjetMetier) {
                    ObjetMetier obj = (ObjetMetier)selection.getFirstElement();
                    StructureGraphique structureGraphique = obj.getStructureGraphique();
                    if (structureGraphique == null) {
                        structureGraphique = GraphiqueFactory.eINSTANCE.createStructureGraphique();
                        structureGraphique.setOrigine(Origine.HAUT_GAUCHE);
                        structureGraphique.setHauteurMaille(50);
                        structureGraphique.setLargeurMaille(50);
                        structureGraphique.setObjetMetier(obj);
                    }
                    PlateformeStructureGraphiqueDialog.this.origineComboViewer.setSelection((ISelection)new StructuredSelection((Object)structureGraphique.getOrigine()));
                    PlateformeStructureGraphiqueDialog.this.hauteurMailleSpn.setSelection(structureGraphique.getHauteurMaille());
                    PlateformeStructureGraphiqueDialog.this.largeurMailleSpn.setSelection(structureGraphique.getLargeurMaille());
                }
            }
        });
    }

    private void initialize() {
        ArrayList objets = new ArrayList();
        SiteDAO.remplirListe((Iterable)this.site.getPlateformeDAO().getPlateformes(), objets);
        SiteDAO.remplirListe((Iterable)this.site.getPlateformeDAO().getDispositifNonAffectes(), objets);
        this.pfDispoComboViewer.setInput((Object)objets.toArray());
        this.origineComboViewer.setInput((Object)new Object[]{Origine.BAS_GAUCHE, Origine.HAUT_GAUCHE, Origine.BAS_DROITE, Origine.HAUT_DROITE});
        if (this.plateformeOuDispoSelection != null) {
            this.pfDispoComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.plateformeOuDispoSelection));
        }
    }

    protected void okPressed() {
        block3: {
            int largeur;
            int hauteur;
            Origine newOrigine;
            StructureGraphique structureGraphique;
            block5: {
                block4: {
                    StructuredSelection selection = (StructuredSelection)this.pfDispoComboViewer.getSelection();
                    if (!(selection.getFirstElement() instanceof ObjetMetier)) break block3;
                    structureGraphique = ((ObjetMetier)selection.getFirstElement()).getStructureGraphique();
                    newOrigine = (Origine)((StructuredSelection)this.origineComboViewer.getSelection()).getFirstElement();
                    hauteur = this.hauteurMailleSpn.getSelection();
                    largeur = this.largeurMailleSpn.getSelection();
                    if (hauteur == structureGraphique.getHauteurMaille() && largeur == structureGraphique.getLargeurMaille() && newOrigine == structureGraphique.getOrigine()) break block3;
                    this.modelChanged = true;
                    if (!(this.plateformeOuDispoSelection instanceof Dispositif)) break block4;
                    Dispositif dispositif = (Dispositif)this.plateformeOuDispoSelection;
                    if (!DispositifUtil.estVerrouille((Dispositif)dispositif)) break block5;
                    this.modelChanged = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Attention", (String)"Ce dispositif est verrouill\u00e9, confirmez vous ces modifications ?");
                    break block5;
                }
                if (this.plateformeOuDispoSelection instanceof Plateforme) {
                    Plateforme plat = (Plateforme)this.plateformeOuDispoSelection;
                    for (Dispositif dispositif : plat.getDispositifs()) {
                        if (!DispositifUtil.estVerrouille((Dispositif)dispositif)) continue;
                        this.modelChanged = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Attention", (String)"Certains dispositifs de la plateforme sont verrouill\u00e9s, confirmez vous ces modifications ?");
                        break;
                    }
                }
            }
            if (this.modelChanged) {
                structureGraphique.setOrigine(newOrigine);
                structureGraphique.setHauteurMaille(hauteur);
                structureGraphique.setLargeurMaille(largeur);
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Rafraichissement de la visualisation graphique", (String)"Pour prendre en compte les modifications, l'outil graphique va \u00eatre rafraichit.");
            }
        }
        super.okPressed();
    }

    public boolean isModelChanged() {
        return this.modelChanged;
    }
}

