/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.wizard;

import fr.inra.adonis.core.util.ColorUtil;
import fr.inra.adonis.modeleMetier.graphique.ZoneDeTexte;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ZoneDeTexteEditDialog
extends TitleAreaDialog {
    private ZoneDeTexte zoneDeTexte;
    private Color bgColor;
    private Button bgColorBtn;
    private Color fgColor;
    private Button fontBtn;
    private Text dataTxt;

    public ZoneDeTexteEditDialog(Shell parentShell, ZoneDeTexte zdt) {
        super(parentShell);
        this.zoneDeTexte = zdt;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Zone de texte");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Edition de la zone de texte");
        this.setMessage("Choisissez la couleur, le fond et le contenu de cette zone de texte.", 1);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(600, 335);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginTop = 20;
        gridLayout.marginBottom = 20;
        gridLayout.marginLeft = 20;
        gridLayout.marginRight = 20;
        container.setLayout((Layout)gridLayout);
        this.bgColorBtn = new Button(container, 0);
        GridData gd_bgColorBtn = new GridData(4, 4, false, false, 1, 1);
        gd_bgColorBtn.heightHint = 28;
        this.bgColorBtn.setLayoutData((Object)gd_bgColorBtn);
        this.bgColorBtn.setText("Modifier la couleur de fond");
        this.fontBtn = new Button(container, 0);
        this.fontBtn.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.fontBtn.setText("Modifier la police");
        this.dataTxt = new Text(container, 2626);
        this.dataTxt.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.addListeners();
        this.initialize();
        return container;
    }

    private void addListeners() {
        this.bgColorBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog dlg = new ColorDialog(ZoneDeTexteEditDialog.this.getShell());
                dlg.setRGB(ZoneDeTexteEditDialog.this.dataTxt.getBackground().getRGB());
                dlg.setText("Choix de la couleur de fond");
                RGB rgb = dlg.open();
                if (rgb != null) {
                    ZoneDeTexteEditDialog.this.bgColor.dispose();
                    ZoneDeTexteEditDialog.this.bgColor = new Color((Device)ZoneDeTexteEditDialog.this.getShell().getDisplay(), rgb);
                    ZoneDeTexteEditDialog.this.dataTxt.setBackground(ZoneDeTexteEditDialog.this.bgColor);
                }
            }
        });
        this.fontBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog dlg = new FontDialog(ZoneDeTexteEditDialog.this.getShell(), 0);
                dlg.setText("Choix de la police");
                dlg.setFontList(ZoneDeTexteEditDialog.this.dataTxt.getFont().getFontData());
                dlg.setRGB(ZoneDeTexteEditDialog.this.dataTxt.getForeground().getRGB());
                FontData newFont = dlg.open();
                if (newFont != null) {
                    ZoneDeTexteEditDialog.this.dataTxt.setFont(new Font((Device)ZoneDeTexteEditDialog.this.getShell().getDisplay(), newFont));
                    ZoneDeTexteEditDialog.this.fgColor.dispose();
                    ZoneDeTexteEditDialog.this.fgColor = new Color((Device)ZoneDeTexteEditDialog.this.getShell().getDisplay(), dlg.getRGB());
                    ZoneDeTexteEditDialog.this.dataTxt.setForeground(ZoneDeTexteEditDialog.this.fgColor);
                }
            }
        });
    }

    private void initialize() {
        this.bgColor = ColorUtil.getColor((String)this.zoneDeTexte.getCouleurFond());
        this.dataTxt.setBackground(this.bgColor);
        this.fgColor = ColorUtil.getColor((String)this.zoneDeTexte.getCouleurTexte());
        this.dataTxt.setForeground(this.fgColor);
        Font f = new Font((Device)Display.getCurrent(), this.zoneDeTexte.getPolice(), this.zoneDeTexte.getTailleTexte(), this.zoneDeTexte.getStyleTexte());
        this.dataTxt.setFont(f);
        this.dataTxt.setText(this.zoneDeTexte.getTexte());
    }

    protected void okPressed() {
        this.zoneDeTexte.setCouleurFond(this.dataTxt.getBackground().getRGB().toString());
        this.zoneDeTexte.setCouleurTexte(this.dataTxt.getForeground().getRGB().toString());
        FontData fd = this.dataTxt.getFont().getFontData()[0];
        this.zoneDeTexte.setPolice(fd.getName());
        this.zoneDeTexte.setTailleTexte(fd.getHeight());
        this.zoneDeTexte.setStyleTexte(fd.getStyle());
        this.zoneDeTexte.setTexte(this.dataTxt.getText());
        super.okPressed();
    }
}

