/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.wizard.filtres;

import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.icons.IconsRegistry;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Anomalie;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.PuSurfacique;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ObjetMetierColumnLabelProvider
extends ColumnLabelProvider {
    static final Image MORT = IconsRegistry.IMG_DOWN;
    static final Image MAILLEVIDE = IconsRegistry.IMG_DESACTIVATE_USER;
    protected final String columnName;
    protected final int columnIndex;

    public ObjetMetierColumnLabelProvider(String name, int index) {
        this.columnName = name;
        this.columnIndex = index;
    }

    public Object getValue(Object element) {
        if (element instanceof ObjetMetier) {
            ObjetMetier objetMetier = (ObjetMetier)element;
            ParcelleUnitaire pu = (ParcelleUnitaire)DispositifUtil.getParent((ObjetMetier)objetMetier, ParcelleUnitaire.class);
            if (pu != null) {
                if ("Traitement (long)".equals(this.columnName)) {
                    if (pu.getTraitement() != null) {
                        return pu.getTraitement().getNom();
                    }
                    return "";
                }
                if ("Traitement (court)".equals(this.columnName)) {
                    if (pu.getTraitement() != null) {
                        return pu.getTraitement().getNomCourt();
                    }
                    return "";
                }
            }
            if ("X".equals(this.columnName)) {
                return objetMetier.getX();
            }
            if ("Y".equals(this.columnName)) {
                return objetMetier.getY();
            }
            if ("Mort".equals(this.columnName)) {
                if (DispositifUtil.estMort((ObjetMetier)objetMetier)) {
                    return "oui";
                }
                return "non";
            }
            if ("Anomalie".equals(this.columnName)) {
                Dispositif disp = (Dispositif)DispositifUtil.getParent((ObjetMetier)objetMetier, Dispositif.class);
                String result = "";
                for (Anomalie a : disp.getAnomalies()) {
                    if (a.getObjetMetier() != objetMetier) continue;
                    if (!result.isEmpty()) {
                        result = String.valueOf(result) + " ; ";
                    }
                    result = String.valueOf(result) + a.getTypeAnomalie();
                }
                return result;
            }
            ObjetMetier objetMetierNumero = null;
            if ("Dispositif".equals(this.columnName)) {
                Dispositif disp = (Dispositif)DispositifUtil.getParent((ObjetMetier)objetMetier, Dispositif.class);
                return disp.getNom();
            }
            if ("Bloc".equals(this.columnName)) {
                objetMetierNumero = DispositifUtil.getParent((ObjetMetier)objetMetier, Bloc.class);
            } else if ("SousBloc".equals(this.columnName)) {
                objetMetierNumero = DispositifUtil.getParent((ObjetMetier)objetMetier, SousBloc.class);
            } else if ("Parcelle".equals(this.columnName)) {
                objetMetierNumero = pu;
            }
            if (objetMetierNumero != null) {
                return objetMetierNumero.getNumero();
            }
        }
        if ("Maille vide".equals(this.columnName)) {
            return null;
        }
        return null;
    }

    public String getText(Object element) {
        Object value = this.getValue(element);
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public Image getImage(Object element) {
        if ((element instanceof Individu || element instanceof PuSurfacique) && "Mort".equals(this.columnName) && DispositifUtil.estMort((ObjetMetier)((ObjetMetier)element))) {
            return MORT;
        }
        if (element instanceof Individu) {
            Individu ind = (Individu)element;
            if ("Maille vide".equals(this.columnName) && ind.isMailleVide()) {
                return MAILLEVIDE;
            }
        }
        return null;
    }
}

