/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.wizard.filtres;

import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.editeurgraphique.wizard.filtres.AbstractTableViewer;
import fr.inra.adonis.editeurgraphique.wizard.filtres.PusColumnLabelProvider;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.plateforme.TypeUniteParcours;
import fr.inra.adonis.modeleMetier.protocole.Facteur;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;

public class PusTableViewer
extends AbstractTableViewer {
    private final ObjetMetier root;

    public PusTableViewer(ObjetMetier root, Composite parent, int style) {
        super(parent, style);
        this.root = root;
        this.createTitles();
        this.createColumns(parent);
    }

    private void createTitles() {
        int base = 8;
        boolean surfacique = false;
        HashSet<String> listeFacteurs = new HashSet<String>();
        if (this.root instanceof Plateforme) {
            for (Dispositif dispo : ((Plateforme)this.root).getDispositifs()) {
                surfacique = surfacique || dispo.isPuSurfacique();
                for (Facteur f : dispo.getProtocoles().getFacteurs()) {
                    listeFacteurs.add(f.getNom());
                }
            }
        } else {
            Dispositif dispo;
            dispo = DispositifUtil.getDispositifFrom((EObject)this.root);
            if (dispo != null) {
                surfacique = surfacique || dispo.isPuSurfacique();
                for (Facteur f : dispo.getProtocoles().getFacteurs()) {
                    listeFacteurs.add(f.getNom());
                }
            }
        }
        if (surfacique) {
            --base;
            base += 3;
        }
        this.titles = new String[base += listeFacteurs.size()];
        this.bounds = new Integer[base];
        int i = 0;
        this.titles[i] = "Dispositif";
        this.bounds[i] = 100;
        this.titles[++i] = "Bloc";
        this.bounds[i] = 50;
        this.titles[++i] = "SousBloc";
        this.bounds[i] = 50;
        this.titles[++i] = "Parcelle";
        this.bounds[i] = 50;
        this.titles[++i] = "Traitement (long)";
        this.bounds[i] = 100;
        this.titles[++i] = "Traitement (court)";
        this.bounds[i] = 50;
        ++i;
        for (String fName : listeFacteurs) {
            this.titles[i] = "Modalit\u00e9 " + fName;
            this.bounds[i] = 100;
            ++i;
        }
        if (!surfacique) {
            this.titles[i] = "Nb individus";
            this.bounds[i] = 50;
            ++i;
        } else {
            this.titles[i] = "X";
            this.bounds[i] = 50;
            this.titles[++i] = "Y";
            this.bounds[i] = 50;
            this.titles[++i] = "Mort";
            this.bounds[i] = 50;
            ++i;
        }
        this.titles[i] = "Anomalie";
        this.bounds[i] = 50;
        ++i;
    }

    @Override
    protected void assignColumnLabelProvider(TableViewerColumn col, int colIndex) {
        col.setLabelProvider((CellLabelProvider)new PusColumnLabelProvider(this.titles[colIndex], colIndex));
    }

    @Override
    public TypeUniteParcours getTypeUniteParcours() {
        return TypeUniteParcours.PARCELLE;
    }
}

