/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.adapter.oda.IODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.ODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.impl.DynamicFilterParameterAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.NativeDataTypeUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DynamicFilterParameterHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SortHintHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.SortHint;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.design.AndExpression;
import org.eclipse.datatools.connectivity.oda.design.CompositeFilterExpression;
import org.eclipse.datatools.connectivity.oda.design.CustomFilterExpression;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DynamicFilterExpression;
import org.eclipse.datatools.connectivity.oda.design.ExpressionArguments;
import org.eclipse.datatools.connectivity.oda.design.ExpressionParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.design.FilterExpression;
import org.eclipse.datatools.connectivity.oda.design.FilterExpressionType;
import org.eclipse.datatools.connectivity.oda.design.NullOrderingType;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ResultSetCriteria;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.SortDirectionType;
import org.eclipse.datatools.connectivity.oda.design.SortKey;
import org.eclipse.datatools.connectivity.oda.design.SortSpecification;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetCriteriaAdapter {
    private final OdaDataSetHandle setHandle;
    private final DataSetDesign setDesign;
    private final DynamicFilterParameterAdapter paramAdapter;
    private static final String SEPERATOR = ":";
    private static final String CUSTOM_PREFIX = "#";
    private static final String DYNAMIC_PREFIX = "!";
    protected final IODADesignFactory designFactory;

    public ResultSetCriteriaAdapter(OdaDataSetHandle setHandle, DataSetDesign setDesign) {
        this.setHandle = setHandle;
        this.setDesign = setDesign;
        this.paramAdapter = new DynamicFilterParameterAdapter(setHandle, setDesign);
        this.designFactory = ODADesignFactory.getFactory();
    }

    public void updateROMSortAndFilter() throws SemanticException {
        ResultSetDefinition resultSet = this.setDesign.getPrimaryResultSet();
        if (resultSet == null) {
            return;
        }
        ResultSetCriteria criteria = resultSet.getCriteria();
        if (criteria == null) {
            return;
        }
        this.updateROMSortHint(criteria);
        this.updateROMFilterCondition(criteria);
    }

    public void updateODAResultSetCriteria() {
        ResultSetDefinition resultSet = this.setDesign.getPrimaryResultSet();
        if (resultSet == null) {
            return;
        }
        ResultSetCriteria criteria = resultSet.getCriteria();
        if (criteria == null) {
            criteria = this.designFactory.createResultSetCriteria();
            resultSet.setCriteria(criteria);
        }
        this.updateODASortKey(criteria);
        this.updateOdaFilterExpression(criteria);
    }

    private void updateOdaFilterExpression(ResultSetCriteria criteria) {
        int count = 0;
        FilterExpression filterExpr = null;
        Iterator iter = this.setHandle.filtersIterator();
        block4: while (iter.hasNext()) {
            FilterConditionHandle filterHandle = (FilterConditionHandle)iter.next();
            FilterExpression filter = this.createOdaFilterExpression(filterHandle);
            if (filter == null) continue;
            switch (++count) {
                case 1: {
                    filterExpr = filter;
                    break;
                }
                case 2: {
                    AndExpression compositeFilterExp = this.designFactory.createAndExpression();
                    compositeFilterExp.add(filterExpr);
                    filterExpr = compositeFilterExp;
                }
                default: {
                    if (!(filterExpr instanceof CompositeFilterExpression)) continue block4;
                    ((CompositeFilterExpression)filterExpr).add(filter);
                }
            }
        }
        criteria.setFilterSpecification(filterExpr);
    }

    private void updateODASortKey(ResultSetCriteria criteria) {
        SortSpecification sortSpec = criteria.getRowOrdering();
        if (sortSpec == null) {
            sortSpec = this.designFactory.createSortSpecification();
            criteria.setRowOrdering(sortSpec);
        }
        EList list = sortSpec.getSortKeys();
        list.clear();
        Iterator iter = this.setHandle.sortHintsIterator();
        while (iter.hasNext()) {
            SortHintHandle handle = (SortHintHandle)iter.next();
            SortKey key = this.designFactory.createSortKey();
            key.setColumnName(handle.getColumnName());
            key.setColumnPosition(handle.getPosition());
            String ordering = handle.getNullValueOrdering();
            this.setODANullValueOrdering(key, ordering);
            key.setOptional(handle.isOptional());
            if ("asc".equals(handle.getDirection())) {
                key.setSortDirection(SortDirectionType.ASCENDING);
            } else if ("desc".equals(handle.getDirection())) {
                key.setSortDirection(SortDirectionType.DESCENDING);
            }
            list.add((Object)key);
        }
    }

    private void setODANullValueOrdering(SortKey key, String ordering) {
        if ("nullIsFirst".equals(ordering)) {
            key.setNullValueOrdering(NullOrderingType.NULLS_FIRST);
        } else if ("nullIsLast".equals(ordering)) {
            key.setNullValueOrdering(NullOrderingType.NULLS_LAST);
        } else if ("unknown".equals(ordering)) {
            key.setNullValueOrdering(NullOrderingType.UNKNOWN);
        }
    }

    private void updateROMSortHint(ResultSetCriteria criteria) throws SemanticException {
        SortSpecification sortSpec = criteria.getRowOrdering();
        if (sortSpec == null) {
            return;
        }
        PropertyHandle propHandle = this.setHandle.getPropertyHandle("sortHints");
        propHandle.clearValue();
        EList list = sortSpec.getSortKeys();
        int i = 0;
        while (i < list.size()) {
            SortKey key = (SortKey)list.get(i);
            SortHint sortHint = StructureFactory.createSortHint();
            sortHint.setProperty("columnName", (Object)key.getColumnName());
            sortHint.setProperty("position", (Object)key.getColumnPosition());
            sortHint.setProperty("isOptional", (Object)key.isOptional());
            SortDirectionType sortType = key.getSortDirection();
            if (SortDirectionType.ASCENDING.equals((Object)sortType)) {
                sortHint.setProperty("direction", (Object)"asc");
            } else if (SortDirectionType.DESCENDING.equals((Object)sortType)) {
                sortHint.setProperty("direction", (Object)"desc");
            }
            NullOrderingType type = key.getNullValueOrdering();
            this.setROMNullValueOrdering(sortHint, type);
            propHandle.addItem((IStructure)sortHint);
            ++i;
        }
    }

    private void setROMNullValueOrdering(SortHint hint, NullOrderingType type) {
        if (NullOrderingType.NULLS_FIRST.equals((Object)type)) {
            hint.setProperty("nullValueOrdering", (Object)"nullIsFirst");
        } else if (NullOrderingType.NULLS_LAST.equals((Object)type)) {
            hint.setProperty("nullValueOrdering", (Object)"nullIsLast");
        } else if (NullOrderingType.UNKNOWN.equals((Object)type)) {
            hint.setProperty("nullValueOrdering", (Object)"unknown");
        }
    }

    private void updateROMFilterCondition(ResultSetCriteria criteria) throws SemanticException {
        FilterExpression filterExpression = null;
        filterExpression = criteria.getFilterSpecification();
        if (filterExpression == null) {
            return;
        }
        Map<String, Filter> filterExprMap = this.buildFilterExpressionMap(filterExpression);
        this.cleanUpROMFilterCondition(filterExprMap);
        this.updateExistingROMFilterConditions(filterExprMap);
        this.createROMFilterConditions(filterExprMap);
        filterExprMap.clear();
        filterExprMap = null;
    }

    private Map<String, Filter> buildFilterExpressionMap(FilterExpression filterExpr) {
        LinkedHashMap<String, Filter> filterExpressions;
        block4: {
            block6: {
                block5: {
                    filterExpressions = new LinkedHashMap<String, Filter>();
                    if (filterExpr == null) break block4;
                    if (!(filterExpr instanceof CompositeFilterExpression)) break block5;
                    CompositeFilterExpression compositeFilterExp = (CompositeFilterExpression)filterExpr;
                    if (!(compositeFilterExp instanceof AndExpression)) break block4;
                    for (FilterExpression child : compositeFilterExp.getChildren()) {
                        filterExpressions.putAll(this.buildFilterExpressionMap(child));
                    }
                    break block4;
                }
                if (!(filterExpr instanceof CustomFilterExpression)) break block6;
                CustomFilter customFilter = new CustomFilter((CustomFilterExpression)filterExpr);
                String key = this.getMapKey(customFilter);
                if (key == null) break block4;
                filterExpressions.put(key, customFilter);
                break block4;
            }
            if (filterExpr instanceof DynamicFilterExpression) {
                DynamicFilterExpression dynamicFilterExpr = (DynamicFilterExpression)filterExpr;
                boolean isOptional = dynamicFilterExpr.isOptional();
                ExpressionArguments arguments = dynamicFilterExpr.getContextArguments();
                if (arguments != null && arguments.getExpressionParameterDefinitions() != null) {
                    for (ExpressionParameterDefinition paramDefn : arguments.getExpressionParameterDefinitions()) {
                        DynamicFilter dynamicFilter = new DynamicFilter(paramDefn, dynamicFilterExpr.getDefaultType(), isOptional);
                        String key = this.getMapKey(dynamicFilter);
                        if (key == null) continue;
                        filterExpressions.put(key, dynamicFilter);
                    }
                }
            }
        }
        return filterExpressions;
    }

    private String getMapKey(Filter filter) {
        String key = null;
        if (filter instanceof CustomFilter) {
            CustomFilter customFilter = (CustomFilter)filter;
            if (!StringUtil.isBlank((String)customFilter.getColumnExpr())) {
                key = CUSTOM_PREFIX + customFilter.customFilterExpr.toString();
            }
        } else if (filter instanceof DynamicFilter) {
            String columnExpr = ((DynamicFilter)filter).getColumnExpr();
            if (!StringUtil.isBlank((String)columnExpr)) {
                key = DYNAMIC_PREFIX + this.setHandle.getName() + SEPERATOR + columnExpr;
            }
        } else assert (false);
        return key;
    }

    private String getMapKey(FilterConditionHandle filterConditionHandle) {
        ParameterHandle parameterHandle;
        String key = null;
        if (!StringUtil.isBlank((String)filterConditionHandle.getDynamicFilterParameter()) && (parameterHandle = this.setHandle.getModuleHandle().findParameter(filterConditionHandle.getDynamicFilterParameter())) instanceof DynamicFilterParameterHandle) {
            DynamicFilterParameterHandle dynamicFilterParamHandle = (DynamicFilterParameterHandle)parameterHandle;
            key = DYNAMIC_PREFIX + dynamicFilterParamHandle.getDataSetName() + SEPERATOR + dynamicFilterParamHandle.getColumn();
        }
        return key;
    }

    private void updateExistingROMFilterConditions(Map<String, Filter> filterMap) throws SemanticException {
        Iterator iter = this.setHandle.filtersIterator();
        while (iter.hasNext()) {
            FilterConditionHandle filterConditionHandle = (FilterConditionHandle)iter.next();
            String key = this.getMapKey(filterConditionHandle);
            if (key != null && filterMap.containsKey(key)) {
                DynamicFilterParameterHandle dynamicFilterParamHandle = (DynamicFilterParameterHandle)this.setHandle.getModuleHandle().findParameter(filterConditionHandle.getDynamicFilterParameter());
                this.updateDynamicFilterCondition(filterConditionHandle, (DynamicFilter)filterMap.get(key), dynamicFilterParamHandle);
                filterMap.remove(key);
                continue;
            }
            assert (false);
        }
    }

    private void createROMFilterConditions(Map<String, Filter> filterMap) throws SemanticException {
        for (Filter filter : filterMap.values()) {
            FilterCondition filterCondition = StructureFactory.createFilterCond();
            filterCondition.setExpr(filter.getColumnExpr());
            FilterConditionHandle filterConditionHandle = (FilterConditionHandle)this.setHandle.getPropertyHandle("filter").addItem((IStructure)filterCondition);
            if (filter instanceof CustomFilter) {
                CustomFilterExpression customFilterExp = ((CustomFilter)filter).customFilterExpr;
                this.updateCustomFilterCondition(filterConditionHandle, customFilterExp);
                continue;
            }
            if (!(filter instanceof DynamicFilter)) continue;
            DynamicFilter dynamicFilter = (DynamicFilter)filter;
            DynamicFilterParameterHandle dynamicFilterParamHandle = this.setHandle.getModuleHandle().getElementFactory().newDynamicFilterParameter(null);
            dynamicFilterParamHandle.setDataSetName(this.setHandle.getName());
            dynamicFilterParamHandle.setColumn(dynamicFilter.getColumnName());
            Integer nativeDataType = dynamicFilter.getNativeDataType();
            if (nativeDataType != null) {
                dynamicFilterParamHandle.setNativeDataType(nativeDataType.intValue());
                try {
                    dynamicFilterParamHandle.setDataType(NativeDataTypeUtil.getUpdatedDataType(this.setDesign.getOdaExtensionDataSourceId(), this.setDesign.getOdaExtensionDataSetId(), nativeDataType, null, "paramType"));
                }
                catch (BirtException birtException) {}
            }
            this.setHandle.getModuleHandle().getParameters().add((DesignElementHandle)dynamicFilterParamHandle);
            filterConditionHandle.setDynamicFilterParameter(dynamicFilterParamHandle.getName());
            this.updateDynamicFilterCondition(filterConditionHandle, dynamicFilter, dynamicFilterParamHandle);
        }
    }

    private void updateCustomFilterCondition(FilterConditionHandle filterConditionHandle, CustomFilterExpression customFilterExpr) throws SemanticException {
        FilterExpressionType tmpType = customFilterExpr.getType();
        if (tmpType != null) {
            filterConditionHandle.setExtensionName(tmpType.getDeclaringExtensionId());
            filterConditionHandle.setExtensionExprId(tmpType.getId());
        }
        filterConditionHandle.setPushDown(true);
        filterConditionHandle.setOptional(customFilterExpr.isOptional());
    }

    private void updateDynamicFilterCondition(FilterConditionHandle filterConditionHandle, DynamicFilter dynamicFilter, DynamicFilterParameterHandle dynamicFilterParamHandle) throws SemanticException {
        filterConditionHandle.setOptional(dynamicFilter.isOptional);
        this.paramAdapter.updateROMDynamicFilterParameter(dynamicFilter, dynamicFilterParamHandle);
    }

    private void cleanUpROMFilterCondition(Map<String, Filter> filterMap) throws SemanticException {
        ArrayList<FilterCondition> dropList = new ArrayList<FilterCondition>();
        Iterator iter = this.setHandle.filtersIterator();
        while (iter.hasNext()) {
            FilterConditionHandle filterHandle = (FilterConditionHandle)iter.next();
            String dynamicParameterName = filterHandle.getDynamicFilterParameter();
            String key = this.getMapKey(filterHandle);
            if (key == null || filterMap.containsKey(key)) continue;
            if (!StringUtil.isBlank((String)dynamicParameterName)) {
                ParameterHandle parameterHandle = this.setHandle.getModuleHandle().findParameter(dynamicParameterName);
                parameterHandle.drop();
            }
            dropList.add((FilterCondition)filterHandle.getStructure());
        }
        for (FilterCondition fc : dropList) {
            this.setHandle.removeFilter(fc);
        }
    }

    private FilterExpression createOdaFilterExpression(FilterConditionHandle filterHandle) {
        CustomFilterExpression filterExpr = null;
        if (StringUtil.isBlank((String)filterHandle.getDynamicFilterParameter())) {
            if (filterHandle.getExtensionName() == null || filterHandle.getExtensionExprId() == null) {
                return null;
            }
            CustomFilterExpression customFilterExpr = this.designFactory.createCustomFilterExpression();
            ExpressionVariable variable = this.designFactory.createExpressionVariable();
            variable.setIdentifier(filterHandle.getExpr());
            customFilterExpr.setContextVariable(variable);
            FilterExpressionType tmpType = this.designFactory.createFilterExpressionType();
            tmpType.setDeclaringExtensionId(filterHandle.getExtensionName());
            tmpType.setId(filterHandle.getExtensionExprId());
            customFilterExpr.setType(tmpType);
            customFilterExpr.setIsOptional(filterHandle.isOptional());
            filterExpr = customFilterExpr;
        } else {
            ParameterHandle paramHandle = this.setHandle.getModuleHandle().findParameter(filterHandle.getDynamicFilterParameter());
            if (paramHandle instanceof DynamicFilterParameterHandle) {
                DynamicFilterParameterHandle dynamicParamHandle = (DynamicFilterParameterHandle)paramHandle;
                DynamicFilterExpression dynamicFilterExpr = this.designFactory.createDynamicFilterExpression();
                FilterExpressionType defaultType = null;
                if (filterHandle.getExtensionName() != null && filterHandle.getExtensionExprId() != null) {
                    defaultType = this.designFactory.createFilterExpressionType();
                    defaultType.setDeclaringExtensionId(filterHandle.getExtensionName());
                }
                dynamicFilterExpr.setIsOptional(filterHandle.isOptional());
                ExpressionArguments arguments = this.designFactory.createExpressionArguments();
                ParameterDefinition paramDefn = this.designFactory.createParameterDefinition();
                this.paramAdapter.updateODADynamicFilter(paramDefn, defaultType, dynamicParamHandle);
                paramDefn.getAttributes().setName(dynamicParamHandle.getColumn());
                if (dynamicParamHandle.getProperty("nativeDataType") != null) {
                    paramDefn.getAttributes().setNativeDataTypeCode(dynamicParamHandle.getNativeDataType());
                }
                arguments.addDynamicParameter(paramDefn);
                dynamicFilterExpr.setContextArguments(arguments);
                if (defaultType != null && defaultType.getId() != null) {
                    dynamicFilterExpr.setDefaultType(defaultType);
                }
                filterExpr = dynamicFilterExpr;
            }
        }
        return filterExpr;
    }

    private static class CustomFilter
    implements Filter {
        public CustomFilterExpression customFilterExpr;

        public CustomFilter(CustomFilterExpression filterExpr) {
            this.customFilterExpr = filterExpr;
        }

        public String getColumnExpr() {
            ExpressionVariable variable = this.customFilterExpr.getContextVariable();
            if (variable != null) {
                return variable.getIdentifier();
            }
            return null;
        }
    }

    static class DynamicFilter
    implements Filter {
        boolean isOptional;
        ExpressionParameterDefinition exprParamDefn;
        FilterExpressionType defaultType;

        DynamicFilter(ExpressionParameterDefinition exprParamDefn, FilterExpressionType defaultType, boolean isOptional) {
            this.isOptional = isOptional;
            this.exprParamDefn = exprParamDefn;
            this.defaultType = defaultType;
        }

        public String getColumnName() {
            ParameterDefinition paramDefn = this.exprParamDefn.getDynamicInputParameter();
            if (paramDefn != null && paramDefn.getAttributes() != null) {
                return paramDefn.getAttributes().getName();
            }
            return null;
        }

        public String getColumnExpr() {
            String columnName = this.getColumnName();
            if (!StringUtil.isBlank((String)columnName)) {
                return ExpressionUtil.createDataSetRowExpression((String)columnName);
            }
            return null;
        }

        public Integer getNativeDataType() {
            ParameterDefinition paramDefn = this.exprParamDefn.getDynamicInputParameter();
            if (paramDefn != null && paramDefn.getAttributes() != null) {
                return paramDefn.getAttributes().getNativeDataTypeCode();
            }
            return null;
        }

        public FilterExpressionType getDefaultType() {
            return this.defaultType;
        }
    }

    private static interface Filter {
        public String getColumnExpr();
    }
}

