/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.visualisation.notes.filters;

import fr.inra.adonis.core.indexer.AdonisIndexer;
import fr.inra.adonis.core.labelprovider.AbstractBlocLabelProvider;
import fr.inra.adonis.core.labelprovider.DispositifLabelProvider;
import fr.inra.adonis.core.labelprovider.IndividuLabelProvider;
import fr.inra.adonis.core.labelprovider.ParcelleUnitaireLabelProvider;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.PuIndividuel;
import fr.inra.adonis.modeleMetier.plateforme.PuSurfacique;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.visualisation.notes.filters.CompositeFilterComponent;
import fr.inra.adonis.visualisation.notes.sorter.CoordonneeSorter;
import fr.inra.adonis.visualisation.notes.sorter.UniteDeParcoursSorter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CombosFilterComponent
extends Composite {
    public static final String ALL = "[Tous]";
    private final CompositeFilterComponent visuTabCompo;
    private final ComboViewer comboDispositifViewer;
    private final ComboViewer comboBlocViewer;
    private ComboViewer comboSousBlocViewer;
    private final ComboViewer comboPUViewer;
    private final AdonisIndexer objetIndexe;
    private final FormToolkit toolkit;
    private boolean hasSousBloc;
    private ComboViewer comboIndividuViewer;
    private ComboViewer comboXViewer;
    private ComboViewer comboYViewer;
    private final boolean fromStats;
    private final boolean displayNumIndividu;

    private Object[] getInputForCombo(Set<?> inputSet) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ALL);
        list.addAll(inputSet);
        return list.toArray();
    }

    private Object[] getInputForCombo(List<?> inputList) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ALL);
        list.addAll(inputList);
        return list.toArray();
    }

    public CombosFilterComponent(Composite parent, final CompositeFilterComponent visuTabCompo, int style, AdonisIndexer bagObjIndex, boolean fromStats, boolean displayNumIndividu) {
        super(parent, style);
        this.displayNumIndividu = displayNumIndividu;
        this.objetIndexe = bagObjIndex;
        this.visuTabCompo = visuTabCompo;
        this.fromStats = fromStats;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        this.toolkit = new FormToolkit(display);
        if (bagObjIndex != null) {
            this.hasSousBloc = bagObjIndex.getSetSousBloc().size() > 0;
        }
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this.setLayoutData(new GridData(16384, 128, true, false));
        int nbCol = 6;
        if (fromStats) {
            nbCol -= 2;
        }
        if (this.hasSousBloc) {
            ++nbCol;
        }
        if (displayNumIndividu) {
            ++nbCol;
        }
        GridLayout gridLayout = new GridLayout(nbCol, false);
        gridLayout.marginTop = gridLayout.marginBottom = 5;
        gridLayout.marginRight = gridLayout.marginBottom;
        gridLayout.marginLeft = gridLayout.marginBottom;
        this.setLayout((Layout)gridLayout);
        this.toolkit.createLabel((Composite)this, "Dispositif:");
        this.toolkit.createLabel((Composite)this, "Bloc:");
        if (this.hasSousBloc) {
            this.toolkit.createLabel((Composite)this, "Sous Bloc:");
        }
        this.toolkit.createLabel((Composite)this, "Parcelle Unitaire:");
        if (displayNumIndividu) {
            this.toolkit.createLabel((Composite)this, "Individu:");
        }
        if (!fromStats) {
            this.toolkit.createLabel((Composite)this, "X:");
            this.toolkit.createLabel((Composite)this, "Y:");
        }
        this.toolkit.createLabel((Composite)this, "");
        this.comboDispositifViewer = new ComboViewer((Composite)this);
        this.comboDispositifViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboDispositifViewer.setLabelProvider((IBaseLabelProvider)new DispositifLabelProvider());
        if (this.objetIndexe != null) {
            this.comboDispositifViewer.setInput((Object)this.getInputForCombo(this.objetIndexe.getSetDispositif()));
        }
        this.comboDispositifViewer.addSelectionChangedListener((ISelectionChangedListener)new RefreshViewerEvent());
        this.comboDispositifViewer.setComparator((ViewerComparator)new UniteDeParcoursSorter());
        this.comboDispositifViewer.addPostSelectionChangedListener((ISelectionChangedListener)new DispositifSelectionChangedListener());
        this.comboDispositifViewer.getCombo().select(0);
        this.comboBlocViewer = new ComboViewer((Composite)this);
        this.comboBlocViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboBlocViewer.setLabelProvider((IBaseLabelProvider)new AbstractBlocLabelProvider());
        if (this.objetIndexe != null) {
            this.comboBlocViewer.setInput((Object)this.getInputForCombo(this.objetIndexe.getSetBloc()));
        }
        this.comboBlocViewer.addSelectionChangedListener((ISelectionChangedListener)new RefreshViewerEvent());
        this.comboBlocViewer.setComparator((ViewerComparator)new UniteDeParcoursSorter());
        this.comboBlocViewer.addPostSelectionChangedListener((ISelectionChangedListener)new BlocSelectionChangedListener());
        this.comboBlocViewer.getCombo().select(0);
        if (this.hasSousBloc) {
            this.comboSousBlocViewer = new ComboViewer((Composite)this);
            this.comboSousBlocViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.comboSousBlocViewer.setLabelProvider((IBaseLabelProvider)new AbstractBlocLabelProvider());
            if (this.objetIndexe != null) {
                this.comboSousBlocViewer.setInput((Object)this.getInputForCombo(this.objetIndexe.getSetSousBloc()));
            }
            this.comboSousBlocViewer.addSelectionChangedListener((ISelectionChangedListener)new RefreshViewerEvent());
            this.comboSousBlocViewer.setComparator((ViewerComparator)new UniteDeParcoursSorter());
            this.comboSousBlocViewer.addPostSelectionChangedListener((ISelectionChangedListener)new SousBlocSelectionListener());
            this.comboSousBlocViewer.getCombo().select(0);
        }
        this.comboPUViewer = new ComboViewer((Composite)this);
        this.comboPUViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboPUViewer.setLabelProvider((IBaseLabelProvider)new ParcelleUnitaireLabelProvider());
        if (this.objetIndexe != null) {
            HashSet<Integer> numeroSet = new HashSet<Integer>();
            for (ParcelleUnitaire pu : this.objetIndexe.getSetPU()) {
                numeroSet.add(pu.getNumero());
            }
            this.comboPUViewer.setInput((Object)this.getInputForCombo(numeroSet));
        }
        this.comboPUViewer.addSelectionChangedListener((ISelectionChangedListener)new RefreshViewerEvent());
        this.comboPUViewer.setComparator((ViewerComparator)new UniteDeParcoursSorter());
        this.comboPUViewer.addPostSelectionChangedListener((ISelectionChangedListener)new PUSelectionListener());
        this.comboPUViewer.getCombo().select(0);
        if (displayNumIndividu) {
            this.comboIndividuViewer = new ComboViewer((Composite)this);
            this.comboIndividuViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.comboIndividuViewer.setLabelProvider((IBaseLabelProvider)new IndividuLabelProvider());
            if (this.objetIndexe != null) {
                this.comboIndividuViewer.setInput((Object)this.getInputForCombo(this.objetIndexe.getSetIndividu()));
            }
            this.comboIndividuViewer.addSelectionChangedListener((ISelectionChangedListener)new RefreshViewerEvent());
            this.comboIndividuViewer.setComparator((ViewerComparator)new UniteDeParcoursSorter());
            this.comboIndividuViewer.getCombo().select(0);
        }
        if (!fromStats) {
            this.comboXViewer = new ComboViewer((Composite)this);
            this.comboXViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.comboXViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Integer) {
                        return String.valueOf(element);
                    }
                    return element.toString();
                }
            });
            if (this.objetIndexe != null) {
                this.comboXViewer.setInput((Object)this.getInputForCombo(this.objetIndexe.getSetX()));
            }
            this.comboXViewer.addSelectionChangedListener((ISelectionChangedListener)new RefreshViewerEvent());
            this.comboXViewer.setComparator((ViewerComparator)new CoordonneeSorter());
            this.comboXViewer.getCombo().select(0);
            if (fromStats) {
                this.comboXViewer.getCombo().setVisible(false);
            }
            this.comboYViewer = new ComboViewer((Composite)this);
            this.comboYViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.comboYViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Integer) {
                        return String.valueOf(element);
                    }
                    return element.toString();
                }
            });
            if (this.objetIndexe != null) {
                this.comboYViewer.setInput((Object)this.getInputForCombo(this.objetIndexe.getSetY()));
            }
            this.comboYViewer.addSelectionChangedListener((ISelectionChangedListener)new RefreshViewerEvent());
            this.comboYViewer.setComparator((ViewerComparator)new CoordonneeSorter());
            this.comboYViewer.getCombo().select(0);
            if (fromStats) {
                this.comboYViewer.getCombo().setVisible(false);
            }
        }
        Button reinitButton = this.toolkit.createButton((Composite)this, "Reinitialiser", 8);
        reinitButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CombosFilterComponent.this.comboDispositifViewer.setSelection(null);
                CombosFilterComponent.this.comboBlocViewer.setSelection(null);
                if (CombosFilterComponent.this.hasSousBloc && CombosFilterComponent.this.comboSousBlocViewer != null) {
                    CombosFilterComponent.this.comboSousBlocViewer.setSelection(null);
                }
                CombosFilterComponent.this.comboPUViewer.setSelection(null);
                if (CombosFilterComponent.this.comboIndividuViewer != null) {
                    CombosFilterComponent.this.comboIndividuViewer.setSelection(null);
                    CombosFilterComponent.this.comboIndividuViewer.getCombo().select(0);
                }
                if (CombosFilterComponent.this.comboXViewer != null) {
                    CombosFilterComponent.this.comboXViewer.setSelection(null);
                    CombosFilterComponent.this.comboYViewer.setSelection(null);
                    CombosFilterComponent.this.comboYViewer.getCombo().select(0);
                    CombosFilterComponent.this.comboXViewer.getCombo().select(0);
                }
                visuTabCompo.refreshTable();
                CombosFilterComponent.this.comboPUViewer.getCombo().select(0);
                if (CombosFilterComponent.this.hasSousBloc && CombosFilterComponent.this.comboSousBlocViewer != null) {
                    CombosFilterComponent.this.comboSousBlocViewer.getCombo().select(0);
                }
                CombosFilterComponent.this.comboBlocViewer.getCombo().select(0);
                CombosFilterComponent.this.comboDispositifViewer.getCombo().select(0);
            }
        });
    }

    private void propageSelectionBloc(Object selection) {
        ArrayList listSousBlocOrPU = new ArrayList();
        if (selection == null || selection instanceof String) {
            Object[] listBloc;
            Object[] objectArray = listBloc = (Object[])this.comboBlocViewer.getInput();
            int n = listBloc.length;
            int n2 = 0;
            while (n2 < n) {
                Object objCurrent = objectArray[n2];
                if (objCurrent instanceof Bloc) {
                    Bloc b = (Bloc)objCurrent;
                    if (this.hasSousBloc) {
                        listSousBlocOrPU.addAll(b.getSousBlocs());
                    } else {
                        listSousBlocOrPU.addAll(b.getParcellesUnitaire());
                    }
                }
                ++n2;
            }
        } else if (selection instanceof Bloc) {
            Bloc b = (Bloc)selection;
            if (this.hasSousBloc) {
                listSousBlocOrPU.addAll(b.getSousBlocs());
            } else {
                listSousBlocOrPU.addAll(b.getParcellesUnitaire());
            }
        }
        if (this.hasSousBloc && this.comboSousBlocViewer != null) {
            this.comboSousBlocViewer.setInput((Object)this.getInputForCombo(listSousBlocOrPU));
            this.propageSelectionSousBloc(null);
        } else {
            this.comboPUViewer.setInput((Object)this.getInputForCombo(listSousBlocOrPU));
            this.propageSelectionPU(null);
        }
    }

    private void propageSelectionSousBloc(Object selection) {
        EList listPU = new ArrayList();
        if (selection == null || selection instanceof String) {
            Object[] tabInputSb;
            Object[] objectArray = tabInputSb = (Object[])this.comboSousBlocViewer.getInput();
            int n = tabInputSb.length;
            int n2 = 0;
            while (n2 < n) {
                Object objCurrent = objectArray[n2];
                if (objCurrent instanceof SousBloc) {
                    SousBloc sb = (SousBloc)objCurrent;
                    listPU.addAll(sb.getParcellesUnitaire());
                }
                ++n2;
            }
        } else if (selection instanceof SousBloc) {
            SousBloc sb = (SousBloc)selection;
            listPU = sb.getParcellesUnitaire();
        }
        this.comboPUViewer.setInput((Object)this.getInputForCombo((List<?>)listPU));
        this.propageSelectionPU(null);
    }

    private void propageSelectionPU(Object selection) {
        ArrayList<ObjetMetier> listFeuille = new ArrayList<ObjetMetier>();
        if (selection == null || selection instanceof String) {
            Object[] tabInputSb = (Object[])this.comboPUViewer.getInput();
            Object[] objectArray = tabInputSb;
            int n = tabInputSb.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.propageSelectionFeuille(listFeuille, element);
                ++n2;
            }
        } else if (selection instanceof List) {
            for (Object obj : (List)selection) {
                this.propageSelectionFeuille(listFeuille, obj);
            }
        } else {
            this.propageSelectionFeuille(listFeuille, selection);
        }
        HashSet<Integer> coordsX = new HashSet<Integer>();
        HashSet<Integer> coordsY = new HashSet<Integer>();
        HashSet<Integer> numIndividu = new HashSet<Integer>();
        for (ObjetMetier ind : listFeuille) {
            coordsX.add(ind.getX());
            coordsY.add(ind.getY());
            numIndividu.add(ind.getNumero());
        }
        if (!this.fromStats) {
            this.comboXViewer.setInput((Object)this.getInputForCombo(coordsX));
            this.comboYViewer.setInput((Object)this.getInputForCombo(coordsY));
        }
        if (this.displayNumIndividu) {
            this.comboIndividuViewer.setInput((Object)this.getInputForCombo(numIndividu));
        }
        if (this.visuTabCompo != null) {
            this.visuTabCompo.refreshTable();
        }
    }

    private void propageSelectionFeuille(List<ObjetMetier> listFeuille, Object objCurrent) {
        if (objCurrent instanceof PuIndividuel) {
            listFeuille.addAll((Collection<ObjetMetier>)((PuIndividuel)objCurrent).getIndividus());
        } else if (objCurrent instanceof PuSurfacique) {
            listFeuille.add((ObjetMetier)((PuSurfacique)objCurrent));
        }
    }

    protected void checkSubclass() {
    }

    public ComboViewer getComboDispositifViewer() {
        return this.comboDispositifViewer;
    }

    public ComboViewer getComboBlocViewer() {
        return this.comboBlocViewer;
    }

    public ComboViewer getComboSousBlocViewer() {
        return this.comboSousBlocViewer;
    }

    public ComboViewer getComboPUViewer() {
        return this.comboPUViewer;
    }

    public ComboViewer getComboNumIndividuViewer() {
        return this.comboIndividuViewer;
    }

    public ComboViewer getComboXViewer() {
        return this.comboXViewer;
    }

    public ComboViewer getComboYViewer() {
        return this.comboYViewer;
    }

    private final class BlocSelectionChangedListener
    implements ISelectionChangedListener {
        private BlocSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            CombosFilterComponent.this.propageSelectionBloc(selection);
        }
    }

    private final class DispositifSelectionChangedListener
    implements ISelectionChangedListener {
        private DispositifSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            EList listBloc = new ArrayList();
            if (selection == null || selection instanceof String) {
                Object[] tabDispo;
                Object[] objectArray = tabDispo = (Object[])CombosFilterComponent.this.comboDispositifViewer.getInput();
                int n = tabDispo.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof Dispositif) {
                        Dispositif d = (Dispositif)obj;
                        listBloc.addAll(d.getBlocs());
                    }
                    ++n2;
                }
            } else if (selection instanceof Dispositif) {
                Dispositif dispo = (Dispositif)selection;
                listBloc = dispo.getBlocs();
            }
            CombosFilterComponent.this.comboBlocViewer.setInput((Object)CombosFilterComponent.this.getInputForCombo((List)listBloc));
            CombosFilterComponent.this.propageSelectionBloc(null);
        }
    }

    private final class PUSelectionListener
    implements ISelectionChangedListener {
        private PUSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            CombosFilterComponent.this.propageSelectionPU(selection);
        }
    }

    private final class RefreshViewerEvent
    implements ISelectionChangedListener {
        private RefreshViewerEvent() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            CombosFilterComponent.this.visuTabCompo.refreshTable();
        }
    }

    private final class SousBlocSelectionListener
    implements ISelectionChangedListener {
        private SousBlocSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            CombosFilterComponent.this.propageSelectionSousBloc(selection);
        }
    }
}

