/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.visualisation.notes.filters;

import fr.inra.adonis.core.util.FormatUtil;
import fr.inra.adonis.visualisation.notes.VisualisationNotesComponent;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class LineViewerFilter
extends ViewerFilter {
    Map<Integer, String> filtres;
    Map<Integer, String> comparateurs;
    VisualisationNotesComponent tab;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.filtres == null || this.filtres.isEmpty()) {
            return true;
        }
        Iterator<Integer> iterator = this.filtres.keySet().iterator();
        if (iterator.hasNext()) {
            int result;
            Integer key = iterator.next();
            String val = this.tab.getWrapperLabelProvider().getColumnText(element, key);
            String operateur = this.comparateurs.get(key);
            String valeurFiltree = this.filtres.get(key);
            if (operateur.equals("CONTIENT")) {
                return val.contains(valeurFiltree);
            }
            Object valCompare1 = null;
            Object valCompare2 = null;
            try {
                valCompare1 = Double.parseDouble(val);
                valCompare2 = Double.parseDouble(valeurFiltree);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    valCompare2 = FormatUtil.getSimpleDateFormat().parse(valeurFiltree);
                    valCompare1 = FormatUtil.getSimpleDateFormat().parse(val);
                }
                catch (ParseException parseException) {}
            }
            if (valCompare1 == null) {
                valCompare1 = val;
            }
            if (valCompare2 == null) {
                valCompare2 = val;
            }
            if ((result = valCompare1.compareTo(valCompare2)) < 0 && operateur.startsWith("<")) {
                return true;
            }
            if (result > 0 && operateur.startsWith(">")) {
                return true;
            }
            return result == 0 && operateur.endsWith("=") && !operateur.equals("!=");
        }
        return true;
    }

    public Map<Integer, String> getFiltres() {
        return this.filtres;
    }

    public void setFiltres(Map<Integer, String> filtres) {
        this.filtres = filtres;
    }

    public VisualisationNotesComponent getTab() {
        return this.tab;
    }

    public Map<Integer, String> getComparateurs() {
        return this.comparateurs;
    }

    public void setComparateurs(Map<Integer, String> comparateurs) {
        this.comparateurs = comparateurs;
    }

    public void setTab(VisualisationNotesComponent tab) {
        this.tab = tab;
    }
}

