/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.algorithmeplugin.splitplot;

import fr.inra.adonis.core.rcp.AdonisLabelProvider;
import fr.inra.adonis.modeleMetier.plateforme.TypeSpatialisation;
import fr.inra.adonis.modeleMetier.protocole.Facteur;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class AlgoDialog2F
extends TitleAreaDialog {
    private static final int DIALOG_MARGIN = 20;
    private final boolean surfacique;
    private final List<Facteur> mlist;
    private final int nbTraitement;
    private Facteur f1 = null;
    private Facteur f2 = null;
    private Button okBtn = null;
    protected int nbIndsParPu = 1;
    protected int nbIndsParLigne = 1;
    private ComboViewer f1comboViewer;
    private ComboViewer f2comboViewer;
    private boolean lock = false;
    private TypeSpatialisation spatialisation = TypeSpatialisation.BUREAU;
    protected int nbBlocsParLigne = 1;
    protected int nbPusParLigne = 1;
    protected int nbSousBlocsParLigne = 1;
    private final int nbBlocs;

    protected AlgoDialog2F(Shell parentShell, List<Facteur> mlist, int b, boolean surfacique, TypeSpatialisation spatialisation, int nbTrait) {
        super(parentShell);
        this.setShellStyle(65648);
        this.mlist = mlist;
        this.surfacique = surfacique;
        this.spatialisation = spatialisation;
        this.nbBlocs = b;
        this.nbTraitement = nbTrait;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Mofifier les parametres de l'algorithme");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Algorithme Split Plot");
        this.setMessage("Merci de reorganiser les facteurs. Le premier facteur determine les Sous Blocs.", 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(0x1000000, 128, true, true, 1, 1));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginTop = 20;
        gridLayout.marginBottom = 20;
        gridLayout.marginLeft = 20;
        gridLayout.marginRight = 20;
        container.setLayout((Layout)gridLayout);
        Group grpNbElements = new Group(container, 0);
        grpNbElements.setText("Nombre d'\u00e9l\u00e9ments");
        grpNbElements.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpNbElements.setLayout((Layout)new GridLayout(2, false));
        Label nbBlocLabel = new Label((Composite)grpNbElements, 0);
        nbBlocLabel.setText("Nombre de blocs : ");
        Text txtNbBlocs = new Text((Composite)grpNbElements, 2048);
        txtNbBlocs.setText(Integer.toString(this.nbBlocs));
        txtNbBlocs.setEnabled(false);
        Label nbPUTotal = new Label((Composite)grpNbElements, 0);
        nbPUTotal.setText("Nombre total de PU : ");
        Text txtNbPuTotal = new Text((Composite)grpNbElements, 2048);
        txtNbPuTotal.setText(Integer.toString(this.nbBlocs * this.nbTraitement));
        txtNbPuTotal.setEnabled(false);
        Group grpFacteurs = new Group(container, 0);
        grpFacteurs.setText("Hi\u00e9rarchisation des facteurs");
        grpFacteurs.setLayout((Layout)new GridLayout(2, false));
        Label lblFacteur = new Label((Composite)grpFacteurs, 0);
        lblFacteur.setText("Premier Facteur : ");
        this.f1comboViewer = new ComboViewer((Composite)grpFacteurs, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        gridData.widthHint = 144;
        this.f1comboViewer.getCombo().setLayoutData((Object)gridData);
        this.f1comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.f1comboViewer.setLabelProvider((IBaseLabelProvider)AdonisLabelProvider.getInstance());
        Label lblFacteurSousBloc = new Label((Composite)grpFacteurs, 0);
        lblFacteurSousBloc.setText("Deuxi\u00e8me Facteur : ");
        this.f2comboViewer = new ComboViewer((Composite)grpFacteurs, 0);
        this.f2comboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.f2comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.f2comboViewer.setLabelProvider((IBaseLabelProvider)AdonisLabelProvider.getInstance());
        Group grpRepartition = new Group(container, 0);
        grpRepartition.setText("R\u00e9partition par ligne");
        grpRepartition.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        grpRepartition.setLayout((Layout)new GridLayout(2, false));
        Label lblNbBlocsParLigne = new Label((Composite)grpRepartition, 0);
        lblNbBlocsParLigne.setText("Nombre de blocs par ligne pour le dispositif: ");
        final Spinner spnNbBlocsParLigne = new Spinner((Composite)grpRepartition, 2048);
        spnNbBlocsParLigne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog2F.this.nbBlocsParLigne = spnNbBlocsParLigne.getSelection();
            }
        });
        spnNbBlocsParLigne.setMinimum(1);
        spnNbBlocsParLigne.setMaximum(this.nbBlocs);
        Label lblNbSousBlocsParLigne = new Label((Composite)grpRepartition, 0);
        lblNbSousBlocsParLigne.setText("Nombre de sous-blocs par ligne pour un bloc: ");
        final Spinner spnSousBlocsParLigne = new Spinner((Composite)grpRepartition, 2048);
        spnSousBlocsParLigne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog2F.this.nbSousBlocsParLigne = spnSousBlocsParLigne.getSelection();
            }
        });
        spnSousBlocsParLigne.setMinimum(1);
        spnSousBlocsParLigne.setMaximum(1000);
        Label lblNbParcellesParLigne = new Label((Composite)grpRepartition, 0);
        lblNbParcellesParLigne.setText("Nombre de PU par ligne pour un sous-bloc: ");
        final Spinner spnNbPusParLigne = new Spinner((Composite)grpRepartition, 2048);
        spnNbPusParLigne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog2F.this.nbPusParLigne = spnNbPusParLigne.getSelection();
            }
        });
        spnNbPusParLigne.setMinimum(1);
        spnNbPusParLigne.setMaximum(1000);
        grpRepartition.setVisible(this.spatialisation == TypeSpatialisation.BUREAU);
        Group grpForm = new Group(container, 0);
        grpForm.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        if (this.surfacique) {
            grpForm.setText("Facteur de forme");
        } else {
            grpForm.setText("Facteur de forme de la PU");
        }
        grpForm.setLayout((Layout)new GridLayout(2, false));
        Label lblNbInds = new Label((Composite)grpForm, 0);
        lblNbInds.setText("Nombre d'individus par parcelle : ");
        final Spinner spnNbIndsParPU = new Spinner((Composite)grpForm, 2048);
        spnNbIndsParPU.setMinimum(1);
        spnNbIndsParPU.setMaximum(30000);
        Label lblNbIndsParLigne = new Label((Composite)grpForm, 0);
        lblNbIndsParLigne.setText("Nombre d'individus par ligne : ");
        final Spinner spnNbIndsParLigne = new Spinner((Composite)grpForm, 2048);
        spnNbIndsParLigne.setMinimum(1);
        spnNbIndsParLigne.setMaximum(30000);
        spnNbIndsParPU.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog2F.this.nbIndsParPu = spnNbIndsParPU.getSelection();
                spnNbIndsParLigne.setMaximum(AlgoDialog2F.this.nbIndsParPu);
            }
        });
        spnNbIndsParLigne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog2F.this.nbIndsParLigne = spnNbIndsParLigne.getSelection();
            }
        });
        grpForm.setVisible(!this.surfacique);
        this.f1comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AlgoDialog2F.this.f1 = (Facteur)((StructuredSelection)event.getSelection()).getFirstElement();
                if (AlgoDialog2F.this.lock) {
                    return;
                }
                Facteur other = null;
                for (Facteur f : AlgoDialog2F.this.mlist) {
                    if (f == AlgoDialog2F.this.f1) continue;
                    other = f;
                }
                AlgoDialog2F.this.lock = true;
                AlgoDialog2F.this.f2comboViewer.setSelection((ISelection)new StructuredSelection(other));
                AlgoDialog2F.this.lock = false;
                AlgoDialog2F.this.validate();
            }
        });
        this.f2comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AlgoDialog2F.this.f2 = (Facteur)((StructuredSelection)event.getSelection()).getFirstElement();
                if (AlgoDialog2F.this.lock) {
                    return;
                }
                Facteur other = null;
                for (Facteur f : AlgoDialog2F.this.mlist) {
                    if (f == AlgoDialog2F.this.f2) continue;
                    other = f;
                }
                AlgoDialog2F.this.lock = true;
                AlgoDialog2F.this.f1comboViewer.setSelection((ISelection)new StructuredSelection(other));
                AlgoDialog2F.this.lock = false;
                AlgoDialog2F.this.validate();
            }
        });
        this.f1comboViewer.setInput((Object)this.mlist.toArray());
        this.f2comboViewer.setInput((Object)this.mlist.toArray());
        parent.pack();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okBtn = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okBtn.setEnabled(false);
        this.createButton(parent, 1, "Annuler", false);
        this.validate();
    }

    private void validate() {
        if (this.okBtn == null) {
            return;
        }
        if (this.mlist.size() == 2 && this.f1 != null && this.f2 != null) {
            this.okBtn.setEnabled(true);
        } else {
            this.okBtn.setEnabled(false);
        }
    }

    public List<Facteur> getFacteursOrdonnes() {
        ArrayList<Facteur> result = new ArrayList<Facteur>();
        if (this.f1 != null) {
            result.add(this.f1);
        }
        if (this.f2 != null) {
            result.add(this.f2);
        }
        return result;
    }

    public List<Integer> getListNbModalites() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (this.f1 != null) {
            result.add(this.f1.getModalites().size());
        }
        if (this.f2 != null) {
            result.add(this.f2.getModalites().size());
        }
        return result;
    }

    public int getNbBlocsParLigne() {
        return this.nbBlocsParLigne;
    }

    public int getNbSousBlocsParLigne() {
        return this.nbSousBlocsParLigne;
    }

    public int getNbPusParLigne() {
        return this.nbPusParLigne;
    }

    public int getNbIndsParPu() {
        return this.nbIndsParPu;
    }

    public int getNbIndsParLigne() {
        return this.nbIndsParLigne;
    }
}

