/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.algorithmeplugin.splitplot;

import fr.inra.adonis.core.rcp.AdonisLabelProvider;
import fr.inra.adonis.modeleMetier.plateforme.TypeSpatialisation;
import fr.inra.adonis.modeleMetier.protocole.Facteur;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class AlgoDialog3F
extends TitleAreaDialog {
    private static final int DIALOG_MARGIN = 20;
    private final boolean surfacique;
    private final List<Facteur> mlist;
    private final int nbTraitement;
    private Facteur indF1 = null;
    private Facteur indF2 = null;
    private Facteur indF3 = null;
    private Object grpF1 = null;
    private Object grpF2 = null;
    protected int nbIndsParPu = 1;
    protected int nbIndsParLigne = 1;
    private Button okBtn = null;
    private ComboViewer f1comboViewer;
    private ComboViewer f2comboViewer;
    private ComboViewer f3comboViewer;
    private boolean lock = false;
    private Button indeBtn;
    private Composite indeComposite;
    private Composite grpComposite;
    private StackLayout stackLayout;
    private Composite stackComposite;
    private Button grpBtn1;
    private Button grpBtn2;
    private Button grpBtn3;
    private ComboViewer grpf1comboViewer;
    private ComboViewer grpf2comboViewer;
    protected int nbBlocsParLigne = 1;
    protected int nbSousBlocsParLigne = 1;
    protected int nbPusParLigne = 1;
    private TypeSpatialisation spatialisation = TypeSpatialisation.BUREAU;
    private final int nbBlocs;

    protected AlgoDialog3F(Shell parentShell, List<Facteur> mlist, int b, boolean surfacique, TypeSpatialisation spatialisation, int nbTrait) {
        super(parentShell);
        this.setShellStyle(65648);
        this.mlist = mlist;
        this.surfacique = surfacique;
        this.spatialisation = spatialisation;
        this.nbBlocs = b;
        this.nbTraitement = nbTrait;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Mofifier les parametres de l'algorithme");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Algorithme Split Plot");
        this.setMessage("Merci de reorganiser les facteurs. Le premier facteur determine les Sous Blocs.", 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginTop = 20;
        gridLayout.marginBottom = 20;
        gridLayout.marginLeft = 20;
        gridLayout.marginRight = 20;
        container.setLayout((Layout)gridLayout);
        Group grpNbElements = new Group(container, 0);
        grpNbElements.setText("Nombre d'\u00e9l\u00e9ments");
        grpNbElements.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpNbElements.setLayout((Layout)new GridLayout(2, false));
        Label nbBlocLabel = new Label((Composite)grpNbElements, 0);
        nbBlocLabel.setText("Nombre de blocs : ");
        Text txtNbBlocs = new Text((Composite)grpNbElements, 2048);
        txtNbBlocs.setText(Integer.toString(this.nbBlocs));
        txtNbBlocs.setEnabled(false);
        Label nbPUTotal = new Label((Composite)grpNbElements, 0);
        nbPUTotal.setText("Nombre total de PU : ");
        Text txtNbPuTotal = new Text((Composite)grpNbElements, 2048);
        txtNbPuTotal.setText(Integer.toString(this.nbBlocs * this.nbTraitement));
        txtNbPuTotal.setEnabled(false);
        this.indeBtn = new Button(container, 32);
        this.indeBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.indeBtn.setText("  Facteurs ind\u00e9pendants");
        this.stackComposite = new Composite(container, 0);
        this.stackComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.indeComposite = new Composite(this.stackComposite, 0);
        this.indeComposite.setLayout((Layout)new GridLayout(2, false));
        this.stackLayout.topControl = this.indeComposite;
        Label lblFacteur = new Label(this.indeComposite, 0);
        lblFacteur.setText("Premier Facteur : ");
        this.f1comboViewer = new ComboViewer(this.indeComposite, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        gridData.widthHint = 144;
        this.f1comboViewer.getCombo().setLayoutData((Object)gridData);
        this.f1comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.f1comboViewer.setLabelProvider((IBaseLabelProvider)AdonisLabelProvider.getInstance());
        Label lblFacteurSousBloc = new Label(this.indeComposite, 0);
        lblFacteurSousBloc.setText("Deuxi\u00e8me Facteur : ");
        this.f2comboViewer = new ComboViewer(this.indeComposite, 0);
        this.f2comboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.f2comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.f2comboViewer.setLabelProvider((IBaseLabelProvider)AdonisLabelProvider.getInstance());
        Label lblFacteurPu = new Label(this.indeComposite, 0);
        lblFacteurPu.setText("Troisi\u00e8me Facteur : ");
        this.f3comboViewer = new ComboViewer(this.indeComposite, 0);
        this.f3comboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.f3comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.f3comboViewer.setLabelProvider((IBaseLabelProvider)AdonisLabelProvider.getInstance());
        this.grpComposite = new Composite(this.stackComposite, 0);
        this.grpComposite.setLayout((Layout)new GridLayout(3, false));
        Label lblGroupezDeuxDes = new Label(this.grpComposite, 0);
        lblGroupezDeuxDes.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        lblGroupezDeuxDes.setText("Groupez deux des trois facteurs ci dessous :");
        this.grpBtn1 = new Button(this.grpComposite, 32);
        this.grpBtn1.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.grpBtn2 = new Button(this.grpComposite, 32);
        this.grpBtn2.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.grpBtn3 = new Button(this.grpComposite, 32);
        this.grpBtn3.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        Label lblPremierFacteur = new Label(this.grpComposite, 0);
        lblPremierFacteur.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPremierFacteur.setText("Premier Facteur : ");
        this.grpf1comboViewer = new ComboViewer(this.grpComposite, 0);
        Combo combo = this.grpf1comboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.grpf1comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.grpf1comboViewer.setLabelProvider((IBaseLabelProvider)new GrpLabelProvider());
        Label lblSecondFacteur = new Label(this.grpComposite, 0);
        lblSecondFacteur.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSecondFacteur.setText("Deuxi\u00e8me Facteur : ");
        this.grpf2comboViewer = new ComboViewer(this.grpComposite, 0);
        Combo combo_1 = this.grpf2comboViewer.getCombo();
        combo_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.grpf2comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.grpf2comboViewer.setLabelProvider((IBaseLabelProvider)new GrpLabelProvider());
        Group grpRepartition = new Group(container, 0);
        grpRepartition.setText("R\u00e9partition par ligne");
        grpRepartition.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        grpRepartition.setLayout((Layout)new GridLayout(2, false));
        Label lblNbBlocsParLigne = new Label((Composite)grpRepartition, 0);
        lblNbBlocsParLigne.setText("Nombre de blocs par ligne pour le dispositif: ");
        final Spinner spnNbBlocsParLigne = new Spinner((Composite)grpRepartition, 2048);
        spnNbBlocsParLigne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog3F.this.nbBlocsParLigne = spnNbBlocsParLigne.getSelection();
            }
        });
        spnNbBlocsParLigne.setMinimum(1);
        spnNbBlocsParLigne.setMaximum(this.nbBlocs);
        Label lblNbSousBlocsParLigne = new Label((Composite)grpRepartition, 0);
        lblNbSousBlocsParLigne.setText("Nombre de sous-blocs par ligne pour un bloc: ");
        final Spinner spnSousBlocsParLigne = new Spinner((Composite)grpRepartition, 2048);
        spnSousBlocsParLigne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog3F.this.nbSousBlocsParLigne = spnSousBlocsParLigne.getSelection();
            }
        });
        spnSousBlocsParLigne.setMinimum(1);
        spnSousBlocsParLigne.setMaximum(1000);
        Label lblNbParcellesParLigne = new Label((Composite)grpRepartition, 0);
        lblNbParcellesParLigne.setText("Nombre de PU par ligne pour un sous-bloc: ");
        final Spinner spnNbPusParLigne = new Spinner((Composite)grpRepartition, 2048);
        spnNbPusParLigne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog3F.this.nbPusParLigne = spnNbPusParLigne.getSelection();
            }
        });
        spnNbPusParLigne.setMinimum(1);
        spnNbPusParLigne.setMaximum(1000);
        grpRepartition.setVisible(this.spatialisation == TypeSpatialisation.BUREAU);
        Group grpForm = new Group(container, 0);
        grpForm.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        if (this.surfacique) {
            grpForm.setText("Facteur de forme");
        } else {
            grpForm.setText("Facteur de forme de la PU");
        }
        grpForm.setLayout((Layout)new GridLayout(2, false));
        Label lblNbInds = new Label((Composite)grpForm, 0);
        lblNbInds.setText("Nombre d'individus par parcelle : ");
        final Spinner spnNbIndsParPU = new Spinner((Composite)grpForm, 2048);
        spnNbIndsParPU.setMinimum(1);
        spnNbIndsParPU.setMaximum(30000);
        Label lblNbIndsParLigne = new Label((Composite)grpForm, 0);
        lblNbIndsParLigne.setText("Nombre d'individus par ligne : ");
        final Spinner spnNbIndsParLigne = new Spinner((Composite)grpForm, 2048);
        spnNbIndsParLigne.setMinimum(1);
        spnNbIndsParLigne.setMaximum(30000);
        spnNbIndsParPU.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog3F.this.nbIndsParPu = spnNbIndsParPU.getSelection();
                spnNbIndsParLigne.setMaximum(AlgoDialog3F.this.nbIndsParPu);
            }
        });
        spnNbIndsParLigne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog3F.this.nbIndsParLigne = spnNbIndsParLigne.getSelection();
            }
        });
        grpForm.setVisible(!this.surfacique);
        this.addListeners();
        this.initialize();
        parent.pack();
        return container;
    }

    private void addListeners() {
        this.indeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((AlgoDialog3F)AlgoDialog3F.this).stackLayout.topControl = AlgoDialog3F.this.indeBtn.getSelection() ? AlgoDialog3F.this.indeComposite : AlgoDialog3F.this.grpComposite;
                AlgoDialog3F.this.stackComposite.layout(true);
                AlgoDialog3F.this.validate();
            }
        });
        this.f1comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AlgoDialog3F.this.indF1 = (Facteur)((StructuredSelection)event.getSelection()).getFirstElement();
                if (AlgoDialog3F.this.lock) {
                    return;
                }
                AlgoDialog3F.this.lock = true;
                if (AlgoDialog3F.this.indF1 == AlgoDialog3F.this.indF2) {
                    AlgoDialog3F.this.f2comboViewer.setSelection((ISelection)new StructuredSelection());
                }
                if (AlgoDialog3F.this.indF1 == AlgoDialog3F.this.indF3) {
                    AlgoDialog3F.this.f3comboViewer.setSelection((ISelection)new StructuredSelection());
                }
                AlgoDialog3F.this.lock = false;
                AlgoDialog3F.this.validate();
            }
        });
        this.f2comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AlgoDialog3F.this.indF2 = (Facteur)((StructuredSelection)event.getSelection()).getFirstElement();
                if (AlgoDialog3F.this.lock) {
                    return;
                }
                AlgoDialog3F.this.lock = true;
                if (AlgoDialog3F.this.indF2 == AlgoDialog3F.this.indF1) {
                    AlgoDialog3F.this.f1comboViewer.setSelection((ISelection)new StructuredSelection());
                }
                if (AlgoDialog3F.this.indF2 == AlgoDialog3F.this.indF3) {
                    AlgoDialog3F.this.f3comboViewer.setSelection((ISelection)new StructuredSelection());
                }
                AlgoDialog3F.this.lock = false;
                AlgoDialog3F.this.validate();
            }
        });
        this.f3comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AlgoDialog3F.this.indF3 = (Facteur)((StructuredSelection)event.getSelection()).getFirstElement();
                if (AlgoDialog3F.this.lock) {
                    return;
                }
                AlgoDialog3F.this.lock = true;
                if (AlgoDialog3F.this.indF3 == AlgoDialog3F.this.indF1) {
                    AlgoDialog3F.this.f1comboViewer.setSelection((ISelection)new StructuredSelection());
                }
                if (AlgoDialog3F.this.indF3 == AlgoDialog3F.this.indF2) {
                    AlgoDialog3F.this.f2comboViewer.setSelection((ISelection)new StructuredSelection());
                }
                AlgoDialog3F.this.lock = false;
                AlgoDialog3F.this.validate();
            }
        });
        this.grpBtn1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog3F.this.computeGrp();
            }
        });
        this.grpBtn2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog3F.this.computeGrp();
            }
        });
        this.grpBtn3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog3F.this.computeGrp();
            }
        });
        this.grpf1comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((StructuredSelection)AlgoDialog3F.this.grpf1comboViewer.getSelection()).getFirstElement();
                if (selection == null) {
                    AlgoDialog3F.this.grpF1 = null;
                    AlgoDialog3F.this.grpF2 = null;
                } else {
                    Object[] input;
                    AlgoDialog3F.this.grpF1 = selection;
                    if (AlgoDialog3F.this.lock) {
                        return;
                    }
                    Object[] objectArray = input = (Object[])AlgoDialog3F.this.grpf2comboViewer.getInput();
                    int n = input.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element != selection) {
                            AlgoDialog3F.this.lock = true;
                            AlgoDialog3F.this.grpf2comboViewer.setSelection((ISelection)new StructuredSelection(element));
                            AlgoDialog3F.this.lock = false;
                            break;
                        }
                        ++n2;
                    }
                    AlgoDialog3F.this.validate();
                }
            }
        });
        this.grpf2comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((StructuredSelection)AlgoDialog3F.this.grpf2comboViewer.getSelection()).getFirstElement();
                if (selection == null) {
                    AlgoDialog3F.this.grpF1 = null;
                    AlgoDialog3F.this.grpF2 = null;
                } else {
                    Object[] input;
                    AlgoDialog3F.this.grpF2 = selection;
                    if (AlgoDialog3F.this.lock) {
                        return;
                    }
                    Object[] objectArray = input = (Object[])AlgoDialog3F.this.grpf1comboViewer.getInput();
                    int n = input.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element != selection) {
                            AlgoDialog3F.this.lock = true;
                            AlgoDialog3F.this.grpf1comboViewer.setSelection((ISelection)new StructuredSelection(element));
                            AlgoDialog3F.this.lock = false;
                            break;
                        }
                        ++n2;
                    }
                    AlgoDialog3F.this.validate();
                }
            }
        });
    }

    private void computeGrp() {
        if (this.grpBtn1.getSelection() && this.grpBtn2.getSelection() && !this.grpBtn3.getSelection()) {
            ArrayList<Facteur> groupe = new ArrayList<Facteur>();
            groupe.add(this.mlist.get(0));
            groupe.add(this.mlist.get(1));
            this.grpf1comboViewer.setInput((Object)new Object[]{groupe, this.mlist.get(2)});
            this.grpf2comboViewer.setInput((Object)new Object[]{groupe, this.mlist.get(2)});
            this.grpf1comboViewer.setSelection((ISelection)new StructuredSelection());
            this.grpf2comboViewer.setSelection((ISelection)new StructuredSelection());
        } else if (this.grpBtn1.getSelection() && !this.grpBtn2.getSelection() && this.grpBtn3.getSelection()) {
            ArrayList<Facteur> groupe = new ArrayList<Facteur>();
            groupe.add(this.mlist.get(0));
            groupe.add(this.mlist.get(2));
            this.grpf1comboViewer.setInput((Object)new Object[]{groupe, this.mlist.get(1)});
            this.grpf2comboViewer.setInput((Object)new Object[]{groupe, this.mlist.get(1)});
            this.grpf1comboViewer.setSelection((ISelection)new StructuredSelection());
            this.grpf2comboViewer.setSelection((ISelection)new StructuredSelection());
        } else if (!this.grpBtn1.getSelection() && this.grpBtn2.getSelection() && this.grpBtn3.getSelection()) {
            ArrayList<Facteur> groupe = new ArrayList<Facteur>();
            groupe.add(this.mlist.get(1));
            groupe.add(this.mlist.get(2));
            this.grpf1comboViewer.setInput((Object)new Object[]{groupe, this.mlist.get(0)});
            this.grpf2comboViewer.setInput((Object)new Object[]{groupe, this.mlist.get(0)});
            this.grpf1comboViewer.setSelection((ISelection)new StructuredSelection());
            this.grpf2comboViewer.setSelection((ISelection)new StructuredSelection());
        } else {
            this.grpf1comboViewer.setInput(null);
            this.grpf2comboViewer.setInput(null);
            this.grpf1comboViewer.setSelection((ISelection)new StructuredSelection());
            this.grpf2comboViewer.setSelection((ISelection)new StructuredSelection());
        }
        this.validate();
    }

    private void initialize() {
        this.indeBtn.setSelection(true);
        this.f1comboViewer.setInput((Object)this.mlist.toArray());
        this.f2comboViewer.setInput((Object)this.mlist.toArray());
        this.f3comboViewer.setInput((Object)this.mlist.toArray());
        this.grpBtn1.setText(this.mlist.get(0).getNom());
        this.grpBtn2.setText(this.mlist.get(1).getNom());
        this.grpBtn3.setText(this.mlist.get(2).getNom());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okBtn = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okBtn.setEnabled(false);
        this.createButton(parent, 1, "Annuler", false);
        this.validate();
    }

    private void validate() {
        if (this.okBtn == null) {
            return;
        }
        if (this.stackLayout.topControl == this.indeComposite && this.indF1 != null && this.indF2 != null && this.indF3 != null) {
            this.okBtn.setEnabled(true);
        } else if (this.stackLayout.topControl == this.grpComposite && this.grpF1 != null && this.grpF2 != null) {
            this.okBtn.setEnabled(true);
        } else {
            this.okBtn.setEnabled(false);
        }
    }

    public List<Facteur> getFacteursOrdonnes() {
        ArrayList<Facteur> result = new ArrayList<Facteur>();
        if (this.stackLayout.topControl == this.indeComposite) {
            if (this.indF1 != null) {
                result.add(this.indF1);
            }
            if (this.indF2 != null) {
                result.add(this.indF2);
            }
            if (this.indF3 != null) {
                result.add(this.indF3);
            }
        } else if (this.stackLayout.topControl == this.grpComposite) {
            if (this.grpF1 instanceof List) {
                result.addAll((List)this.grpF1);
            } else if (this.grpF1 instanceof Facteur) {
                result.add((Facteur)this.grpF1);
            }
            if (this.grpF2 instanceof List) {
                result.addAll((List)this.grpF2);
            } else if (this.grpF2 instanceof Facteur) {
                result.add((Facteur)this.grpF2);
            }
        }
        return result;
    }

    public List<Integer> getListNbModalites() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (this.stackLayout.topControl == this.indeComposite) {
            if (this.indF1 != null) {
                result.add(this.indF1.getModalites().size());
            }
            if (this.indF2 != null) {
                result.add(this.indF2.getModalites().size());
            }
            if (this.indF3 != null) {
                result.add(this.indF3.getModalites().size());
            }
        } else if (this.stackLayout.topControl == this.grpComposite) {
            int g;
            if (this.grpF1 instanceof List) {
                g = 1;
                for (Facteur f : (List)this.grpF1) {
                    g *= f.getModalites().size();
                }
                result.add(g);
            } else if (this.grpF1 instanceof Facteur) {
                result.add(((Facteur)this.grpF1).getModalites().size());
            }
            if (this.grpF2 instanceof List) {
                g = 1;
                for (Facteur f : (List)this.grpF2) {
                    g *= f.getModalites().size();
                }
                result.add(g);
            } else if (this.grpF2 instanceof Facteur) {
                result.add(((Facteur)this.grpF2).getModalites().size());
            }
        }
        return result;
    }

    public int getNbIndsParPu() {
        return this.nbIndsParPu;
    }

    public int getNbIndsParLigne() {
        return this.nbIndsParLigne;
    }

    public int getNbBlocsParLigne() {
        return this.nbBlocsParLigne;
    }

    public int getNbSousBlocsParLigne() {
        return this.nbSousBlocsParLigne;
    }

    public int getNbPusParLigne() {
        return this.nbPusParLigne;
    }

    public class GrpLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof List) {
                List list = (List)element;
                if (list.size() == 2) {
                    return String.valueOf(this.getText(list.get(0))) + " - " + this.getText(list.get(1));
                }
            } else if (element instanceof Facteur) {
                return AdonisLabelProvider.getInstance().getText(element);
            }
            return element.toString();
        }
    }
}

