/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class DataSourceMetaData
implements IDataSetMetaData {
    private DatabaseMetaData dbMetadata;
    private IConnection conn;
    private static Logger logger = Logger.getLogger(DataSourceMetaData.class.getName());

    public DataSourceMetaData(IConnection connection, DatabaseMetaData dbMeta) {
        this.dbMetadata = dbMeta;
        this.conn = connection;
    }

    public IConnection getConnection() throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "getConnection", "DataSourceMetaData.getConnection( )");
        return this.conn;
    }

    public IResultSet getDataSourceObjects(String catalog, String schema, String object, String version) throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "getDataSourceObjects", "DataSourceMetaData.getDataSourceObjects( )");
        return null;
    }

    public int getDataSourceMajorVersion() throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "getDataSourceMajorVersion", "DataSourceMetaData.getDataSourceMajorVersion( )");
        try {
            return this.dbMetadata.getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetDatabaseMajorVersion", e);
        }
    }

    public int getDataSourceMinorVersion() throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "getDataSourceMinorVersion", "DataSourceMetaData.getDataSourceMinorVersion( )");
        try {
            return this.dbMetadata.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetDatabaseMinorVersion", e);
        }
    }

    public String getDataSourceProductName() throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "getDataSourceProductName", "DataSourceMetaData.getDataSourceProductName( )");
        try {
            return this.dbMetadata.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetDataSourceProductName", e);
        }
    }

    public String getDataSourceProductVersion() throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "getDataSourceProductVersion", "DataSourceMetaData.getDataSourceProductVersion( )");
        try {
            return this.dbMetadata.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetDataSourceProductVersion", e);
        }
    }

    public int getSQLStateType() throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "getSQLStateType", "DataSourceMetaData.getSQLStateType( )");
        if (this.dbMetadata == null) {
            throw new JDBCException("odajdbc.driver.ConnNotOpen", 111);
        }
        try {
            if (this.dbMetadata.getSQLStateType() == 2) {
                return 1;
            }
            return 0;
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetSQLStateType", e);
        }
    }

    public boolean supportsMultipleOpenResults() throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "supportsMultipleOpenResults", "DataSourceMetaData.supportsMultipleOpenResults( )");
        return false;
    }

    public boolean supportsMultipleResultSets() throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "supportsMultipleResultSets", "DataSourceMetaData.supportsMultipleResultSets( )");
        return true;
    }

    public boolean supportsNamedResultSets() throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "supportsNamedResultSets", "DataSourceMetaData.supportsNamedResultSets( )");
        return true;
    }

    public boolean supportsNamedParameters() throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "supportsNamedParameters", "DataSourceMetaData.supportsNamedParameters( )");
        return false;
    }

    public boolean supportsInParameters() throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "supportsInParameters", "DataSourceMetaData.supportsInParameters( )");
        return true;
    }

    public boolean supportsOutParameters() throws OdaException {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "supportsOutParameters", "DataSourceMetaData.supportsOutParameters( )");
        return true;
    }

    public int getSortMode() {
        logger.logp(Level.FINE, DataSourceMetaData.class.getName(), "getSortMode", "DataSourceMetaData.getSortMode( )");
        return 0;
    }
}

