/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class RecentWorkspacesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int MIN_WORKSPACS = 5;
    private static final int MAX_WORKSPACES = 99;
    private static final int MAX_WORKSPACES_DIGIT_COUNT = 2;
    private ChooseWorkspaceData workspacesData;
    private Button promptOption;
    private Spinner maxWorkspacesField;
    private List workspacesList;
    private Button removeButton;

    public void init(IWorkbench workbench) {
        this.workspacesData = new ChooseWorkspaceData(Platform.getInstanceLocation().getURL());
    }

    public Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.workspaces_preference_page_context");
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        container.setLayout((Layout)gridLayout);
        this.createPromptOption(container);
        this.createMaxWorkspacesField(container);
        this.createWorkspacesList(container);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    protected void createPromptOption(Composite parent) {
        this.promptOption = new Button(parent, 32);
        this.promptOption.setText(IDEWorkbenchMessages.RecentWorkspacesPreferencePage_PromptAtStartup_label);
        this.promptOption.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.promptOption.setSelection(this.workspacesData.getShowDialog());
        this.promptOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RecentWorkspacesPreferencePage.this.workspacesData.toggleShowDialog();
            }
        });
    }

    protected void createMaxWorkspacesField(Composite parent) {
        Label maxWorkspacesLabel = new Label(parent, 0);
        maxWorkspacesLabel.setText(IDEWorkbenchMessages.RecentWorkspacesPreferencePage_NumberOfWorkspaces_label);
        this.maxWorkspacesField = new Spinner(parent, 2048);
        this.maxWorkspacesField.setTextLimit(2);
        this.maxWorkspacesField.setMinimum(5);
        this.maxWorkspacesField.setMaximum(99);
        this.maxWorkspacesField.setSelection(this.workspacesData.getRecentWorkspaces().length);
    }

    protected void createWorkspacesList(Composite parent) {
        Group recentWorkspacesGroup = new Group(parent, 0);
        recentWorkspacesGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        recentWorkspacesGroup.setText(IDEWorkbenchMessages.RecentWorkspacesPreferencePage_RecentWorkspacesList_label);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        recentWorkspacesGroup.setLayout((Layout)gridLayout_1);
        this.workspacesList = new List((Composite)recentWorkspacesGroup, 2050);
        GridData gd_workspacesList = new GridData(4, 4, true, true);
        this.workspacesList.setLayoutData((Object)gd_workspacesList);
        this.removeButton = new Button((Composite)recentWorkspacesGroup, 0);
        GridData gd_removeButton = new GridData(0x1000000, 128, false, false);
        this.removeButton.setLayoutData((Object)gd_removeButton);
        this.removeButton.setText(IDEWorkbenchMessages.RecentWorkspacesPreferencePage_RemoveButton_label);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RecentWorkspacesPreferencePage.this.removeSelectedWorkspaces();
                RecentWorkspacesPreferencePage.this.updateRemoveButton();
            }
        });
        this.workspacesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RecentWorkspacesPreferencePage.this.updateRemoveButton();
            }
        });
        String[] recentWorkspaces = this.workspacesData.getRecentWorkspaces();
        int i = 0;
        while (i < recentWorkspaces.length) {
            String aWorkspace = recentWorkspaces[i];
            if (aWorkspace != null) {
                this.workspacesList.add(aWorkspace);
            }
            ++i;
        }
    }

    protected void removeSelectedWorkspaces() {
        int[] selected = this.workspacesList.getSelectionIndices();
        ArrayList<String> workspaces = new ArrayList<String>(Arrays.asList(this.workspacesList.getItems()));
        int i = selected.length - 1;
        while (i >= 0) {
            workspaces.remove(selected[i]);
            --i;
        }
        String[] newItems = new String[workspaces.size()];
        workspaces.toArray(newItems);
        this.workspacesList.setItems(newItems);
    }

    protected void performDefaults() {
        this.promptOption.setSelection(true);
        super.performDefaults();
    }

    public boolean performOk() {
        int maxWorkspaces = this.maxWorkspacesField.getSelection();
        String[] workspaces = new String[maxWorkspaces];
        String[] listItems = this.workspacesList.getItems();
        if (maxWorkspaces < listItems.length) {
            System.arraycopy(listItems, 0, workspaces, 0, maxWorkspaces);
        } else {
            System.arraycopy(listItems, 0, workspaces, 0, listItems.length);
        }
        this.workspacesData.setRecentWorkspaces(workspaces);
        this.workspacesData.writePersistedData();
        return true;
    }

    protected void updateRemoveButton() {
        this.removeButton.setEnabled(this.workspacesList.getSelectionCount() > 0);
    }
}

