/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.cache.Cacheable;
import org.eclipse.birt.core.archive.cache.FileCacheManager;

public class SystemCacheManager {
    protected static Logger logger = Logger.getLogger(SystemCacheManager.class.getName());
    protected boolean enableSystemCache;
    protected int maxCacheSize = 0;
    protected int systemCacheSize = 0;
    protected int usedCacheSize = 0;
    protected Map<FileCacheManager, Map<Object, CacheEntry>> cachedFiles = new HashMap<FileCacheManager, Map<Object, CacheEntry>>();
    protected CacheEntry firstEntry = new CacheEntry();
    protected CacheEntry lastEntry;

    public SystemCacheManager() {
        this.firstEntry.next = this.lastEntry = new CacheEntry();
        this.lastEntry.prev = this.firstEntry;
    }

    public void clearCaches(FileCacheManager manager) {
        Map<Object, CacheEntry> caches = this.cachedFiles.remove(manager);
        if (caches != null) {
            Collection<CacheEntry> entries = caches.values();
            for (CacheEntry entry : entries) {
                entry.prev.next = entry.next;
                entry.next.prev = entry.prev;
            }
            this.systemCacheSize -= caches.size();
            caches.clear();
        }
    }

    public void setMaxCacheSize(int size) {
        this.maxCacheSize = size;
    }

    public void increaseUsedCacheSize(int size) {
        this.usedCacheSize += size;
    }

    public int getUsedCacheSize() {
        return this.usedCacheSize;
    }

    public void enableSystemCache(boolean enableSystemCache) {
        this.enableSystemCache = enableSystemCache;
        if (!enableSystemCache) {
            this.systemCacheSize = 0;
            this.cachedFiles.clear();
            this.firstEntry.next = this.lastEntry;
            this.lastEntry.prev = this.firstEntry;
        }
    }

    public Cacheable getCache(FileCacheManager file, Object key) {
        CacheEntry entry;
        if (!this.enableSystemCache) {
            return null;
        }
        Map<Object, CacheEntry> caches = this.cachedFiles.get(file);
        if (caches != null && (entry = caches.remove(key)) != null) {
            entry.prev.next = entry.next;
            entry.next.prev = entry.prev;
            --this.systemCacheSize;
            return entry.value;
        }
        return null;
    }

    private void removeCaches(int size) {
        int i = 0;
        while (i < size) {
            CacheEntry removedEntry = this.lastEntry.prev;
            assert (removedEntry != this.firstEntry);
            removedEntry.prev.next = removedEntry.next;
            removedEntry.next.prev = removedEntry.prev;
            Map<Object, CacheEntry> caches = this.cachedFiles.get(removedEntry.file);
            assert (caches != null);
            caches.remove(removedEntry.value.getCacheKey());
            ++i;
        }
        this.systemCacheSize -= size;
    }

    public void addCaches(FileCacheManager file, Cacheable[] caches) {
        Map<Object, CacheEntry> fileCaches;
        int removeCacheSize;
        if (!this.enableSystemCache) {
            return;
        }
        int cacheSize = caches.length;
        int maxFreeCacheSize = this.maxCacheSize - this.usedCacheSize;
        if (cacheSize > maxFreeCacheSize) {
            cacheSize = maxFreeCacheSize;
        }
        if ((removeCacheSize = cacheSize + this.systemCacheSize - maxFreeCacheSize) > 0) {
            this.removeCaches(removeCacheSize);
        }
        if ((fileCaches = this.cachedFiles.get(file)) == null) {
            fileCaches = new HashMap<Object, CacheEntry>();
            this.cachedFiles.put(file, fileCaches);
        }
        int offset = caches.length - cacheSize;
        int i = 0;
        while (i < cacheSize) {
            Cacheable cache = caches[offset + i];
            CacheEntry entry = new CacheEntry(file, cache);
            fileCaches.put(cache.getCacheKey(), entry);
            entry.next = this.firstEntry.next;
            this.firstEntry.next.prev = entry;
            entry.prev = this.firstEntry;
            this.firstEntry.next = entry;
            ++i;
        }
        this.systemCacheSize += cacheSize;
    }

    public void addCache(FileCacheManager catalog, Cacheable block) {
        this.addCaches(catalog, new Cacheable[]{block});
    }

    private static class CacheEntry {
        FileCacheManager file;
        Cacheable value;
        CacheEntry prev;
        CacheEntry next;

        CacheEntry() {
        }

        CacheEntry(FileCacheManager catalog, Cacheable value) {
            this.file = catalog;
            this.value = value;
        }
    }
}

