/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.eclipse;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.IPlatform;
import org.eclipse.birt.core.framework.IPlatformPath;
import org.eclipse.birt.core.framework.eclipse.EclipseBundle;
import org.eclipse.birt.core.framework.eclipse.EclipseConfigurationElement;
import org.eclipse.birt.core.framework.eclipse.EclipseExtension;
import org.eclipse.birt.core.framework.eclipse.EclipseExtensionPoint;
import org.eclipse.birt.core.framework.eclipse.EclipseExtensionRegistry;
import org.eclipse.birt.core.framework.eclipse.EclipsePath;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class EclipsePlatform
implements IPlatform {
    protected static Logger logger = Logger.getLogger(IPlatform.class.getName());
    BundleContext context;
    static StreamHandler tracingHandler;

    public EclipsePlatform(BundleContext context) {
        this.context = context;
    }

    public IExtensionRegistry getExtensionRegistry() {
        return new EclipseExtensionRegistry(Platform.getExtensionRegistry());
    }

    public IBundle getBundle(String symbolicName) {
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle != null) {
            return new EclipseBundle(bundle);
        }
        return null;
    }

    public URL find(IBundle bundle, IPlatformPath path) {
        if (bundle instanceof EclipseBundle && path instanceof EclipsePath) {
            return FileLocator.find((Bundle)((EclipseBundle)bundle).bundle, (IPath)((EclipsePath)path).path, null);
        }
        return null;
    }

    public URL asLocalURL(URL url) throws IOException {
        return FileLocator.toFileURL((URL)url);
    }

    static IConfigurationElement wrap(org.eclipse.core.runtime.IConfigurationElement object) {
        if (object != null) {
            return new EclipseConfigurationElement(object);
        }
        return null;
    }

    static IConfigurationElement[] wrap(org.eclipse.core.runtime.IConfigurationElement[] objects) {
        if (objects == null) {
            return new IConfigurationElement[0];
        }
        IConfigurationElement[] wraps = new IConfigurationElement[objects.length];
        int i = 0;
        while (i < objects.length) {
            wraps[i] = new EclipseConfigurationElement(objects[i]);
            ++i;
        }
        return wraps;
    }

    static IExtensionPoint wrap(org.eclipse.core.runtime.IExtensionPoint object) {
        if (object != null) {
            return new EclipseExtensionPoint(object);
        }
        return null;
    }

    static IExtensionPoint[] wrap(org.eclipse.core.runtime.IExtensionPoint[] objects) {
        if (objects == null) {
            return new IExtensionPoint[0];
        }
        IExtensionPoint[] wraps = new IExtensionPoint[objects.length];
        int i = 0;
        while (i < objects.length) {
            wraps[i] = new EclipseExtensionPoint(objects[i]);
            ++i;
        }
        return wraps;
    }

    static IExtension wrap(org.eclipse.core.runtime.IExtension object) {
        if (object != null) {
            return new EclipseExtension(object);
        }
        return null;
    }

    static IExtension[] wrap(org.eclipse.core.runtime.IExtension[] objects) {
        if (objects == null) {
            return new IExtension[0];
        }
        IExtension[] wraps = new IExtension[objects.length];
        int i = 0;
        while (i < objects.length) {
            wraps[i] = new EclipseExtension(objects[i]);
            ++i;
        }
        return wraps;
    }

    static Object wrap(Object object) {
        if (object instanceof org.eclipse.core.runtime.IConfigurationElement) {
            return EclipsePlatform.wrap((org.eclipse.core.runtime.IConfigurationElement)object);
        }
        if (object instanceof org.eclipse.core.runtime.IExtension) {
            return EclipsePlatform.wrap((org.eclipse.core.runtime.IExtension)object);
        }
        if (object instanceof org.eclipse.core.runtime.IExtensionPoint) {
            return EclipsePlatform.wrap((org.eclipse.core.runtime.IExtensionPoint)object);
        }
        return object;
    }

    public String getDebugOption(String option) {
        return Platform.getDebugOption((String)option);
    }

    public void initializeTracing(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        String debugFlag = String.valueOf(pluginId) + "/debug";
        if (bundle != null) {
            try {
                URL optionUrl = bundle.getEntry(".options");
                InputStream in = optionUrl.openStream();
                if (in != null) {
                    Properties options = new Properties();
                    options.load(in);
                    for (Map.Entry<Object, Object> entry : options.entrySet()) {
                        String option = (String)entry.getKey();
                        if (debugFlag.equals(option)) continue;
                        String value = Platform.getDebugOption((String)option);
                        EclipsePlatform.setupLogger(option, value);
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static void setupLogger(String option, String value) {
        if ("true".equals(value)) {
            Level level = EclipsePlatform.getLoggerLevel(option);
            String loggerName = EclipsePlatform.getLoggerName(option);
            Logger logger = Logger.getLogger(loggerName);
            logger.addHandler(EclipsePlatform.getTracingHandler());
            logger.setLevel(level);
        }
    }

    protected static Level getLoggerLevel(String option) {
        assert (option != null);
        if (option.endsWith(".finer")) {
            return Level.FINER;
        }
        if (option.endsWith(".finest")) {
            return Level.FINEST;
        }
        return Level.FINE;
    }

    protected static String getLoggerName(String option) {
        assert (option != null);
        if (option.endsWith(".fine")) {
            option = option.substring(0, option.length() - 5);
        } else if (option.endsWith("finer")) {
            option = option.substring(0, option.length() - 6);
        } else if (option.endsWith(".finest")) {
            option = option.substring(0, option.length() - 7);
        }
        return option.replace('/', '.').trim();
    }

    static StreamHandler getTracingHandler() {
        if (tracingHandler == null) {
            tracingHandler = new StreamHandler(System.out, new SimpleFormatter());
            tracingHandler.setLevel(Level.ALL);
        }
        return tracingHandler;
    }

    public Object createFactoryObject(String extensionId) {
        try {
            IConfigurationElement[] configs;
            IExtensionRegistry registry = this.getExtensionRegistry();
            IExtension factoryExt = registry.getExtension("org.eclipse.birt.core", "FactoryService", extensionId);
            if (factoryExt != null && (configs = factoryExt.getConfigurationElements()) != null && configs.length > 0) {
                IConfigurationElement config = configs[0];
                Object factory = config.createExecutableExtension("class");
                return factory;
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        return null;
    }
}

