/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.visualisation.notes;

import fr.inra.adonis.core.indexer.AdonisIndexer;
import fr.inra.adonis.core.rcp.AdonisLabelProvider;
import fr.inra.adonis.core.util.ui.NoteDetailsDialog;
import fr.inra.adonis.modeleMetier.conceptsDeBase.Note;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.TypeUniteParcours;
import fr.inra.adonis.modeleMetier.projetDeSaisie.variables.Variable;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariable;
import fr.inra.adonis.visualisation.notes.NotesUtil;
import fr.inra.adonis.visualisation.notes.WrapperColonne;
import fr.inra.adonis.visualisation.notes.WrapperNotes;
import fr.inra.adonis.visualisation.notes.WrapperNotesLabelProvider;
import fr.inra.adonis.visualisation.notes.filters.BlocViewerFilter;
import fr.inra.adonis.visualisation.notes.filters.CombosFilterComponent;
import fr.inra.adonis.visualisation.notes.filters.CompositeFilterComponent;
import fr.inra.adonis.visualisation.notes.filters.DispositifViewerFilter;
import fr.inra.adonis.visualisation.notes.filters.IndividuNumViewerFilter;
import fr.inra.adonis.visualisation.notes.filters.LineViewerFilter;
import fr.inra.adonis.visualisation.notes.filters.ParcelleViewerFilter;
import fr.inra.adonis.visualisation.notes.filters.SelectersComponent;
import fr.inra.adonis.visualisation.notes.filters.SousBlocViewerFilter;
import fr.inra.adonis.visualisation.notes.filters.XViewerFilter;
import fr.inra.adonis.visualisation.notes.filters.YViewerFilter;
import fr.inra.adonis.visualisation.notes.sorter.wrappersorter.AbstractComparator;
import fr.inra.adonis.visualisation.notes.sorter.wrappersorter.BlocIntegerSorter;
import fr.inra.adonis.visualisation.notes.sorter.wrappersorter.DispositifStringSorter;
import fr.inra.adonis.visualisation.notes.sorter.wrappersorter.IDRfidCodebarreSorter;
import fr.inra.adonis.visualisation.notes.sorter.wrappersorter.IndividuIntegerSorter;
import fr.inra.adonis.visualisation.notes.sorter.wrappersorter.ObjetMetierComparator;
import fr.inra.adonis.visualisation.notes.sorter.wrappersorter.PUIntegerSorter;
import fr.inra.adonis.visualisation.notes.sorter.wrappersorter.SortEnum;
import fr.inra.adonis.visualisation.notes.sorter.wrappersorter.SousBlocIntegerSorter;
import fr.inra.adonis.visualisation.notes.sorter.wrappersorter.XIntegerSorter;
import fr.inra.adonis.visualisation.notes.sorter.wrappersorter.YIntegerSorter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.editor.FormPage;

public class VisualisationNotesComponent
extends CompositeFilterComponent {
    private final HashMap<Integer, WrapperColonne> mapIdxColonne = new HashMap();
    private final TableViewer tableViewer;
    private AdonisIndexer bagObjetIndexe;
    private Set<ObjetMetier> objetsMetiers;
    private HashMap<ObjetMetier, HashMap<Variable, List<MesureVariable>>> mapObjetMetierVarMesurVar;
    private List<ObjetMetier> objetsMetierParcourus;
    private TypeUniteParcours uniteParcoursCourant;
    private FormPage formPage;
    private final PUIntegerSorter puIntegerSorter = new PUIntegerSorter();
    private final BlocIntegerSorter blocIntegerSorter = new BlocIntegerSorter();
    private final SousBlocIntegerSorter sbIntegerSorter = new SousBlocIntegerSorter();
    private final XIntegerSorter xIntegerSorter = new XIntegerSorter();
    private final YIntegerSorter yIntegerSorter = new YIntegerSorter();
    private final IndividuIntegerSorter individuIntegerSorter = new IndividuIntegerSorter();
    private final DispositifStringSorter dispoStringSorter = new DispositifStringSorter();
    private final IDRfidCodebarreSorter idRfidCodebarreStringSorter = new IDRfidCodebarreSorter();
    private final LineViewerFilter lineFilter;
    private TableColumn tableColumnY;
    private TableColumn tableColumnX;
    private TableColumn tableColumnNumero;
    private TableColumn tableColumnPU;
    private TableColumn tableColumnType;
    private TableColumn tableColumnSousBloc;
    private TableColumn tableColumnBloc;
    private TableColumn tableColumnDispo;
    private TableColumn tableColumnIdRfidCodebarre;
    private boolean puSurfacique;
    private final SelectersComponent selectComponent;
    private final CombosFilterComponent filterComponent;
    private WrapperNotesLabelProvider wrapperLabelProvider;

    public VisualisationNotesComponent(Composite parent, int style, Set<ObjetMetier> listObjets, AdonisIndexer indexer, boolean cfu1, boolean modeExport, boolean editionMode) {
        super(parent, style);
        this.objetsMetiers = listObjets;
        HashSet<Dispositif> dispositifs = new HashSet<Dispositif>();
        for (ObjetMetier obj : this.objetsMetiers) {
            if (!(obj instanceof Dispositif)) continue;
            dispositifs.add((Dispositif)obj);
        }
        this.puSurfacique = false;
        for (Dispositif dispo : dispositifs) {
            if (!dispo.isPuSurfacique()) continue;
            this.puSurfacique = true;
            break;
        }
        this.bagObjetIndexe = indexer == null ? new AdonisIndexer(new ArrayList(dispositifs)) : indexer;
        this.setLayout((Layout)new GridLayout(1, false));
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this.setBackgroundMode(2);
        this.filterComponent = new CombosFilterComponent(this, this, 0, this.bagObjetIndexe, false, !this.puSurfacique);
        this.filterComponent.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.selectComponent = new SelectersComponent(this, this, 0);
        this.selectComponent.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        final Menu headerMenu = new Menu((Control)this);
        this.tableViewer = new TableViewer((Composite)this, 67584);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.setTableProperties();
        int idx = this.createStaticColonnes();
        idx = this.createNotesColonnes(headerMenu, idx);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.wrapperLabelProvider = new WrapperNotesLabelProvider(this);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.wrapperLabelProvider);
        DispositifViewerFilter dispositifFilter = new DispositifViewerFilter(this.filterComponent.getComboDispositifViewer());
        BlocViewerFilter blocFilter = new BlocViewerFilter(this.filterComponent.getComboBlocViewer());
        SousBlocViewerFilter sousBlocFilter = new SousBlocViewerFilter(this.filterComponent.getComboSousBlocViewer());
        ParcelleViewerFilter parcelleUnitaireFilter = new ParcelleViewerFilter(this.filterComponent.getComboPUViewer());
        IndividuNumViewerFilter individuFilter = new IndividuNumViewerFilter(this.filterComponent.getComboNumIndividuViewer());
        XViewerFilter xFilter = new XViewerFilter(this.filterComponent.getComboXViewer());
        YViewerFilter yFilter = new YViewerFilter(this.filterComponent.getComboYViewer());
        this.lineFilter = new LineViewerFilter();
        this.lineFilter.setTab(this);
        this.tableViewer.setComparator((ViewerComparator)new ObjetMetierComparator());
        this.tableViewer.setFilters(new ViewerFilter[]{dispositifFilter, blocFilter, sousBlocFilter, parcelleUnitaireFilter, individuFilter, xFilter, yFilter, this.lineFilter});
        table.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                VisualisationNotesComponent.this.tableViewer.getTable().setMenu(headerMenu);
            }
        });
        this.tableViewer.getTable().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                WrapperColonne wcol;
                Point pt = new Point(event.x, event.y);
                ViewerCell cell = VisualisationNotesComponent.this.tableViewer.getCell(pt);
                if (cell != null && (wcol = (WrapperColonne)VisualisationNotesComponent.this.mapIdxColonne.get(cell.getColumnIndex())) != null && wcol.isNotes()) {
                    WrapperNotes wrapper = (WrapperNotes)cell.getElement();
                    Note noteAAficher = null;
                    HashSet<Note> notesDisponibles = new HashSet<Note>();
                    for (Note note : wrapper.getNotes()) {
                        if (note.isSupprime()) continue;
                        notesDisponibles.add(note);
                    }
                    if (notesDisponibles.size() > 1) {
                        ElementListSelectionDialog dialog = new ElementListSelectionDialog(VisualisationNotesComponent.this.getShell(), (ILabelProvider)AdonisLabelProvider.getInstance());
                        dialog.setTitle("Notes");
                        dialog.setMessage("Notes associ\u00e9es \u00e0 l'objet");
                        dialog.setMultipleSelection(false);
                        dialog.setElements(notesDisponibles.toArray());
                        if (dialog.open() == 0) {
                            noteAAficher = (Note)dialog.getResult()[0];
                        }
                    } else if (notesDisponibles.size() == 1) {
                        noteAAficher = wrapper.getNotes().iterator().next();
                    }
                    if (noteAAficher != null) {
                        new NoteDetailsDialog(VisualisationNotesComponent.this.getShell(), noteAAficher, VisualisationNotesComponent.this.tableViewer).open();
                    }
                }
            }
        });
        this.refreshContent();
    }

    public void refreshContent() {
        this.tableViewer.setInput(NotesUtil.getInputForTabulaireMode(this.objetsMetiers, this.objetsMetierParcourus, this.uniteParcoursCourant));
        this.tableViewer.refresh();
        if (this.formPage != null) {
            this.formPage.getManagedForm().reflow(true);
        }
    }

    private void setTableProperties() {
        this.tableViewer.getTable().setHeaderVisible(true);
    }

    private int createStaticColonnes() {
        int idx = 0;
        TableViewerColumn tableViewerColumnType = new TableViewerColumn(this.tableViewer, 0);
        this.tableColumnType = tableViewerColumnType.getColumn();
        this.tableColumnType.setWidth(120);
        this.tableColumnType.setText("Type");
        this.mapIdxColonne.put(idx++, WrapperColonne.createColStatic(WrapperColonne.StaticColonne.T));
        TableViewerColumn tableViewerColumnDispo = new TableViewerColumn(this.tableViewer, 0);
        this.tableColumnDispo = tableViewerColumnDispo.getColumn();
        this.tableColumnDispo.setWidth(100);
        this.tableColumnDispo.setText("Dispositif");
        this.mapIdxColonne.put(idx++, WrapperColonne.createColStatic(WrapperColonne.StaticColonne.D));
        TableViewerColumn tableViewerColumnBloc = new TableViewerColumn(this.tableViewer, 0);
        this.tableColumnBloc = tableViewerColumnBloc.getColumn();
        this.tableColumnBloc.setWidth(80);
        this.tableColumnBloc.setText("Bloc");
        this.mapIdxColonne.put(idx++, WrapperColonne.createColStatic(WrapperColonne.StaticColonne.B));
        if (this.bagObjetIndexe.getSetSousBloc().size() > 0) {
            TableViewerColumn tableViewerColumnSousBloc = new TableViewerColumn(this.tableViewer, 0);
            this.tableColumnSousBloc = tableViewerColumnSousBloc.getColumn();
            this.tableColumnSousBloc.setWidth(80);
            this.tableColumnSousBloc.setText("Sous Bloc");
            this.mapIdxColonne.put(idx++, WrapperColonne.createColStatic(WrapperColonne.StaticColonne.SB));
        }
        TableViewerColumn tableViewerColumnPU = new TableViewerColumn(this.tableViewer, 0);
        this.tableColumnPU = tableViewerColumnPU.getColumn();
        this.tableColumnPU.setWidth(80);
        this.tableColumnPU.setText("Parcelle Unitaire");
        this.mapIdxColonne.put(idx++, WrapperColonne.createColStatic(WrapperColonne.StaticColonne.PU));
        if (!this.puSurfacique) {
            TableViewerColumn tableViewerColumnNumero = new TableViewerColumn(this.tableViewer, 0);
            this.tableColumnNumero = tableViewerColumnNumero.getColumn();
            this.tableColumnNumero.setWidth(50);
            this.tableColumnNumero.setText("Ind");
            this.mapIdxColonne.put(idx++, WrapperColonne.createColStatic(WrapperColonne.StaticColonne.NUMERO));
        }
        TableViewerColumn tableViewerColumnX = new TableViewerColumn(this.tableViewer, 0);
        this.tableColumnX = tableViewerColumnX.getColumn();
        this.tableColumnX.setWidth(50);
        this.tableColumnX.setText("X");
        this.mapIdxColonne.put(idx++, WrapperColonne.createColStatic(WrapperColonne.StaticColonne.X));
        TableViewerColumn tableViewerColumnY = new TableViewerColumn(this.tableViewer, 0);
        this.tableColumnY = tableViewerColumnY.getColumn();
        this.tableColumnY.setWidth(50);
        this.tableColumnY.setText("Y");
        this.mapIdxColonne.put(idx++, WrapperColonne.createColStatic(WrapperColonne.StaticColonne.Y));
        TableViewerColumn tableViewerIdCodebarre = new TableViewerColumn(this.tableViewer, 0);
        this.tableColumnIdRfidCodebarre = tableViewerIdCodebarre.getColumn();
        this.tableColumnIdRfidCodebarre.setWidth(50);
        this.tableColumnIdRfidCodebarre.setText("ID");
        this.mapIdxColonne.put(idx++, WrapperColonne.createColStatic(WrapperColonne.StaticColonne.ID));
        this.initSorter();
        return idx;
    }

    private void initSorter() {
        this.tableColumnDispo.addSelectionListener((SelectionListener)new HeaderSorterSelection(this.dispoStringSorter, this.tableColumnDispo));
        this.tableColumnBloc.addSelectionListener((SelectionListener)new HeaderSorterSelection(this.blocIntegerSorter, this.tableColumnBloc));
        if (this.tableColumnSousBloc != null) {
            this.tableColumnSousBloc.addSelectionListener((SelectionListener)new HeaderSorterSelection(this.sbIntegerSorter, this.tableColumnSousBloc));
        }
        this.tableColumnPU.addSelectionListener((SelectionListener)new HeaderSorterSelection(this.puIntegerSorter, this.tableColumnPU));
        this.tableColumnX.addSelectionListener((SelectionListener)new HeaderSorterSelection(this.xIntegerSorter, this.tableColumnX));
        this.tableColumnY.addSelectionListener((SelectionListener)new HeaderSorterSelection(this.yIntegerSorter, this.tableColumnY));
        this.tableColumnIdRfidCodebarre.addSelectionListener((SelectionListener)new HeaderSorterSelection(this.idRfidCodebarreStringSorter, this.tableColumnIdRfidCodebarre));
        if (this.tableColumnNumero != null) {
            this.tableColumnNumero.addSelectionListener((SelectionListener)new HeaderSorterSelection(this.individuIntegerSorter, this.tableColumnNumero));
        }
    }

    private int createNotesColonnes(Menu headerMenu, int idx) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setWidth(50);
        tableColumn.setText("Notes");
        this.mapIdxColonne.put(idx++, WrapperColonne.createColNotes());
        this.createMenuItem(headerMenu, tableViewerColumn.getColumn());
        return idx;
    }

    private void createMenuItem(Menu parent, final TableColumn column) {
        final MenuItem itemName = new MenuItem(parent, 32);
        itemName.setText(column.getText());
        itemName.setSelection(column.getResizable());
        itemName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (itemName.getSelection() && column.getWidth() == 0) {
                    column.setWidth(80);
                    column.setResizable(true);
                } else {
                    column.setWidth(0);
                    column.setResizable(false);
                }
            }
        });
        parent.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                if (itemName.getSelection() && column.getWidth() == 0) {
                    itemName.setSelection(false);
                } else if (!itemName.getSelection() && column.getWidth() > 0) {
                    itemName.setSelection(true);
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }

    @Override
    public void refreshTable() {
        this.tableViewer.refresh();
    }

    public void setFormPage(FormPage formPage) {
        this.formPage = formPage;
    }

    public HashMap<Integer, WrapperColonne> getMapIdxColonne() {
        return this.mapIdxColonne;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public AdonisIndexer getBagObjetIndexe() {
        return this.bagObjetIndexe;
    }

    public HashMap<ObjetMetier, HashMap<Variable, List<MesureVariable>>> getMapObjetMetierVarMesurVar() {
        return this.mapObjetMetierVarMesurVar;
    }

    public void setMapObjetMetierVarMesurVar(HashMap<ObjetMetier, HashMap<Variable, List<MesureVariable>>> mapObjetMetierVarMesurVar) {
        this.mapObjetMetierVarMesurVar = mapObjetMetierVarMesurVar;
    }

    public ViewerFilter getLineFilter() {
        return this.lineFilter;
    }

    public WrapperNotesLabelProvider getWrapperLabelProvider() {
        return this.wrapperLabelProvider;
    }

    public void setWrapperLabelProvider(WrapperNotesLabelProvider wrapperLabelProvider) {
        this.wrapperLabelProvider = wrapperLabelProvider;
    }

    public Set<ObjetMetier> getObjetsMetiers() {
        return this.objetsMetiers;
    }

    public void setObjetsMetierParcourus(List<ObjetMetier> objetsMetierParcourus) {
        this.objetsMetierParcourus = objetsMetierParcourus;
    }

    public void setUniteParcoursCourant(TypeUniteParcours uniteParcoursCourant) {
        this.uniteParcoursCourant = uniteParcoursCourant;
    }

    public TypeUniteParcours getUniteParcoursCourant() {
        return this.uniteParcoursCourant;
    }

    private final class HeaderSorterSelection
    extends SelectionAdapter {
        private final AbstractComparator sorter;
        private final TableColumn col;

        public HeaderSorterSelection(AbstractComparator sorter, TableColumn col) {
            this.sorter = sorter;
            this.col = col;
        }

        public void widgetSelected(SelectionEvent e) {
            VisualisationNotesComponent.this.tableViewer.setComparator(null);
            if (this.sorter.getSensTri() != SortEnum.NONE) {
                VisualisationNotesComponent.this.tableViewer.setComparator((ViewerComparator)this.sorter);
                VisualisationNotesComponent.this.tableViewer.getTable().setSortColumn(this.col);
            } else {
                VisualisationNotesComponent.this.tableViewer.getTable().setSortColumn(null);
            }
            VisualisationNotesComponent.this.tableViewer.getTable().setSortDirection(this.sorter.getSortDirection());
            this.sorter.changeSort();
        }
    }
}

